/*
 * Decompiled with CFR 0.152.
 */
package mca.core.forge;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.List;
import mca.ai.AICombat;
import mca.core.MCA;
import mca.core.forge.EventHooksFML;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import mca.enums.EnumCombatBehaviors;
import mca.enums.EnumProfession;
import mca.items.ItemBaby;
import mca.packets.PacketInteractWithPlayerC;
import mca.packets.PacketPlaySoundOnPlayer;
import mca.util.TutorialManager;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;

public class EventHooksForge {
    @SubscribeEvent
    public void entityJoinedWorldEventHandler(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && MCA.getConfig().canSpawnInDimension(event.world.field_73011_w.func_177502_q())) {
            if (event.entity instanceof EntityMob) {
                this.doAddMobTasks((EntityMob)event.entity);
            }
            if (event.entity.getClass() == EntityVillager.class && MCA.getConfig().overwriteOriginalVillagers) {
                EntityVillager villager = (EntityVillager)event.entity;
                List zombiesAroundMe = RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityZombie.class, (Entity)event.entity, (int)3);
                for (Entity entity : zombiesAroundMe) {
                    EntityZombie zombie = (EntityZombie)entity;
                    if (!zombie.func_82230_o()) continue;
                    boolean isMale = RadixLogic.getBooleanWithProbability((int)50);
                    EntityHuman human = new EntityHuman(entity.field_70170_p, isMale, EnumProfession.getAtRandom().getId(), false);
                    human.func_70107_b(zombie.field_70165_t, zombie.field_70163_u, zombie.field_70161_v);
                    entity.field_70170_p.func_72838_d((Entity)human);
                    event.entity.func_70106_y();
                    return;
                }
                if (villager.func_70946_n() >= 0 && villager.func_70946_n() <= 4) {
                    villager.func_70096_w().func_75682_a(28, (Object)3577);
                }
            }
        }
    }

    @SubscribeEvent
    public void renderGameOverlayEventHandler(RenderGameOverlayEvent.Text event) {
        TutorialManager.onUpdate();
    }

    private void doAddMobTasks(EntityMob mob) {
        if (MCA.getConfig().allowMobAttacks) {
            if (mob instanceof EntityEnderman) {
                return;
            }
            if (mob instanceof EntityCreeper) {
                mob.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)mob, EntityHuman.class, new Predicate(){

                    public boolean func_179958_a(Entity p_179958_1_) {
                        return p_179958_1_ instanceof EntityHuman;
                    }

                    public boolean apply(Object p_apply_1_) {
                        return this.func_179958_a((Entity)p_apply_1_);
                    }
                }, 6.0f, 1.0, 1.2));
            } else {
                float moveSpeed = 0.7f;
                if (mob instanceof EntitySpider) {
                    moveSpeed = 1.2f;
                } else if (mob instanceof EntitySkeleton) {
                    moveSpeed = 1.1f;
                } else if (mob instanceof EntityZombie) {
                    moveSpeed = 0.9f;
                }
                mob.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)mob, EntityHuman.class, (double)moveSpeed, false));
                mob.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, EntityHuman.class, false));
            }
        } else if (mob.field_70714_bg != null && mob.field_70715_bh.field_75782_a != null) {
            for (int i = 0; i < mob.field_70715_bh.field_75782_a.size(); ++i) {
                try {
                    EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)mob.field_70715_bh.field_75782_a.get(i);
                    if (!(task.field_75733_a instanceof EntityAINearestAttackableTarget)) continue;
                    EntityAINearestAttackableTarget nat = (EntityAINearestAttackableTarget)task.field_75733_a;
                    for (Field f : nat.getClass().getDeclaredFields()) {
                        if (!f.getType().equals(Class.class)) continue;
                        f.setAccessible(true);
                        Class targetClass = (Class)f.get(nat);
                        f.setAccessible(false);
                        if (!targetClass.isAssignableFrom(EntityVillager.class)) continue;
                        mob.field_70715_bh.func_85156_a((EntityAIBase)nat);
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public void entityInteractEventHandler(EntityInteractEvent event) {
        if (event.target instanceof EntityHorse) {
            EntityHorse entityHorse = (EntityHorse)event.target;
            if (entityHorse.field_70153_n instanceof EntityHuman) {
                EntityHuman entity = (EntityHuman)entityHorse.field_70153_n;
                entity.func_70085_c(event.entityPlayer);
            }
        } else if (event.target instanceof EntityPlayerMP && !event.entityPlayer.field_70170_p.field_72995_K && !event.entityPlayer.func_70005_c_().contains("[CoFH]")) {
            MCA.getPacketHandler().sendPacketToPlayer(new PacketInteractWithPlayerC(event.entityPlayer, (EntityPlayer)event.target), (EntityPlayerMP)event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void worldSaveEventHandler(WorldEvent.Unload event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.func_177502_q() == 0) {
            MCA.getCrashWatcher().checkForCrashReports();
        }
    }

    @SubscribeEvent
    public void playerInteractEventHandler(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.field_70153_n instanceof EntityHuman) {
            event.entityPlayer.field_70153_n.func_70078_a(null);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        PlayerMemory memory;
        AICombat combat;
        ItemStack[] human;
        List entityList;
        if (event.entityLiving instanceof EntityPlayer && event.source.func_76346_g() instanceof EntityLivingBase) {
            entityList = RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityHuman.class, (Entity)event.entityLiving, (int)15);
            for (Entity entity : entityList) {
                human = (ItemStack[])entity;
                combat = human.getAI(AICombat.class);
                memory = human.getPlayerMemory((EntityPlayer)event.entityLiving);
                if (!memory.getIsHiredBy() || human.getProfessionEnum() != EnumProfession.Warrior || combat.getMethodBehavior() == EnumCombatBehaviors.METHOD_DO_NOT_FIGHT || combat.getTriggerBehavior() != EnumCombatBehaviors.TRIGGER_PLAYER_TAKE_DAMAGE) continue;
                combat.setAttackTarget((EntityLivingBase)event.source.func_76346_g());
            }
        } else if (event.source.func_76346_g() instanceof EntityPlayer && event.entityLiving != null) {
            entityList = RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityHuman.class, (Entity)event.source.func_76346_g(), (int)15);
            for (Entity entity : entityList) {
                human = (EntityHuman)entity;
                combat = human.getAI(AICombat.class);
                memory = human.getPlayerMemory((EntityPlayer)event.source.func_76346_g());
                if (!memory.getIsHiredBy() || human.getProfessionEnum() != EnumProfession.Warrior || combat.getMethodBehavior() == EnumCombatBehaviors.METHOD_DO_NOT_FIGHT || combat.getTriggerBehavior() != EnumCombatBehaviors.TRIGGER_PLAYER_DEAL_DAMAGE) continue;
                combat.setAttackTarget(event.entityLiving);
            }
        }
        if (MCA.getConfig().enableInfection && event.source != null && event.source.func_76364_f() instanceof EntityZombie) {
            EntityZombie zombie = (EntityZombie)event.source.func_76364_f();
            boolean flag = RadixLogic.getBooleanWithProbability((int)3);
            if (event.entityLiving instanceof EntityPlayer && flag) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack == null || !(stack.func_77973_b() instanceof ItemBaby)) continue;
                    stack.func_77978_p().func_74757_a("isInfected", true);
                    player.func_146105_b((IChatComponent)new ChatComponentText("\u00a7C" + stack.func_77978_p().func_74779_i("name") + " has been " + "\u00a7A" + "\u00a7l" + "infected" + "\u00a7C" + "!"));
                    player.field_70170_p.func_72956_a((Entity)player, "mob.wither.idle", 0.5f, 1.0f);
                    Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.SPELL_WITCH, (Entity)player, 32);
                }
            } else if (event.entityLiving instanceof EntityHuman && flag) {
                EntityHuman human2 = (EntityHuman)event.entityLiving;
                if (human2.getProfessionEnum() == EnumProfession.Warrior) {
                    return;
                }
                for (int i = 1; i < 5; ++i) {
                    if (human2.func_71124_b(i) == null) continue;
                    return;
                }
                human2.setIsInfected(true);
                human2.func_70606_j(human2.func_110138_aP());
                zombie.func_70624_b(null);
                human2.field_70170_p.func_72956_a((Entity)human2, "mob.wither.idle", 0.5f, 1.0f);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.SPELL_WITCH, (Entity)human2, 32);
            } else if (event.entityLiving instanceof EntityHuman && ((EntityHuman)event.entityLiving).getIsInfected()) {
                event.setCanceled(true);
                zombie.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (event.entityLiving instanceof EntityMob && event.target instanceof EntityHuman) {
            EntityMob mob = (EntityMob)event.entityLiving;
            EntityHuman target = (EntityHuman)event.target;
            if (target.getIsInfected()) {
                mob.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onPlaceEvent(BlockEvent.PlaceEvent event) {
        int x = event.pos.func_177958_n();
        int y = event.pos.func_177956_o();
        int z = event.pos.func_177952_p();
        Block placedBlock = event.placedBlock.func_177230_c();
        if (placedBlock == Blocks.field_150480_ab && BlockHelper.getBlock((World)event.world, (int)x, (int)(y - 1), (int)z) == Blocks.field_150475_bE) {
            int totemsFound = 0;
            for (int i = 0; i < 4; ++i) {
                Block block;
                int dX = 0;
                int dZ = 0;
                switch (i) {
                    case 0: {
                        dX = -3;
                        break;
                    }
                    case 1: {
                        dX = 3;
                        break;
                    }
                    case 2: {
                        dZ = -3;
                        break;
                    }
                    case 3: {
                        dZ = 3;
                    }
                }
                for (int j = -1; j < 2 && ((block = BlockHelper.getBlock((World)event.world, (int)(x + dX), (int)(y + j), (int)(z + dZ))) == Blocks.field_150343_Z || block == Blocks.field_150480_ab); ++j) {
                    if (j != 1 || block != Blocks.field_150480_ab) continue;
                    ++totemsFound;
                }
            }
            if (totemsFound >= 3 && !event.world.func_72935_r()) {
                Point3D summonPoint = new Point3D(x, y + 5, z);
                NetworkRegistry.TargetPoint summonTarget = new NetworkRegistry.TargetPoint(event.world.field_73011_w.func_177502_q(), (double)summonPoint.iPosX, (double)(summonPoint.iPosY + 5), (double)summonPoint.iPosZ, 32.0);
                EventHooksFML.setReaperSummonPoint(event.world, new Point3D((double)x + 1.0, (double)(y + 5), (double)z + 1.0));
                MCA.getPacketHandler().sendPacketToAllAround(new PacketPlaySoundOnPlayer("portal.portal"), summonTarget);
                for (int i = 0; i < 2; ++i) {
                    Utilities.spawnParticlesAroundPointS(EnumParticleTypes.FLAME, event.world, x, y - i, z, 32);
                    BlockHelper.setBlock((World)event.world, (int)x, (int)(y - i), (int)z, (Block)Blocks.field_150350_a);
                }
            } else if (totemsFound >= 3 && event.world.func_72935_r()) {
                TutorialManager.sendMessageToPlayer(event.player, "The Grim Reaper must be summoned at night.", "");
            }
        }
    }
}

