/*
 * Decompiled with CFR 0.152.
 */
package mca.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mca.core.MCA;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public final class Config
implements Serializable {
    private final transient Configuration config;
    public int baseItemId;
    public int baseBlockId;
    public int baseEntityId;
    public boolean disableWeddingRingRecipe;
    public boolean overwriteOriginalVillagers;
    public boolean allowMobAttacks;
    public boolean shiftClickForPlayerMarriage;
    public boolean giveCrystalBall;
    public boolean disablePatreonButton;
    public boolean enableDiminishingReturns;
    public boolean enableInfection;
    public boolean enableStructureSpawning;
    public boolean serverEnableStructureSpawning;
    public boolean allowVillagerRevival;
    public Integer[] dimensionWhitelist;
    public String[] additionalGiftItems;
    public int guardSpawnRate;
    public int chanceToHaveTwins;
    public int villagerMaxHealth;
    public int villagerAttackDamage;
    public int guardMaxHealth;
    public int guardAttackDamage;
    public boolean storyProgression;
    public int storyProgressionThreshold;
    public int storyProgressionRate;
    public int roseGoldSpawnWeight;
    public int babyGrowUpTime;
    public int childGrowUpTime;
    public boolean isAgingEnabled;
    public int childLimit;
    public int villagerSpawnerCap;
    public int storyProgressionCap;
    public boolean allowFarmingChore;
    public boolean allowFishingChore;
    public boolean allowWoodcuttingChore;
    public boolean allowMiningChore;
    public boolean allowHuntingChore;
    public boolean allowGiftDemands;
    public boolean allowTrading;
    public boolean logVillagerDeaths;
    public boolean spawnInAllDimensions;
    public boolean replenishEmptyVillages;
    public String villagerChatPrefix;
    public boolean showMoodParticles;
    public boolean showNameTagOnHover;
    public boolean showVillagerConversations = false;
    public boolean modifyFemaleBody;
    public boolean allowBlinking;
    public boolean inTutorialMode;
    public boolean allowCrashReporting;
    public boolean allowUpdateChecking;
    public boolean showPlayerDataMigrationErrors;

    public Config(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.addConfigValues();
    }

    private void addConfigValues() {
        this.config.setCategoryComment("Init", "Settings that affect how MCA starts up.");
        this.baseItemId = this.config.get("Init", "Base Item ID", 35277, "The base ID to use for items in MCA. Only applicable in 1.6.4.").getInt();
        this.baseBlockId = this.config.get("Init", "Base Block ID", 3344, "The base ID to use for blocks in MCA. Only applicable in 1.6.4.").getInt();
        this.baseEntityId = this.config.get("Init", "Base Entity ID", 227, "The base ID to use for entities in MCA. Only change if you know what you are doing!").getInt();
        this.disableWeddingRingRecipe = this.config.get("Init", "Disable wedding ring recipe", false, "True if you want to disable the recipe for the wedding ring. It can confict with a few mods. Rose gold can be used as an alternative.").getBoolean();
        this.config.setCategoryComment("Privacy", "Setting pertaining to your privacy while using MCA.");
        this.allowCrashReporting = this.config.get("Privacy", "Allow crash reporting", true, "True if MCA can send crash reports to the mod authors. Crash reports may include your Minecraft username, OS version, Java version, and PC username.").getBoolean();
        this.allowUpdateChecking = this.config.get("Privacy", "Allow update checking", true, "True if MCA can check for updates. This setting requires a restart in order to take effect.").getBoolean();
        this.config.setCategoryComment("General", "General mod settings.");
        this.giveCrystalBall = this.config.get("General", "Give crystal ball", true, "Toggles giving the crystal ball to new players on join. WARNING: If this is false, you must spawn the crystal ball in later manually!").getBoolean();
        this.disablePatreonButton = this.config.get("General", "Disable patreon button", false, "Allows you to toggle the Patreon button on and off.").getBoolean();
        this.overwriteOriginalVillagers = this.config.get("General", "Overwrite original villagers", true).getBoolean();
        this.shiftClickForPlayerMarriage = this.config.get("General", "Shift-click for player marriage menu", false, "True if you must hold shift then right click a player to open the marriage menu. Useful on PvP servers.").getBoolean();
        this.chanceToHaveTwins = this.config.get("General", "Chance to have twins", 2, "Your percent chance of having twins.").getInt();
        this.guardSpawnRate = this.config.get("General", "Guard spawn rate", 3, "One guard per this many villagers. Set to zero or a negative number to disable guards.").getInt();
        this.enableDiminishingReturns = this.config.get("General", "Enable diminishing returns?", true, "True if hearts increase decreases after multiple interactions.").getBoolean();
        this.enableInfection = this.config.get("General", "Enable infection?", true, "True if villagers and your children have a chance of being infected from zombies.").getBoolean();
        this.enableStructureSpawning = this.config.get("General", "Enable structure spawning?", true, "True if players can have the option to spawn structures during MCA's setup. Single player only!").getBoolean();
        this.spawnInAllDimensions = this.config.get("General", "Spawn villagers in all dimensions?", false, "True if you want to ignore the dimension whitelist and spawn MCA villagers in all worlds.").getBoolean();
        this.replenishEmptyVillages = this.config.get("General", "Replenish empty villages?", true, "True if villagers can spawn within villages that have very few or no villagers. Controlled by vanilla village requirements.").getBoolean();
        if (this.spawnInAllDimensions) {
            MCA.getLog().info("MCA is configured to spawn villagers in all dimensions. The dimension whitelist will be ignored.");
        } else {
            String validDimensions = this.config.get("General", "Dimension whitelist", "0, 1, -1", "The dimension IDs in which MCA villagers can spawn, separated by a comma.").getString();
            ArrayList<Integer> dimensionsList = new ArrayList<Integer>();
            for (String s : validDimensions.split(",")) {
                s = s.trim();
                try {
                    int intValue = Integer.parseInt(s);
                    dimensionsList.add(intValue);
                }
                catch (NumberFormatException e) {
                    MCA.getLog().error("Unable to parse dimension ID provided in config: " + s);
                }
            }
            if (dimensionsList.isEmpty()) {
                MCA.getLog().info("Detected empty dimension whitelist, adding dimension 0 as default.");
                dimensionsList.add(0);
            }
            this.dimensionWhitelist = dimensionsList.toArray(new Integer[dimensionsList.size()]);
        }
        this.villagerMaxHealth = this.config.get("General", "Villager max health", 20).getInt();
        this.villagerAttackDamage = this.config.get("General", "Villager attack damage", 2, "How many half-hearts of damage a villager can deal without a weapon. Does not affect players.").getInt();
        this.guardMaxHealth = this.config.get("General", "Guard max health", 40).getInt();
        this.guardAttackDamage = this.config.get("General", "Guard attack damage", 8, "How many half-hearts of damage a guard can deal. Does not affect players.").getInt();
        this.storyProgression = this.config.get("General", "Story progression", true, "Villagers automatically get married, have children, etc.").getBoolean();
        this.storyProgressionThreshold = this.config.get("General", "Story progression threshold", 120, "Amount of time a villager has to be alive before story progression begins to affect them. This value is in MINUTES, default is 120. Range (1 and above)").getInt();
        this.storyProgressionRate = this.config.get("General", "Story progression rate", 20, "How often story progression tries to make changes. Changes may not always be made. This value is in MINUTES, default is 20. Range (1 and above)").getInt();
        this.storyProgressionCap = this.config.get("General", "Story progression spawn cap", -1, "Determines whether or not story progression will occur based on this number of villagers within a 32 block radius. Set to -1 to disable. 16 is recommended.").getInt();
        this.inTutorialMode = this.config.get("General", "Tutorial mode", true, "Displays various tips while you play. ").getBoolean();
        this.allowMobAttacks = this.config.get("General", "Allow mob attacks", true, "True if regular Minecraft mobs can attack villagers. False to prevent mobs from attacking any villager.").getBoolean();
        this.config.setCategoryComment("World Generation", "All settings related to MCA's world generation.");
        this.roseGoldSpawnWeight = this.config.get("World Generation", "Rose gold spawn weight", 1, "Sets the spawn weight for rose gold. Higher numbers = less common. Set to zero to disable.").getInt();
        this.config.setCategoryComment("Aging", "All aging-related settings of villagers and children in-game.");
        this.babyGrowUpTime = this.config.get("Aging", "Time until babies grow up (in minutes)", 10).getInt();
        this.childGrowUpTime = this.config.get("Aging", "Time until children grow up (in minutes)", 180).getInt();
        this.isAgingEnabled = this.config.get("Aging", "Enable aging", true).getBoolean();
        this.config.setCategoryComment("Graphics", "All graphics-related settings are located here.");
        this.showMoodParticles = this.config.get("Graphics", "Show mood particles", true, "True if you want for particles to appear around villagers if they are in a certain mood").getBoolean();
        this.showNameTagOnHover = this.config.get("Graphics", "Show name tag on hover", true, "True if you want a villager's name to appear above their head when you hover over them.").getBoolean();
        this.modifyFemaleBody = this.config.get("Graphics", "Modify female body", true, "True if you want a female villager to render with breasts, curves, etc.").getBoolean();
        this.allowBlinking = this.config.get("Graphics", "Allow blinking", true, "True if you want to see villagers blink their eyes at random.").getBoolean();
        this.config.setCategoryComment("Server", "All settings that server administrators may want to configure.");
        this.childLimit = this.config.get("Server", "Child limit", -1).getInt();
        this.villagerSpawnerCap = this.config.get("Server", "Villager spawner cap", 16, "How many villagers maximum that can be within a 32 block radius of any villager spawner block.").getInt();
        this.allowFarmingChore = this.config.get("Server", "Allow farming chore", true).getBoolean();
        this.allowFishingChore = this.config.get("Server", "Allow fishing chore", true).getBoolean();
        this.allowWoodcuttingChore = this.config.get("Server", "Allow woodcutting chore", true).getBoolean();
        this.allowMiningChore = this.config.get("Server", "Allow mining chore", true).getBoolean();
        this.allowHuntingChore = this.config.get("Server", "Allow hunting chore", true).getBoolean();
        this.allowGiftDemands = this.config.get("Server", "Allow gift demands", true).getBoolean();
        this.allowTrading = this.config.get("Server", "Allow trading", true).getBoolean();
        this.logVillagerDeaths = this.config.get("Server", "Log villager deaths", false, "True if you want villager deaths to be logged to the console/server logs. Shows 'RMFS' values in console, R = related, M = mother, F = father, S = spouse. Can be a bit spammy!").getBoolean();
        this.villagerChatPrefix = this.config.get("Server", "Villager chat prefix", "").getDefault();
        this.serverEnableStructureSpawning = this.config.get("Server", "Enable structure spawning on server?", false, "True if players can have the option to spawn structures during MCA's setup on a server. WARNING: POTENTIAL FOR GRIEFING IS VERY HIGH - YOU HAVE BEEN WARNED").getBoolean();
        this.allowVillagerRevival = this.config.get("Server", "Allow dead villagers to be revived?", true, "True if players can have the ability to revive villagers they are related to. Creates a file in [world name]/data/ that could become very large on big servers.").getBoolean();
        this.showPlayerDataMigrationErrors = this.config.get("Server", "Show player data migration errors?", true, "If you're updating MCA on an existing world, some internal migrations of data must be performed. This can be error prone, but if you want to ignore these errors, set this to false - NOT RECOMMENDED! YOUR PLAYERS COULD LOSE PROGRESS!").getBoolean();
        this.additionalGiftItems = this.config.get("Server", "Additional gifts", new String[]{"#<EXAMPLE> fermented_spider_eye|25", "#<EXAMPLE> poisonous_potato|12"}, "The names of the items/blocks that can be gifted in addition to the default items. Include hearts value preceded by |. 10 hearts points equals 1 heart.").getStringList();
        this.config.save();
    }

    public void syncConfiguration() {
        this.config.load();
        this.addConfigValues();
        this.config.save();
    }

    public Configuration getInstance() {
        return this.config;
    }

    public List<IConfigElement> getCategories() {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        for (String s : this.config.getCategoryNames()) {
            if (s.equals("server")) continue;
            ConfigElement element = new ConfigElement(this.config.getCategory(s));
            for (IConfigElement e : element.getChildElements()) {
                elements.add(e);
            }
        }
        return elements;
    }

    public boolean canSpawnInDimension(int dimensionId) {
        if (this.spawnInAllDimensions) {
            return true;
        }
        Integer[] integerArray = this.dimensionWhitelist;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            if (i2 != dimensionId) continue;
            return true;
        }
        return false;
    }
}

