/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mca.ai.AISleep;
import mca.core.MCA;
import mca.entity.EntityHuman;
import mca.enums.EnumPersonality;
import mca.enums.EnumProfession;
import mca.enums.EnumSleepingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import radixcore.data.DataWatcherEx;
import radixcore.util.NumberCycleList;

@SideOnly(value=Side.CLIENT)
public class GuiVillagerEditor
extends GuiScreen {
    private final EntityHuman villager;
    private final EntityPlayer player;
    private GuiButton familyTreeButton;
    private GuiTextField nameTextField;
    private GuiTextField dummyTextField;
    private GuiTextField playerSkinTextField;
    private GuiButton randomButton;
    private GuiButton genderButton;
    private GuiButton shiftTextureIndexUpButton;
    private GuiButton shiftTextureIndexDownButton;
    private GuiButton professionButton;
    private GuiButton shiftProfessionUpButton;
    private GuiButton shiftProfessionDownButton;
    private GuiButton shiftTraitUpButton;
    private GuiButton shiftTraitDownButton;
    private GuiButton applyPlayerSkinButton;
    private GuiButton heightButton;
    private GuiButton shiftHeightUpButton;
    private GuiButton shiftHeightDownButton;
    private GuiButton girthButton;
    private GuiButton shiftGirthUpButton;
    private GuiButton shiftGirthDownButton;
    private GuiButton isInfectedButton;
    private GuiButton clearInteractionFlagButton;
    private GuiButton backButton;
    private GuiButton nextButton;
    private GuiButton doneButton;
    private GuiButton textureButton;
    private GuiButton personalityButton;
    private int moodListIndex = 0;
    private int currentPage = 1;
    private NumberCycleList textures;
    private NumberCycleList jobs;
    private NumberCycleList personalities;

    public GuiVillagerEditor(EntityHuman EntityHuman2, EntityPlayer player) {
        this.player = player;
        this.villager = EntityHuman2;
        DataWatcherEx.allowClientSideModification = true;
        this.villager.getAI(AISleep.class).setSleepingState(EnumSleepingState.INTERRUPTED);
        this.jobs = NumberCycleList.fromList(EnumProfession.getListOfIds());
        this.personalities = NumberCycleList.fromList(EnumPersonality.getListOfIds());
        this.textures = this.villager.getProfessionGroup().getListOfSkinIDs(this.villager.getIsMale());
    }

    public void func_73876_c() {
        super.func_73876_c();
        try {
            this.nameTextField.func_146178_a();
            this.playerSkinTextField.func_146178_a();
            this.doneButton.field_146124_l = !this.nameTextField.func_146179_b().isEmpty();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.drawEditorGuiPage1();
        this.nameTextField = new GuiTextField(1, this.field_146289_q, this.field_146294_l / 2 - 205, this.field_146295_m / 2 - 95, 150, 20);
        this.nameTextField.func_146203_f(32);
        this.nameTextField.func_146180_a(this.villager.func_70005_c_());
        this.dummyTextField = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 + 90, this.field_146295_m / 2 - 100, 100, 200);
        this.dummyTextField.func_146203_f(0);
        this.playerSkinTextField = new GuiTextField(3, this.field_146289_q, this.field_146294_l / 2 - 205, this.field_146295_m / 2 + 40, 150, 20);
        this.playerSkinTextField.func_146203_f(32);
        this.playerSkinTextField.func_146180_a(this.villager.usesPlayerSkin() ? this.villager.getPlayerSkinUsername() : "N/A");
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.villager.displayNameForPlayer = false;
        DataWatcherEx.allowClientSideModification = true;
        this.villager.setIsInteracting(false);
        DataWatcherEx.allowClientSideModification = false;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        if (guibutton == this.doneButton) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (guibutton == this.randomButton) {
            this.nameTextField.func_146180_a(this.villager.getIsMale() ? MCA.getLanguageManager().getString("name.male") : MCA.getLanguageManager().getString("name.female"));
            this.villager.setName(this.nameTextField.func_146179_b());
            this.nameTextField.func_146192_a(5, 5, 5);
            this.drawEditorGuiPage1();
        } else if (guibutton == this.genderButton) {
            this.villager.setIsMale(!this.villager.getIsMale());
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftTextureIndexUpButton) {
            this.textures.next();
            String skin = this.villager.getHeadTexture();
            this.villager.setHeadTexture(skin.replaceAll("\\d+", String.valueOf(this.textures.get())));
            this.villager.setClothesTexture(this.villager.getHeadTexture());
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftTextureIndexDownButton) {
            this.textures.previous();
            String skin = this.villager.getHeadTexture();
            this.villager.setHeadTexture(skin.replaceAll("\\d+", String.valueOf(this.textures.get())));
            this.villager.setClothesTexture(this.villager.getHeadTexture());
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftProfessionUpButton) {
            this.villager.setProfessionId(this.jobs.next());
            this.textures = this.villager.getProfessionGroup().getListOfSkinIDs(this.villager.getIsMale());
            this.villager.setHeadTexture(this.villager.getRandomSkin());
            this.villager.setClothesTexture(this.villager.getHeadTexture());
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftProfessionDownButton) {
            this.villager.setProfessionId(this.jobs.previous());
            this.textures = this.villager.getProfessionGroup().getListOfSkinIDs(this.villager.getIsMale());
            this.villager.setHeadTexture(this.villager.getRandomSkin());
            this.villager.setClothesTexture(this.villager.getHeadTexture());
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftTraitUpButton) {
            this.villager.setPersonality(this.personalities.next());
            this.drawEditorGuiPage1();
        } else if (guibutton == this.shiftTraitDownButton) {
            this.villager.setPersonality(this.personalities.previous());
            this.drawEditorGuiPage1();
        } else if (guibutton == this.nextButton) {
            switch (this.currentPage) {
                case 1: {
                    this.drawEditorGuiPage2();
                    break;
                }
                case 2: {
                    this.drawEditorGuiPage2();
                }
            }
        } else if (guibutton == this.backButton) {
            switch (this.currentPage) {
                case 1: {
                    this.drawEditorGuiPage1();
                    break;
                }
                case 2: {
                    this.drawEditorGuiPage1();
                }
            }
        } else if (guibutton == this.shiftHeightUpButton) {
            this.villager.setHeight(this.villager.getHeight() + 0.01f);
            this.drawEditorGuiPage2();
        } else if (guibutton == this.shiftHeightDownButton) {
            this.villager.setHeight(this.villager.getHeight() - 0.01f);
            this.drawEditorGuiPage2();
        } else if (guibutton == this.shiftGirthUpButton) {
            this.villager.setGirth(this.villager.getGirth() + 0.01f);
            this.drawEditorGuiPage2();
        } else if (guibutton == this.shiftGirthDownButton) {
            this.villager.setGirth(this.villager.getGirth() - 0.01f);
            this.drawEditorGuiPage2();
        } else if (guibutton == this.applyPlayerSkinButton) {
            if (this.playerSkinTextField.func_146179_b().equals("")) {
                this.villager.setPlayerSkin("");
            } else {
                this.villager.setPlayerSkin(this.playerSkinTextField.func_146179_b().trim());
            }
        } else if (guibutton == this.isInfectedButton) {
            this.villager.setIsInfected(!this.villager.getIsInfected());
            this.drawEditorGuiPage2();
        } else if (guibutton == this.clearInteractionFlagButton) {
            this.villager.setIsInteracting(false);
            this.player.func_146105_b((IChatComponent)new ChatComponentText("\u00a7A[MCA] Interaction flag cleared."));
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (i == 1) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (this.currentPage == 1) {
            this.nameTextField.func_146201_a(c, i);
            String text = this.nameTextField.func_146179_b().trim();
            this.villager.setName(text);
            this.playerSkinTextField.func_146201_a(c, i);
            this.drawEditorGuiPage1();
        } else {
            super.func_73869_a(c, i);
        }
    }

    protected void func_73864_a(int clickX, int clickY, int clicked) throws IOException {
        super.func_73864_a(clickX, clickY, clicked);
        if (this.currentPage == 1) {
            this.nameTextField.func_146192_a(clickX, clickY, clicked);
            this.playerSkinTextField.func_146192_a(clickX, clickY, clicked);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawEditorGuiPage1() {
        this.currentPage = 1;
        this.field_146292_n.clear();
        int n = this.field_146294_l / 2 - 50;
        int n2 = this.field_146295_m / 2 - 95;
        MCA.getInstance();
        this.randomButton = new GuiButton(1, n, n2, 60, 20, MCA.getLanguageManager().getString("gui.button.random"));
        this.field_146292_n.add(this.randomButton);
        int n3 = this.field_146294_l / 2 - 190;
        int n4 = this.field_146295_m / 2 - 60;
        MCA.getInstance();
        this.genderButton = new GuiButton(2, n3, n4, 175, 20, MCA.getLanguageManager().getString("gui.button.setup.gender." + this.villager.getIsMale()));
        this.field_146292_n.add(this.genderButton);
        this.textureButton = new GuiButton(3, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 40, 175, 20, "Texture: " + this.villager.getHeadTexture().replace("mca:textures/skins/", "").replace(".png", ""));
        this.field_146292_n.add(this.textureButton);
        this.shiftTextureIndexUpButton = new GuiButton(4, this.field_146294_l / 2 - 15, this.field_146295_m / 2 - 40, 20, 20, ">>");
        this.field_146292_n.add(this.shiftTextureIndexUpButton);
        this.shiftTextureIndexDownButton = new GuiButton(5, this.field_146294_l / 2 - 210, this.field_146295_m / 2 - 40, 20, 20, "<<");
        this.field_146292_n.add(this.shiftTextureIndexDownButton);
        this.professionButton = new GuiButton(6, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 20, 175, 20, "Job: " + this.villager.getProfessionEnum().getUserFriendlyForm(this.villager));
        this.field_146292_n.add(this.professionButton);
        this.shiftProfessionUpButton = new GuiButton(7, this.field_146294_l / 2 - 15, this.field_146295_m / 2 - 20, 20, 20, ">>");
        this.field_146292_n.add(this.shiftProfessionUpButton);
        this.shiftProfessionDownButton = new GuiButton(8, this.field_146294_l / 2 - 210, this.field_146295_m / 2 - 20, 20, 20, "<<");
        this.field_146292_n.add(this.shiftProfessionDownButton);
        int n5 = this.field_146294_l / 2 - 190;
        int n6 = this.field_146295_m / 2 + 0;
        MCA.getInstance();
        this.personalityButton = new GuiButton(12, n5, n6, 175, 20, MCA.getLanguageManager().getString("gui.info.personality", new Object[]{this.villager.getPersonality().getFriendlyName()}));
        this.field_146292_n.add(this.personalityButton);
        this.shiftTraitUpButton = new GuiButton(13, this.field_146294_l / 2 - 15, this.field_146295_m / 2 + 0, 20, 20, ">>");
        this.field_146292_n.add(this.shiftTraitUpButton);
        this.shiftTraitDownButton = new GuiButton(14, this.field_146294_l / 2 - 210, this.field_146295_m / 2 + 0, 20, 20, "<<");
        this.field_146292_n.add(this.shiftTraitDownButton);
        int n7 = this.field_146294_l / 2 - 50;
        int n8 = this.field_146295_m / 2 + 85;
        MCA.getInstance();
        this.doneButton = new GuiButton(17, n7, n8, 75, 20, MCA.getLanguageManager().getString("gui.button.done"));
        this.field_146292_n.add(this.doneButton);
        int n9 = this.field_146294_l / 2 + 25;
        int n10 = this.field_146295_m / 2 + 85;
        MCA.getInstance();
        this.nextButton = new GuiButton(18, n9, n10, 50, 20, MCA.getLanguageManager().getString("gui.button.next"));
        this.field_146292_n.add(this.nextButton);
        int n11 = this.field_146294_l / 2 - 101;
        int n12 = this.field_146295_m / 2 + 85;
        MCA.getInstance();
        this.backButton = new GuiButton(19, n11, n12, 50, 20, MCA.getLanguageManager().getString("gui.button.back"));
        this.field_146292_n.add(this.backButton);
        this.backButton.field_146124_l = false;
    }

    private void drawEditorGuiPage2() {
        int displayHeight = Math.round(this.villager.getHeight() * 100.0f);
        int displayGirth = Math.round(this.villager.getGirth() * 100.0f);
        this.currentPage = 2;
        this.field_146292_n.clear();
        this.heightButton = new GuiButton(1, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 40, 175, 20, "Height Factor: " + displayHeight);
        this.field_146292_n.add(this.heightButton);
        this.shiftHeightUpButton = new GuiButton(2, this.field_146294_l / 2 - 15, this.field_146295_m / 2 - 40, 20, 20, ">>");
        this.field_146292_n.add(this.shiftHeightUpButton);
        this.shiftHeightDownButton = new GuiButton(3, this.field_146294_l / 2 - 210, this.field_146295_m / 2 - 40, 20, 20, "<<");
        this.field_146292_n.add(this.shiftHeightDownButton);
        this.girthButton = new GuiButton(4, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 20, 175, 20, "Girth Factor: " + displayGirth);
        this.field_146292_n.add(this.girthButton);
        this.shiftGirthUpButton = new GuiButton(5, this.field_146294_l / 2 - 15, this.field_146295_m / 2 - 20, 20, 20, ">>");
        this.field_146292_n.add(this.shiftGirthUpButton);
        this.shiftGirthDownButton = new GuiButton(6, this.field_146294_l / 2 - 210, this.field_146295_m / 2 - 20, 20, 20, "<<");
        this.field_146292_n.add(this.shiftGirthDownButton);
        this.isInfectedButton = new GuiButton(7, this.field_146294_l / 2 - 190, this.field_146295_m / 2 - 0, 175, 20, "Is Infected: " + this.villager.getIsInfected());
        this.field_146292_n.add(this.isInfectedButton);
        this.clearInteractionFlagButton = new GuiButton(8, this.field_146294_l / 2 - 190, this.field_146295_m / 2 + 20, 175, 20, "Clear Interaction Flag");
        this.field_146292_n.add(this.clearInteractionFlagButton);
        int n = this.field_146294_l / 2 - 50;
        int n2 = this.field_146295_m / 2 + 85;
        MCA.getInstance();
        this.doneButton = new GuiButton(16, n, n2, 75, 20, MCA.getLanguageManager().getString("gui.button.done"));
        this.field_146292_n.add(this.doneButton);
        int n3 = this.field_146294_l / 2 + 25;
        int n4 = this.field_146295_m / 2 + 85;
        MCA.getInstance();
        this.nextButton = new GuiButton(17, n3, n4, 50, 20, MCA.getLanguageManager().getString("gui.button.next"));
        this.field_146292_n.add(this.nextButton);
        int n5 = this.field_146294_l / 2 - 101;
        int n6 = this.field_146295_m / 2 + 85;
        MCA.getInstance();
        this.backButton = new GuiButton(18, n5, n6, 50, 20, MCA.getLanguageManager().getString("gui.button.back"));
        this.field_146292_n.add(this.backButton);
        this.nextButton.field_146124_l = false;
    }

    public void func_73863_a(int sizeX, int sizeY, float offset) {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
        if (this.currentPage != -1) {
            int posX = this.field_146294_l / 2 + 140;
            int posY = this.field_146295_m / 2 + 95;
            int scale = 80;
            if (!this.villager.getAI(AISleep.class).getIsSleeping()) {
                posY = this.field_146295_m / 2 + 80;
            }
            GL11.glEnable((int)2903);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)posX, (float)posY, (float)50.0f);
            GL11.glScalef((float)-80.0f, (float)80.0f, (float)80.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float yawOffset = this.villager.field_70761_aq;
            float rotationYaw = this.villager.field_70177_z;
            float rotationPitch = this.villager.field_70125_A;
            GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)Math.atan(0.0)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            this.villager.field_70761_aq = (float)Math.atan(0.0) * 20.0f;
            this.villager.field_70177_z = (float)Math.atan(0.0) * 40.0f;
            this.villager.field_70125_A = -((float)Math.atan(0.0)) * 20.0f;
            this.villager.field_70759_as = this.villager.field_70177_z;
            GL11.glTranslated((double)0.0, (double)this.villager.func_70033_W(), (double)0.0);
            Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
            Minecraft.func_71410_x().func_175598_ae().func_147940_a((Entity)this.villager, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            this.villager.field_70761_aq = yawOffset;
            this.villager.field_70177_z = rotationYaw;
            this.villager.field_70125_A = rotationPitch;
            GL11.glPopMatrix();
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GL11.glDisable((int)3553);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            this.dummyTextField.func_146194_f();
        }
        if (this.currentPage == 1) {
            this.func_73731_b(this.field_146289_q, "Name:", this.field_146294_l / 2 - 205, this.field_146295_m / 2 - 110, 0xFFFFFF);
            MCA.getInstance();
            this.func_73731_b(this.field_146289_q, MCA.getLanguageManager().getString("gui.title.editor"), this.field_146294_l / 2 - 205, this.field_146295_m / 2 - 87, 0xA0A0A0);
            this.nameTextField.func_146194_f();
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        MCA.getInstance();
        this.func_73732_a(this.field_146289_q, MCA.getLanguageManager().getString("gui.title.editor"), this.field_146294_l / 2 - 75, this.field_146295_m / 2 - 125, 0xFFFFFF);
        GL11.glPopMatrix();
        super.func_73863_a(sizeX, sizeY, offset);
    }

    private void sortTextureList(List<String> listToSort) {
        Collections.sort(listToSort, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int skinNumber2;
                int skinNumber1 = Integer.parseInt(o1.replaceAll("[^0-9]+", " ").trim());
                if (skinNumber1 == (skinNumber2 = Integer.parseInt(o2.replaceAll("[^0-9]+", " ").trim()))) {
                    return 0;
                }
                if (skinNumber1 < skinNumber2) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

