/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.shadowmobs.model;

import lycanite.lycanitesmobs.api.model.ModelCustomObj;
import lycanite.lycanitesmobs.shadowmobs.ShadowMobs;
import lycanite.lycanitesmobs.shadowmobs.entity.EntityDarkling;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelDarkling
extends ModelCustomObj {
    public ModelDarkling() {
        this(1.0f);
    }

    public ModelDarkling(float shadowSize) {
        this.initModel("darkling", ShadowMobs.group, "entity/darkling");
        this.setPartCenter("head", 0.0f, 0.24833f, -0.36996f);
        this.setPartCenter("mouthleft", 0.16218f, 0.2703f, -0.46631f);
        this.setPartCenter("mouthright", -0.16218f, 0.2703f, -0.46631f);
        this.setPartCenter("body", 0.0f, 0.28549f, -0.05173f);
        this.setPartCenter("legleftfront", 0.132f, 0.24f, 0.0168f);
        this.setPartCenter("legleftmiddle", 0.12f, 0.24f, 0.1032f);
        this.setPartCenter("legleftback", 0.072f, 0.24f, 0.192f);
        this.setPartCenter("legrightfront", -0.132f, 0.24f, 0.0168f);
        this.setPartCenter("legrightmiddle", -0.12f, 0.24f, 0.1032f);
        this.setPartCenter("legrightback", -0.072f, 0.24f, 0.192f);
        this.lockHeadX = true;
        this.lockHeadY = true;
        this.trophyScale = 1.0f;
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float bob;
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("mouthleft") || partName.equals("mouthright")) {
            this.centerPartToPart(partName, "head");
            if (!this.lockHeadX) {
                rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f));
            }
            if (!this.lockHeadY) {
                rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f));
            }
            this.uncenterPartToPart(partName, "head");
        }
        if (partName.equals("mouthleft")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f + (float)Math.PI)) * 0.05f - 0.05f)), 0.0f, 0.0f);
        }
        if (partName.equals("mouthright")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f)), 0.0f, 0.0f);
        }
        if (partName.equals("legleftfront") || partName.equals("legleftback") || partName.equals("legrightmiddle") || partName.equals("legleftmiddle") || partName.equals("legrightfront") || partName.equals("legrightback")) {
            angleZ = 1.0f;
        }
        if (partName.equals("legleftfront")) {
            angleY = 0.055555556f;
        }
        if (partName.equals("legleftmiddle")) {
            angleY = -5.0f;
        }
        if (partName.equals("legleftback")) {
            angleY = -0.06944445f;
        }
        if (partName.equals("legrightfront")) {
            angleY = -0.055555556f;
        }
        if (partName.equals("legrightmiddle")) {
            angleY = 5.0f;
        }
        if (partName.equals("legrightback")) {
            angleY = 0.06944445f;
        }
        float walkSwing = 0.3f;
        if (partName.equals("legleftfront") || partName.equals("legleftback") || partName.equals("legrightmiddle")) {
            rotation = (float)((double)rotation + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance));
        }
        if (partName.equals("legleftmiddle") || partName.equals("legrightfront") || partName.equals("legrightback")) {
            rotation = (float)((double)rotation + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        if ((bob = MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance) < 0.0f) {
            bob += -bob * 2.0f;
        }
        posY += bob;
        if (entity instanceof EntityDarkling && ((EntityDarkling)entity).hasLatchTarget()) {
            this.uncenterPart(partName);
            this.rotate(-90.0f, 0.0f, 0.0f);
            this.centerPart(partName);
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

