/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.shadowmobs.entity;

import java.util.ArrayList;
import java.util.HashMap;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupShadow;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowOwner;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIStealth;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetOwnerThreats;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityGrue
extends EntityCreatureTameable
implements IMob,
IGroupShadow {
    private int teleportTime = 60;

    public EntityGrue(World par1World) {
        super(par1World);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 1;
        this.experience = 5;
        this.hasAttackSound = true;
        this.setWidth = 0.8f;
        this.setHeight = 1.2f;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIStealth(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee(this).setRate(20).setLongMemory(true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.32);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 2.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151079_bi), 0.5f).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150343_Z), 0.5f).setMaxAmount(2));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("soulstoneshadow")), 1.0f).setMaxAmount(1).setSubspecies(3));
    }

    @Override
    public void func_70105_a(float width, float height) {
        if (this.getSubspeciesIndex() == 3) {
            super.func_70105_a(width * 2.0f, height * 2.0f);
            return;
        }
        super.func_70105_a(width, height);
    }

    @Override
    public double getRenderScale() {
        if (this.getSubspeciesIndex() == 3) {
            return this.sizeScale * 2.0;
        }
        return this.sizeScale;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.hasAttackTarget() && this.teleportTime-- <= 0) {
            this.teleportTime = 60 + this.func_70681_au().nextInt(40);
            if (this.func_70638_az() instanceof EntityPlayer) {
                this.teleportTime *= 3;
            }
            this.playJumpSound();
            BlockPos teleportPosition = this.getFacingPosition((Entity)this.func_70638_az(), (double)(-this.func_70638_az().field_70130_N) - 1.0, 0.0);
            if (this.canTeleportTo(this.field_70170_p, teleportPosition) && this.canTeleportTo(this.field_70170_p, new BlockPos(teleportPosition.func_177958_n(), teleportPosition.func_177956_o() + 1, teleportPosition.func_177952_p()))) {
                this.func_70107_b(teleportPosition.func_177958_n(), teleportPosition.func_177956_o(), teleportPosition.func_177952_p());
            } else if (this.canTeleportTo(this.field_70170_p, teleportPosition) && this.canTeleportTo(this.field_70170_p, teleportPosition)) {
                this.func_70107_b(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean canTeleportTo(World world, BlockPos pos) {
        IBlockState blockState = this.field_70170_p.func_180495_p(pos);
        if (blockState.func_177230_c() == null) {
            return false;
        }
        if (blockState.func_185915_l()) {
            return false;
        }
        if (this.getSubspeciesIndex() >= 3) {
            return true;
        }
        return this.testLightLevel(pos) <= 1;
    }

    @Override
    public boolean canStealth() {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isMoving()) {
            return false;
        }
        return this.testLightLevel() <= 0;
    }

    @Override
    public void startStealth() {
        if (this.field_70170_p.field_72995_K) {
            EnumParticleTypes particle = EnumParticleTypes.SPELL_WITCH;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            for (int i = 0; i < 100; ++i) {
                this.field_70170_p.func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
        super.startStealth();
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (this.getSubspeciesIndex() > 2 && target instanceof EntityLivingBase) {
            EntityLivingBase targetLiving = (EntityLivingBase)target;
            ArrayList<Potion> goodEffects = new ArrayList<Potion>();
            for (Object potionEffectObj : targetLiving.func_70651_bq()) {
                Potion potion;
                if (!(potionEffectObj instanceof PotionEffect) || (potion = ((PotionEffect)potionEffectObj).func_188419_a()) == null || !ObjectLists.inEffectList("buffs", potion)) continue;
                goodEffects.add(potion);
            }
            if (goodEffects.size() > 0) {
                if (goodEffects.size() > 1) {
                    targetLiving.func_184589_d((Potion)goodEffects.get(this.func_70681_au().nextInt(goodEffects.size())));
                } else {
                    targetLiving.func_184589_d((Potion)goodEffects.get(0));
                }
                float leeching = this.getAttackDamage(damageScale);
                this.func_70691_i(leeching);
            }
        }
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, this.getEffectDuration(7), 0));
        }
        return true;
    }

    @Override
    public boolean canFly() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76440_q) {
            return false;
        }
        if (ObjectManager.getPotionEffect("Fear") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("Fear")) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public boolean daylightBurns() {
        return !this.isTamed() && this.getSubspeciesIndex() < 3;
    }
}

