/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.plainsmobs.entity;

import java.util.HashMap;
import lycanite.lycanitesmobs.ExtendedEntity;
import lycanite.lycanitesmobs.api.IGroupHunter;
import lycanite.lycanitesmobs.api.IGroupPrey;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIAttackMelee;
import lycanite.lycanitesmobs.api.entity.ai.EntityAILookIdle;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetAttack;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWatchClosest;
import lycanite.lycanitesmobs.api.info.DropRate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityRoc
extends EntityCreatureBase
implements IMob,
IGroupHunter {
    public EntityAIAttackMelee attackAI = new EntityAIAttackMelee(this).setLongMemory(false);
    public boolean creeperDropping = true;
    int creeperDropCooldown = 0;

    public EntityRoc(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 0;
        this.experience = 7;
        this.hasAttackSound = true;
        this.flySoundSpeed = 20;
        this.creeperDropping = ConfigBase.getConfig(this.group, "general").getBool("Features", "Roc Creeper Dropping", this.creeperDropping, "Set to false to prevent Rocs from picking up Creepers to drop on their victims!");
        this.setWidth = 0.8f;
        this.setHeight = 1.8f;
        this.setupMob();
        this.field_70138_W = 1.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.attackAI);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this).setPauseRate(0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityCreeper.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 15.0);
        baseAttributes.put("movementSpeed", 0.42);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 48.0);
        baseAttributes.put("attackDamage", 2.0);
        baseAttributes.put("attackSpeed", 4.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151008_G), 1.0f).setMinAmount(3).setMaxAmount(5));
        this.drops.add(new DropRate(new ItemStack(Items.field_151103_aS), 0.75f).setMinAmount(1).setMaxAmount(3));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.attackAI.setEnabled(this.hasPickupEntity() ? this.getPickupEntity() instanceof EntityCreeper : this.creeperDropCooldown <= 0);
            if (this.creeperDropCooldown > 0) {
                --this.creeperDropCooldown;
            }
            if (this.hasPickupEntity()) {
                double distance;
                ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
                if (extendedEntity != null) {
                    extendedEntity.setPickedUpByEntity((Entity)this);
                }
                if (this.getPickupEntity() instanceof EntityCreeper && this.hasAttackTarget() && !(this.func_70638_az() instanceof EntityCreeper) && (distance = new Vec3d(this.field_70165_t, 0.0, this.field_70161_v).func_72438_d(new Vec3d(this.func_70638_az().field_70165_t, 0.0, this.func_70638_az().field_70161_v))) <= 2.0 && this.field_70163_u > this.func_70638_az().field_70163_u) {
                    this.getPickupEntity().func_70604_c(this.func_70638_az());
                    this.dropPickupEntity();
                    this.creeperDropCooldown = 120;
                }
                if (this.hasPickupEntity() && this.field_70173_aa % 100 == 0 && this.func_70681_au().nextBoolean()) {
                    if (this.getPickupEntity() instanceof EntityPlayer) {
                        for (int distToGround = 0; distToGround < 8; ++distToGround) {
                            Block searchBlock = this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u + 1 + distToGround, (int)this.field_70161_v)).func_177230_c();
                            if (searchBlock == null || searchBlock == Blocks.field_150350_a) continue;
                            this.dropPickupEntity();
                            this.leap(1.0, 2.0);
                            break;
                        }
                    } else if (!(this.getPickupEntity() instanceof EntityCreeper)) {
                        this.dropPickupEntity();
                    }
                }
            } else if (this.hasAttackTarget() && !this.hasPickupEntity() && this.func_70068_e((Entity)this.func_70638_az()) > 2.0 && this.func_70681_au().nextInt(20) == 0) {
                if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                    this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
                } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                    this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
                } else {
                    this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
                }
            }
        }
    }

    @Override
    public double getFlightOffset() {
        if (this.hasPickupEntity()) {
            return 5.0;
        }
        return super.getFlightOffset();
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)target;
            if (this.canPickupEntity(entityLivingBase)) {
                this.pickupEntity(entityLivingBase);
            }
            if (entityLivingBase instanceof EntityCreeper) {
                entityLivingBase.func_70604_c(null);
                ((EntityCreeper)entityLivingBase).func_70624_b(null);
                this.func_70624_b(null);
            }
        }
        return true;
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(targetEntity);
        if (extendedEntity != null && extendedEntity.pickedUpByEntity != null) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (!this.creeperDropping && targetClass == EntityCreeper.class) {
            return false;
        }
        if (this.hasPickupEntity() && targetClass == EntityCreeper.class) {
            return false;
        }
        if (this.creeperDropCooldown > 0) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean canFly() {
        return true;
    }

    @Override
    public void pickupEntity(EntityLivingBase entity) {
        super.pickupEntity(entity);
        if (this.field_70170_p.func_180495_p(this.func_180425_c()) != null && this.field_70170_p.func_175710_j(this.func_180425_c())) {
            this.leap(1.0, 2.0);
        }
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, -1.0, 0.0};
    }

    @Override
    public boolean canPickupEntity(EntityLivingBase entity) {
        if (this.creeperDropCooldown > 0 || this.hasPickupEntity()) {
            return false;
        }
        return super.canPickupEntity(entity);
    }

    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76437_t) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76419_f) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.hasPickupEntity() && this.getPickupEntity() instanceof EntityPlayer) {
            wanderPosition = new BlockPos(wanderPosition.func_177958_n(), this.restrictYHeightFromGround(wanderPosition, 6, 14), wanderPosition.func_177952_p());
        }
        return wanderPosition;
    }
}

