/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.junglemobs.entity;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IGroupAnimal;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIFollowParent;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISwimming;
import lycanite.lycanitesmobs.api.entity.ai.EntityAITargetRevenge;
import lycanite.lycanitesmobs.api.entity.ai.EntityAIWander;
import lycanite.lycanitesmobs.api.info.DropRate;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import lycanite.lycanitesmobs.api.info.SpawnInfo;
import lycanite.lycanitesmobs.junglemobs.entity.EntityConcapedeHead;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityConcapedeSegment
extends EntityCreatureAgeable
implements IAnimals,
IGroupAnimal {
    UUID parentUUID = null;

    public EntityConcapedeSegment(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.defense = 0;
        this.experience = 3;
        this.hasAttackSound = true;
        this.hasStepSound = false;
        this.canGrow = true;
        this.babySpawnChance = 0.0;
        this.setWidth = 0.5f;
        this.setHeight = 0.9f;
        this.isHostileByDefault = false;
        this.setupMob();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.1).setStrayDistance(0.0).setLostDistance(0.0).setAdultFollowing(true).setFollowBehind(0.25));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this).setPauseRate(30));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityConcapedeHead.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 5.0);
        baseAttributes.put("movementSpeed", 0.28);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 1.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("concapedemeatraw")), 1.0f).setMinAmount(2).setMaxAmount(3).setBurningDrop(new ItemStack(ObjectManager.getItem("concapedemeatcooked"))));
        this.drops.add(new DropRate(new ItemStack(Items.field_151007_F), 0.25f).setMinAmount(1).setMaxAmount(2));
    }

    @Override
    public boolean naturalSpawnCheck(World world, BlockPos pos) {
        if (this.getNearbyEntities(EntityConcapedeHead.class, null, SpawnInfo.spawnLimitRange).size() <= 0) {
            return false;
        }
        return super.naturalSpawnCheck(world, pos);
    }

    @Override
    public void getRandomSubspecies() {
        if (this.subspecies == null && !this.hasParent()) {
            this.subspecies = this.mobInfo.getRandomSubspecies((EntityLivingBase)this);
            if (this.subspecies != null) {
                LycanitesMobs.printDebug("Subspecies", "Setting " + this.getSpeciesName() + " to " + this.subspecies.getTitle());
            } else {
                LycanitesMobs.printDebug("Subspecies", "Setting " + this.getSpeciesName() + " to base species.");
            }
        }
        if (this.hasParent() && this.getParentTarget() instanceof EntityCreatureBase) {
            this.setSubspecies(((EntityCreatureBase)this.getParentTarget()).getSubspeciesIndex(), true);
        }
    }

    @Override
    protected boolean func_70692_ba() {
        if (!super.func_70692_ba()) {
            return false;
        }
        return !this.hasParent();
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && !this.hasParent() && this.parentUUID != null) {
            double range = 64.0;
            List connections = this.field_70170_p.func_72872_a(EntityCreatureAgeable.class, this.func_174813_aQ().func_72314_b(range, range, range));
            for (EntityCreatureAgeable possibleConnection : connections) {
                if (possibleConnection == this || !possibleConnection.func_110124_au().equals(this.parentUUID)) continue;
                this.setParentTarget((EntityLivingBase)possibleConnection);
                break;
            }
            this.parentUUID = null;
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.hasMaster() && !this.getMasterTarget().func_70089_S()) {
                this.setMasterTarget(null);
            }
            if (this.hasParent() && !this.getParentTarget().func_70089_S()) {
                this.setParentTarget(null);
            }
            if (this.hasParent()) {
                this.func_70625_a((Entity)this.getParentTarget(), 360.0f, 360.0f);
                double segmentDistance = 0.5;
                BlockPos pos = this.getParentTarget() instanceof EntityCreatureBase ? ((EntityCreatureBase)this.getParentTarget()).getFacingPosition(-0.25) : this.getParentTarget().func_180425_c();
                if (this.field_70165_t - (double)pos.func_177958_n() > segmentDistance) {
                    this.field_70165_t = (double)pos.func_177958_n() + segmentDistance;
                } else if (this.field_70165_t - (double)pos.func_177958_n() < -segmentDistance) {
                    this.field_70165_t = (double)pos.func_177958_n() - segmentDistance;
                }
                if (this.field_70163_u - (double)pos.func_177956_o() > segmentDistance) {
                    this.field_70163_u = (double)pos.func_177956_o() + segmentDistance;
                } else if (this.field_70163_u - (double)pos.func_177956_o() < -(segmentDistance / 2.0)) {
                    this.field_70163_u = pos.func_177956_o();
                }
                if (this.field_70161_v - (double)pos.func_177952_p() > segmentDistance) {
                    this.field_70161_v = (double)pos.func_177952_p() + segmentDistance;
                } else if (this.field_70161_v - (double)pos.func_177952_p() < -segmentDistance) {
                    this.field_70161_v = (double)pos.func_177952_p() - segmentDistance;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getGrowingAge() <= 0) {
            this.setGrowingAge(-this.growthTime);
        }
    }

    @Override
    public void setGrowingAge(int age) {
        if (this.hasParent()) {
            age = -this.growthTime;
        }
        super.setGrowingAge(age);
        if (age == 0 && !this.field_70170_p.field_72995_K) {
            EntityConcapedeHead concapedeHead = new EntityConcapedeHead(this.field_70170_p);
            concapedeHead.func_82149_j((Entity)this);
            concapedeHead.firstSpawn = false;
            concapedeHead.setGrowingAge(-this.growthTime / 4);
            this.field_70170_p.func_72838_d((Entity)concapedeHead);
            if (this.hasMaster() && this.getMasterTarget() instanceof EntityConcapedeSegment) {
                ((EntityConcapedeSegment)this.getMasterTarget()).setParentTarget((EntityLivingBase)concapedeHead);
            }
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        IBlockState blockState = this.field_70170_p.func_180495_p(new BlockPos(x, y - 1, z));
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return 7.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        return !this.hasParent();
    }

    @Override
    public double getFallingMod() {
        if (this.field_70170_p.field_72995_K) {
            return 0.0;
        }
        if (this.hasParent() && this.getParentTarget().field_70163_u > this.field_70163_u) {
            return 0.0;
        }
        return super.getFallingMod();
    }

    @Override
    public void setParentTarget(EntityLivingBase setTarget) {
        if (setTarget instanceof EntityConcapedeSegment || setTarget instanceof EntityConcapedeHead) {
            ((EntityCreatureBase)setTarget).setMasterTarget((EntityLivingBase)this);
        }
        super.setParentTarget(setTarget);
    }

    @Override
    public boolean renderSubspeciesNameTag() {
        return !this.hasParent();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76436_u) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76421_d) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable partener) {
        return null;
    }

    @Override
    public boolean isBreedingItem(ItemStack testStack) {
        return ObjectLists.inItemList("Vegetables", testStack);
    }

    @Override
    public boolean breed() {
        if (!this.canBreed()) {
            return false;
        }
        this.setGrowingAge(0);
        return true;
    }

    @Override
    public boolean canBreed() {
        return !this.hasParent();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("ParentUUIDMost") && nbtTagCompound.func_74764_b("ParentUUIDLeast")) {
            this.parentUUID = new UUID(nbtTagCompound.func_74763_f("ParentUUIDMost"), nbtTagCompound.func_74763_f("ParentUUIDLeast"));
        }
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        if (this.hasParent()) {
            nbtTagCompound.func_74772_a("ParentUUIDMost", this.getParentTarget().func_110124_au().getMostSignificantBits());
            nbtTagCompound.func_74772_a("ParentUUIDLeast", this.getParentTarget().func_110124_au().getLeastSignificantBits());
        }
        super.func_70014_b(nbtTagCompound);
    }
}

