/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.infernomobs.worldgen;

import java.util.Random;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.IWorldGenBase;
import lycanite.lycanitesmobs.api.config.ConfigSpawning;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.infernomobs.InfernoMobs;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenLakes;

public class WorldGenPureLavaLakes
extends WorldGenLakes
implements IWorldGenBase {
    public String name = "Pure Lava Lakes";
    public GroupInfo group = InfernoMobs.group;
    public double generateUndergroundChance = 0.04;
    public double generateSurfaceChance = 0.0;
    public String dimensionEntries = "-1";
    public int[] dimensionBlacklist;
    public String[] dimensionTypes;
    public boolean dimensionWhitelist = true;

    public WorldGenPureLavaLakes() {
        super(ObjectManager.getBlock("purelava"));
        ConfigSpawning config = ConfigSpawning.getConfig(this.group, "worldgen");
        config.setCategoryComment("WorldGen Chances", "The chance that each worldgen will generate. You can set this to 0 to disable the worldgen or use the dimension black/white list. 1 = all over, 0.04 fairly rare.");
        this.generateUndergroundChance = config.getDouble("WorldGen Chances", this.name + " Underground Chance", this.generateUndergroundChance);
        this.generateSurfaceChance = config.getDouble("WorldGen Chances", this.name + " Surface Chance", this.generateSurfaceChance);
        ConfigSpawning.SpawnDimensionSet dimensions = config.getDimensions("WorldGen Dimensions", this.name + " Dimensions", this.dimensionEntries);
        this.dimensionBlacklist = dimensions.dimensionIDs;
        this.dimensionTypes = dimensions.dimensionTypes;
        this.dimensionWhitelist = config.getBool("WorldGen Dimensions", this.name + " Dimensions Whitelist Mode", this.dimensionWhitelist);
    }

    @Override
    public void onWorldGen(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int top;
        int z;
        int x;
        if (!this.isValidDimension(world)) {
            return;
        }
        if (this.generateSurfaceChance > 0.0 && (this.generateSurfaceChance >= 1.0 || random.nextDouble() <= this.generateSurfaceChance)) {
            x = chunkX * 16 + random.nextInt(16);
            z = chunkZ * 16 + random.nextInt(16);
            int y = random.nextInt(128);
            this.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        if (this.generateUndergroundChance > 0.0 && (this.generateUndergroundChance >= 1.0 || random.nextDouble() <= this.generateUndergroundChance) && (top = Math.max(1, world.func_175672_r(new BlockPos(x = chunkX * 16 + random.nextInt(16), 0, z = chunkZ * 16 + random.nextInt(16))).func_177956_o() - 10)) > 0) {
            int y = random.nextInt(top);
            this.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        return super.func_180709_b(world, random, pos);
    }

    public boolean isValidDimension(World world) {
        boolean validDimension = false;
        for (String eventDimensionType : this.dimensionTypes) {
            if ("ALL".equalsIgnoreCase(eventDimensionType)) {
                validDimension = true;
                continue;
            }
            if (!"VANILLA".equalsIgnoreCase(eventDimensionType)) continue;
            validDimension = world.field_73011_w.getDimension() > -2 && world.field_73011_w.getDimension() < 2;
        }
        if (!validDimension) {
            validDimension = !this.dimensionWhitelist;
            for (int eventDimension : this.dimensionBlacklist) {
                if (world.field_73011_w.getDimension() != eventDimension) continue;
                validDimension = this.dimensionWhitelist;
                break;
            }
        }
        return validDimension;
    }
}

