/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.desertmobs.model;

import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.model.ModelCustomObj;
import lycanite.lycanitesmobs.desertmobs.DesertMobs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelGorgomite
extends ModelCustomObj {
    public ModelGorgomite() {
        this(1.0f);
    }

    public ModelGorgomite(float shadowSize) {
        this.initModel("Gorgomite", DesertMobs.group, "entity/gorgomite");
        this.setPartCenter("head", 0.0f, 0.4f, 0.45f);
        this.setPartCenter("leftmouth", 0.2f, 0.4f, 0.7f);
        this.setPartCenter("rightmouth", -0.2f, 0.4f, 0.7f);
        this.setPartCenter("body", 0.0f, 0.4f, 0.45f);
        this.setPartCenter("frontleftleg", 0.35f, 0.5f, 0.2f);
        this.setPartCenter("backleftleg", 0.35f, 0.5f, -0.3f);
        this.setPartCenter("frontrightleg", -0.35f, 0.5f, 0.2f);
        this.setPartCenter("backrightleg", -0.35f, 0.5f, -0.3f);
        this.lockHeadX = true;
        this.lockHeadY = true;
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.2f};
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("leftmouth") || partName.equals("rightmouth")) {
            this.centerPartToPart(partName, "head");
            if (!this.lockHeadX) {
                rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f));
            }
            if (!this.lockHeadY) {
                rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f));
            }
            this.uncenterPartToPart(partName, "head");
        }
        if (partName.equals("leftmouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f + (float)Math.PI)) * 0.05f - 0.05f)), 0.0f, 0.0f);
        }
        if (partName.equals("rightmouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f)), 0.0f, 0.0f);
        }
        float walkSwing = 0.6f;
        if (partName.equals("frontrightleg") || partName.equals("backleftleg")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance));
        }
        if (partName.equals("frontleftleg") || partName.equals("backrightleg")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked() && (partName.equals("leftmouth") || partName.equals("rightmouth"))) {
            rotX += 20.0f;
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

