/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.renderer;

import lycanite.lycanitesmobs.api.entity.EntityParticle;
import lycanite.lycanitesmobs.api.entity.EntityProjectileBase;
import lycanite.lycanitesmobs.api.entity.EntityProjectileLaser;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderProjectile
extends Render {
    private float scale;
    private int renderTime = 0;
    Class projectileClass;
    protected ModelBase laserModel = new ModelBase(){};
    private ModelRenderer laserBox;

    public RenderProjectile(RenderManager renderManager, Class projectileClass) {
        super(renderManager);
        this.projectileClass = projectileClass;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float par8, float par9) {
        if (this.renderTime++ > 0x7FFFFFFE) {
            this.renderTime = 0;
        }
        this.renderProjectile(entity, x, y, z, par8, par9);
        if (entity instanceof EntityProjectileLaser) {
            this.renderLaser((EntityProjectileLaser)entity, x, y, z, par8, par9);
        }
    }

    public void renderProjectile(Entity entity, double x, double y, double z, float par8, float par9) {
        double scale = 0.5;
        if (entity instanceof EntityProjectileBase) {
            EntityProjectileBase entityProjectileBase = (EntityProjectileBase)entity;
            scale *= (double)entityProjectileBase.getProjectileScale();
            y += (double)entityProjectileBase.getTextureOffsetY();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179091_B();
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        this.func_110776_a(this.func_110775_a(entity));
        this.renderTexture(Tessellator.func_178181_a(), entity);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    private void renderTexture(Tessellator tessellator, Entity entity) {
        double minU = 0.0;
        double maxU = 1.0;
        double minV = 0.0;
        double maxV = 1.0;
        double textureWidth = 0.5;
        double textureHeight = 0.5;
        if (entity instanceof EntityProjectileBase) {
            EntityProjectileBase entityProjectile = (EntityProjectileBase)entity;
            if (entityProjectile.animationFrameMax > 0) {
                minV = (float)entityProjectile.animationFrame / (float)entityProjectile.animationFrameMax;
                maxV = minV + (double)(1.0f / (float)entityProjectile.animationFrameMax);
            }
        }
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-this.scale / 2.0f), (float)(-this.scale / 2.0f), (float)(-this.scale / 2.0f));
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c(entity));
        }
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        vertexbuffer.func_181662_b(-textureWidth, -textureHeight + textureHeight / 2.0, 0.0).func_187315_a(minU, maxV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(textureWidth, -textureHeight + textureHeight / 2.0, 0.0).func_187315_a(maxU, maxV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(textureWidth, textureHeight + textureHeight / 2.0, 0.0).func_187315_a(maxU, minV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(-textureWidth, textureHeight + textureHeight / 2.0, 0.0).func_187315_a(minU, minV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void renderLaser(EntityProjectileLaser entity, double x, double y, double z, float par8, float par9) {
        float scale = entity.getLaserWidth();
        if (this.laserBox == null) {
            this.laserBox = new ModelRenderer(this.laserModel, 0, 0);
            this.laserBox.func_78789_a(-(scale / 2.0f), -(scale / 2.0f), 0.0f, (int)scale, (int)scale, 16);
            this.laserBox.field_78800_c = 0.0f;
            this.laserBox.field_78797_d = 0.0f;
            this.laserBox.field_78798_e = 0.0f;
        }
        float factor = 0.0625f;
        float lastSegment = 0.0f;
        float laserSize = entity.getLength();
        if (laserSize <= 0.0f) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)entity.getLaserAlpha());
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.func_110776_a(this.getLaserTexture(entity));
        float[] angles = entity.getBeamAngles();
        GlStateManager.func_179114_b((float)angles[1], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angles[3], (float)1.0f, (float)0.0f, (float)0.0f);
        for (float segment = 0.0f; segment <= laserSize - 1.0f; segment += 1.0f) {
            this.laserBox.func_78785_a(factor);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            lastSegment = segment;
        }
        GlStateManager.func_179152_a((float)(laserSize - (lastSegment += 1.0f)), (float)1.0f, (float)1.0f);
        this.laserBox.func_78785_a(factor);
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        if (entity instanceof EntityProjectileBase) {
            return ((EntityProjectileBase)entity).getTexture();
        }
        if (entity instanceof EntityParticle) {
            return ((EntityParticle)entity).getTexture();
        }
        return null;
    }

    protected ResourceLocation getLaserTexture(EntityProjectileLaser entity) {
        return entity.getBeamTexture();
    }
}

