/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.pets;

import java.util.UUID;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.pets.PetManager;
import lycanite.lycanitesmobs.api.pets.SummonSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PetEntry {
    public String name;
    public PetManager petManager;
    public int petEntryID;
    private String type;
    public boolean active = true;
    public int respawnTime = 0;
    public int respawnTimeMax;
    public boolean isRespawning = false;
    public int spawnCount = 0;
    public boolean temporary = false;
    public int temporaryDuration = 100;
    public boolean spawningActive = true;
    public EntityLivingBase host;
    public SummonSet summonSet;
    public Entity entity;
    public NBTTagCompound entityNBT;
    public int entityTick = 0;
    public float entityHealth = 1.0f;
    public float entityMaxHealth = 1.0f;
    public String entityName = "";
    public int subspeciesID = 0;
    public double entitySize = 1.0;
    public String color = "000000";
    public boolean teleportEntity = false;
    public boolean releaseEntity = false;

    public static PetEntry createFromEntity(EntityPlayer player, EntityCreatureBase entity, String petType) {
        MobInfo mobInfo = entity.mobInfo;
        String entryName = petType + "-" + player.func_70005_c_() + mobInfo.name + "-" + UUID.randomUUID().toString();
        PetEntry petEntry = new PetEntry(entryName, petType, (EntityLivingBase)player, mobInfo.name);
        if (entity.func_145818_k_()) {
            petEntry.setEntityName(entity.func_95999_t());
        }
        petEntry.setEntitySubspeciesID(entity.getSubspeciesIndex());
        petEntry.setEntitySize(entity.sizeScale);
        petEntry.setColor("000000");
        return petEntry;
    }

    public PetEntry(String name, String type, EntityLivingBase host, String summonType) {
        this.name = name;
        this.type = type;
        this.host = host;
        ExtendedPlayer playerExt = null;
        if (host != null && host instanceof EntityPlayer) {
            playerExt = ExtendedPlayer.getForPlayer((EntityPlayer)host);
        }
        this.summonSet = new SummonSet(playerExt);
        this.summonSet.summonableOnly = false;
        this.summonSet.setSummonType(summonType);
        this.respawnTimeMax = 6000;
        if ("minion".equalsIgnoreCase(this.type)) {
            this.temporary = true;
        }
    }

    public PetEntry setEntityName(String name) {
        this.entityName = name;
        return this;
    }

    public PetEntry setEntitySubspeciesID(int id) {
        this.subspeciesID = id;
        return this;
    }

    public PetEntry setEntitySize(double size) {
        this.entitySize = size;
        return this;
    }

    public PetEntry setColor(String color) {
        this.color = color;
        return this;
    }

    public PetEntry setOwner(EntityLivingBase owner) {
        this.host = owner;
        if (this.host != null && this.host instanceof EntityPlayer) {
            ExtendedPlayer playerExt;
            this.summonSet.playerExt = playerExt = ExtendedPlayer.getForPlayer((EntityPlayer)this.host);
        }
        return this;
    }

    public PetEntry setSpawningActive(boolean spawningActive) {
        if (this.spawningActive == spawningActive) {
            return this;
        }
        if (!this.host.field_70170_p.field_72995_K) {
            if (!spawningActive) {
                this.despawnEntity();
            } else if (this.usesSpirit() && this.summonSet.playerExt != null) {
                if (this.summonSet.playerExt.spirit < this.getSpiritCost()) {
                    this.spawningActive = false;
                    return this;
                }
                this.summonSet.playerExt.spirit -= this.getSpiritCost();
                this.summonSet.playerExt.spiritReserved += this.getSpiritCost();
            }
        }
        this.spawningActive = spawningActive;
        return this;
    }

    public MobInfo getMobInfo() {
        if (this.summonSet == null || "".equals(this.summonSet.summonType)) {
            return null;
        }
        return MobInfo.getFromName(this.summonSet.summonType);
    }

    public float getHealth() {
        if (this.entity != null && this.entity instanceof EntityLivingBase) {
            this.entityHealth = ((EntityLivingBase)this.entity).func_110143_aJ();
        }
        return this.entityHealth;
    }

    public float getMaxHealth() {
        if (this.entity != null && this.entity instanceof EntityLivingBase) {
            this.entityMaxHealth = ((EntityLivingBase)this.entity).func_110138_aP();
        }
        return this.entityMaxHealth;
    }

    public void copy(PetEntry copyEntry) {
        this.setEntityName(copyEntry.entityName);
        this.setEntitySubspeciesID(copyEntry.subspeciesID);
        this.setEntitySize(copyEntry.entitySize);
        this.setColor(copyEntry.color);
        if (copyEntry.summonSet != null) {
            this.summonSet.setSummonType(copyEntry.summonSet.summonType);
        }
    }

    public String getDisplayName() {
        String displayName = this.summonSet.getMobInfo().getTitle();
        if (!"".equals(this.entityName)) {
            displayName = this.entityName + " (" + displayName + ")";
        }
        return displayName;
    }

    public void onAdd(PetManager petManager, int petEntryID) {
        this.petManager = petManager;
        this.petEntryID = petEntryID;
    }

    public void remove() {
        this.setSpawningActive(false);
        this.active = false;
    }

    public void onUpdate(World world) {
        if (world.field_72995_K) {
            if (this.isRespawning && this.respawnTime > 0) {
                --this.respawnTime;
            }
            return;
        }
        if (!this.active) {
            return;
        }
        if (!this.isActive()) {
            this.remove();
            return;
        }
        if (this.spawningActive) {
            if (this.entity != null && !this.entity.func_70089_S()) {
                this.saveEntityNBT();
                this.entity = null;
                this.isRespawning = true;
                this.respawnTime = this.respawnTimeMax;
                if (this.summonSet.playerExt != null) {
                    this.summonSet.playerExt.sendPetEntryToPlayer(this);
                }
            }
            if (this.entity == null) {
                if (!this.isRespawning) {
                    this.respawnTime = 0;
                }
                if (this.respawnTime-- <= 0) {
                    this.spawnEntity();
                    this.isRespawning = false;
                }
            }
            if (this.entity != null) {
                ++this.entityTick;
                if (this.teleportEntity) {
                    if (this.entity.field_70170_p != this.host.field_70170_p) {
                        this.entity.func_184204_a(this.host.field_70170_p.field_73011_w.getDimension());
                    }
                    this.entity.func_70107_b(this.host.field_70165_t, this.host.field_70163_u, this.host.field_70161_v);
                }
                if (this.entity instanceof EntityLivingBase) {
                    EntityLivingBase entityLiving = (EntityLivingBase)this.entity;
                    if (this.entityTick % 20 == 0 && entityLiving.func_110143_aJ() < entityLiving.func_110138_aP()) {
                        entityLiving.func_70606_j(Math.min(entityLiving.func_110143_aJ() + 1.0f, entityLiving.func_110138_aP()));
                    }
                    this.entityHealth = entityLiving.func_110143_aJ();
                    this.entityMaxHealth = entityLiving.func_110138_aP();
                }
            }
        } else {
            if (this.entity != null) {
                this.saveEntityNBT();
                this.entity.func_70106_y();
                this.entity = null;
            }
            if (this.respawnTime > 0) {
                --this.respawnTime;
            }
        }
        this.teleportEntity = false;
    }

    public void onBehaviourUpdate() {
        if (this.entity != null && this.entity instanceof EntityCreatureTameable) {
            this.summonSet.applyBehaviour((EntityCreatureTameable)this.entity);
        }
    }

    public boolean isActive() {
        return this.entity != null || !this.temporary || this.spawnCount <= 0;
    }

    public void spawnEntity() {
        if (this.entity != null || this.host == null) {
            return;
        }
        try {
            this.entity = (Entity)this.summonSet.getCreatureClass().getConstructor(World.class).newInstance(this.host.field_70170_p);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Entity spawnedEntity = this.entity;
        if (spawnedEntity == null) {
            return;
        }
        this.loadEntityNBT();
        spawnedEntity.func_70012_b(this.host.field_70165_t, this.host.field_70163_u, this.host.field_70161_v, this.host.field_70177_z, 0.0f);
        if (spawnedEntity instanceof EntityCreatureBase) {
            BlockPos spawnPos;
            EntityCreatureBase entityCreature = (EntityCreatureBase)spawnedEntity;
            entityCreature.setMinion(true);
            entityCreature.setPetEntry(this);
            if (entityCreature instanceof EntityCreatureTameable) {
                EntityCreatureTameable entityTameable = (EntityCreatureTameable)entityCreature;
                this.summonSet.applyBehaviour(entityTameable);
            }
            float randomAngle = 45.0f + 45.0f * this.host.func_70681_au().nextFloat();
            if (this.host.func_70681_au().nextBoolean()) {
                randomAngle = -randomAngle;
            }
            if (!spawnedEntity.field_70170_p.isSideSolid(spawnPos = entityCreature.getFacingPosition((Entity)this.host, -1.0, randomAngle), EnumFacing.UP)) {
                spawnedEntity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), this.host.field_70177_z, 0.0f);
            } else {
                spawnPos = entityCreature.getFacingPosition((Entity)this.host, -1.0, -randomAngle);
                if (spawnedEntity.field_70170_p.isSideSolid(spawnPos, EnumFacing.UP)) {
                    spawnedEntity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), this.host.field_70177_z, 0.0f);
                }
            }
            if (this.temporary) {
                entityCreature.setTemporary(this.temporaryDuration);
            }
            if (this.entityName != null && !"".equals(this.entityName)) {
                entityCreature.func_96094_a(this.entityName);
            }
            entityCreature.setSizeScale(this.entitySize);
            entityCreature.setSubspecies(this.subspeciesID, false);
            if (entityCreature instanceof EntityCreatureTameable && this.host instanceof EntityPlayer) {
                EntityCreatureTameable entityTameable = (EntityCreatureTameable)entityCreature;
                entityTameable.setPlayerOwner((EntityPlayer)this.host);
                this.summonSet.applyBehaviour(entityTameable);
            }
        }
        ++this.spawnCount;
        if (spawnedEntity instanceof EntityLivingBase && this.isRespawning) {
            EntityLivingBase entityLiving = (EntityLivingBase)spawnedEntity;
            entityLiving.func_70606_j(entityLiving.func_110138_aP() / 2.0f);
        }
        this.onSpawnEntity(spawnedEntity);
        this.host.field_70170_p.func_72838_d(spawnedEntity);
        this.entity = spawnedEntity;
    }

    public void onSpawnEntity(Entity entity) {
    }

    public void despawnEntity() {
        if (this.entity == null) {
            return;
        }
        this.onDespawnEntity(this.entity);
        this.saveEntityNBT();
        this.entity.func_70106_y();
        this.entity = null;
    }

    public void onDespawnEntity(Entity entity) {
    }

    public void assignEntity(Entity entity) {
        if (this.entity != null) {
            this.despawnEntity();
        }
        this.setSpawningActive(true);
        this.entity = entity;
        if (this.entity instanceof EntityCreatureBase) {
            EntityCreatureBase entityCreature = (EntityCreatureBase)this.entity;
            entityCreature.setMinion(true);
            entityCreature.setPetEntry(this);
            if (entityCreature instanceof EntityCreatureTameable) {
                EntityCreatureTameable entityTameable = (EntityCreatureTameable)entityCreature;
                this.summonSet.updateBehaviour(entityTameable);
            }
            if (this.temporary) {
                entityCreature.setTemporary(this.temporaryDuration);
            }
            if (this.entityName != null && !"".equals(this.entityName)) {
                entityCreature.func_96094_a(this.entityName);
            }
            entityCreature.setSizeScale(this.entitySize);
            entityCreature.setSubspecies(this.subspeciesID, false);
        }
        ++this.spawnCount;
        this.saveEntityNBT();
        this.onSpawnEntity(this.entity);
    }

    public String getType() {
        return this.type;
    }

    public boolean usesSpirit() {
        return "pet".equals(this.getType()) || "mount".equals(this.getType());
    }

    public int getSpiritCost() {
        if (this.summonSet.playerExt == null) {
            return 0;
        }
        return this.summonSet.playerExt.spiritCharge * this.getMobInfo().summonCost;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("Active")) {
            this.active = nbtTagCompound.func_74767_n("Active");
        }
        if (nbtTagCompound.func_74764_b("RespawnTime")) {
            this.respawnTime = nbtTagCompound.func_74762_e("RespawnTime");
        }
        if (nbtTagCompound.func_74764_b("Respawning")) {
            this.isRespawning = nbtTagCompound.func_74767_n("Respawning");
        }
        if (nbtTagCompound.func_74764_b("SpawningActive")) {
            this.spawningActive = nbtTagCompound.func_74767_n("SpawningActive");
        }
        this.summonSet.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("EntityName")) {
            this.setEntityName(nbtTagCompound.func_74779_i("EntityName"));
        }
        if (nbtTagCompound.func_74764_b("SubspeciesID")) {
            this.setEntitySubspeciesID(nbtTagCompound.func_74762_e("SubspeciesID"));
        }
        if (nbtTagCompound.func_74764_b("EntitySize")) {
            this.setEntitySize(nbtTagCompound.func_74769_h("EntitySize"));
        }
        if (nbtTagCompound.func_74764_b("Color")) {
            this.setColor(nbtTagCompound.func_74779_i("Color"));
        }
        if (nbtTagCompound.func_74764_b("EntityNBT")) {
            this.entityNBT = nbtTagCompound.func_74775_l("EntityNBT");
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        if (this.name == null || "".equals(this.name)) {
            return;
        }
        nbtTagCompound.func_74757_a("Active", this.active);
        nbtTagCompound.func_74768_a("RespawnTime", this.respawnTime);
        nbtTagCompound.func_74757_a("Respawning", this.isRespawning);
        nbtTagCompound.func_74757_a("SpawningActive", this.spawningActive);
        nbtTagCompound.func_74768_a("ID", this.petEntryID);
        nbtTagCompound.func_74778_a("EntryName", this.name);
        nbtTagCompound.func_74778_a("Type", this.getType());
        this.summonSet.writeToNBT(nbtTagCompound);
        if (this.usesSpirit()) {
            this.saveEntityNBT();
            nbtTagCompound.func_74778_a("EntityName", this.entityName);
            nbtTagCompound.func_74768_a("SubspeciesID", this.subspeciesID);
            nbtTagCompound.func_74780_a("EntitySize", this.entitySize);
            nbtTagCompound.func_74778_a("Color", this.color);
            nbtTagCompound.func_74782_a("EntityNBT", (NBTBase)this.entityNBT);
        }
    }

    public void saveEntityNBT() {
        if (this.entityNBT == null) {
            this.entityNBT = new NBTTagCompound();
        }
        if (this.entity instanceof EntityCreatureBase) {
            EntityCreatureBase entityCreatureBase = (EntityCreatureBase)this.entity;
            entityCreatureBase.inventory.writeToNBT(this.entityNBT);
            NBTTagCompound extTagCompound = new NBTTagCompound();
            entityCreatureBase.extraMobBehaviour.writeToNBT(extTagCompound);
            this.entityNBT.func_74782_a("ExtraBehaviour", (NBTBase)extTagCompound);
            if (this.entity instanceof EntityCreatureAgeable) {
                EntityCreatureAgeable entityCreatureAgeable = (EntityCreatureAgeable)this.entity;
                this.entityNBT.func_74768_a("Age", entityCreatureAgeable.getGrowingAge());
            }
        }
    }

    public void loadEntityNBT() {
        if (this.entity == null || this.entityNBT == null) {
            return;
        }
        if (this.entity instanceof EntityCreatureBase) {
            EntityCreatureBase entityCreatureBase = (EntityCreatureBase)this.entity;
            entityCreatureBase.inventory.readFromNBT(this.entityNBT);
            if (this.entityNBT.func_74764_b("ExtraBehaviour")) {
                entityCreatureBase.extraMobBehaviour.readFromNBT(this.entityNBT.func_74775_l("ExtraBehaviour"));
            }
            if (this.entity instanceof EntityCreatureAgeable) {
                EntityCreatureAgeable entityCreatureAgeable = (EntityCreatureAgeable)this.entity;
                if (this.entityNBT.func_74764_b("Age")) {
                    entityCreatureAgeable.setGrowingAge(this.entityNBT.func_74762_e("Age"));
                } else {
                    entityCreatureAgeable.setGrowingAge(0);
                }
            }
        }
    }
}

