/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.mobevent;

import lycanite.lycanitesmobs.ExtendedWorld;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.config.ConfigSpawning;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.mobevent.MobEventBase;
import lycanite.lycanitesmobs.api.mobevent.MobEventClient;
import lycanite.lycanitesmobs.api.mobevent.MobEventClientBoss;
import lycanite.lycanitesmobs.api.mobevent.MobEventServer;
import lycanite.lycanitesmobs.api.mobevent.MobEventServerBoss;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public class MobEventBoss
extends MobEventBase {
    public MobEventBoss(String name, GroupInfo group) {
        super(name, group);
    }

    @Override
    public void loadFromConfig() {
        ConfigSpawning config = ConfigSpawning.getConfig(LycanitesMobs.group, "mobevents");
        this.duration = 600;
        this.forceSpawning = true;
        this.forceNoDespawn = true;
        this.minDay = config.getInt("Boss Event Day Minimums", this.name, this.minDay);
        ConfigSpawning.SpawnDimensionSet eventDimensions = config.getDimensions("Boss Event Dimensions", this.name + " Dimensions", "");
        this.dimensionBlacklist = eventDimensions.dimensionIDs;
        this.dimensionTypes = eventDimensions.dimensionTypes;
        this.dimensionWhitelist = config.getBool("Boss Event Dimensions", this.name + " Dimensions Whitelist Mode", false);
    }

    @Override
    public boolean isEnabled() {
        ConfigSpawning config = ConfigSpawning.getConfig(LycanitesMobs.group, "mobevents");
        return config.getBool("Boss Events Enabled", this.name, true);
    }

    @Override
    public boolean canStart(World world, ExtendedWorld worldExt) {
        if (world.field_73011_w == null) {
            return false;
        }
        boolean validDimension = false;
        for (String eventDimensionType : this.dimensionTypes) {
            if ("ALL".equalsIgnoreCase(eventDimensionType)) {
                validDimension = true;
                continue;
            }
            if (!"VANILLA".equalsIgnoreCase(eventDimensionType)) continue;
            validDimension = world.field_73011_w.getDimension() > -2 && world.field_73011_w.getDimension() < 2;
        }
        if (!validDimension) {
            validDimension = !this.dimensionWhitelist;
            for (int eventDimension : this.dimensionBlacklist) {
                if (world.field_73011_w.getDimension() != eventDimension) continue;
                validDimension = this.dimensionWhitelist;
                break;
            }
        }
        return validDimension;
    }

    @Override
    public void onStart(World world) {
        super.onStart(world);
    }

    public void bossSetup(int time, World world, int originX, int originY, int originZ) {
    }

    @Override
    public void onFinish(World world) {
        super.onFinish(world);
    }

    @Override
    public void onSpawn(EntityLiving entity) {
    }

    @Override
    public MobEventServer getServerEvent(World world) {
        return new MobEventServerBoss(this, world);
    }

    @Override
    public MobEventClient getClientEvent(World world) {
        return new MobEventClientBoss(this, world);
    }
}

