/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import lycanite.lycanitesmobs.api.item.ItemCustom;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraftforge.oredict.OreDictionary;

public class ObjectLists {
    public static String[] itemListNames = new String[]{"RawMeat", "CookedMeat", "Vegetables", "RawFish", "CookedFish", "CactusFood", "Mushrooms", "Sweets", "Fuel"};
    public static Map<String, List<ItemStack>> itemLists = new HashMap<String, List<ItemStack>>();
    public static Map<String, List<Class>> entityLists = new HashMap<String, List<Class>>();
    public static Map<String, List<Potion>> effectLists = new HashMap<String, List<Potion>>();

    public static void addItem(String list, Object object) {
        if (object == null || !(object instanceof Item) && !(object instanceof Block) && !(object instanceof ItemStack) && !(object instanceof String)) {
            return;
        }
        if (!itemLists.containsKey(list = list.toLowerCase())) {
            itemLists.put(list, new ArrayList());
        }
        ItemStack itemStack = null;
        if (object instanceof Item) {
            itemStack = new ItemStack((Item)object);
        } else if (object instanceof Block) {
            itemStack = new ItemStack((Block)object);
        } else if (object instanceof ItemStack) {
            itemStack = (ItemStack)object;
        } else if (object instanceof String) {
            if (ObjectManager.getItem((String)object) != null) {
                itemStack = new ItemStack(ObjectManager.getItem((String)object));
            } else if (ObjectManager.getBlock((String)object) != null) {
                itemStack = new ItemStack(ObjectManager.getBlock((String)object));
            }
        }
        if (itemStack != null) {
            itemLists.get(list).add(itemStack);
        }
    }

    public static void addEntity(String list, Object object) {
        if (!(object instanceof Entity) && !(object instanceof String)) {
            return;
        }
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            entityLists.put(list, new ArrayList());
        }
        Class entity = null;
        if (object instanceof Class) {
            entity = (Class)object;
        } else if (object instanceof String) {
            entity = ObjectManager.getMob((String)object);
        }
        if (entity != null) {
            entityLists.get(list).add(entity);
        }
    }

    public static void addEffect(String list, Potion potion) {
        if (potion == null) {
            return;
        }
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            effectLists.put(list, new ArrayList());
        }
        effectLists.get(list).add(potion);
    }

    public static ItemStack[] getItems(String list) {
        if (!itemLists.containsKey(list = list.toLowerCase())) {
            return new ItemStack[0];
        }
        return itemLists.get(list).toArray(new ItemStack[itemLists.get(list).size()]);
    }

    public static Class[] getEntites(String list) {
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            return new Class[0];
        }
        return entityLists.get(list).toArray(new Class[entityLists.get(list).size()]);
    }

    public static Potion[] getEffects(String list) {
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            return new Potion[0];
        }
        return effectLists.get(list).toArray(new Potion[effectLists.get(list).size()]);
    }

    public static boolean inItemList(String list, ItemStack testStack) {
        list = list.toLowerCase();
        if (testStack == null || testStack.func_77973_b() == null) {
            return false;
        }
        if (!itemLists.containsKey(list)) {
            return false;
        }
        for (ItemStack listStack : itemLists.get(list)) {
            if (testStack.func_77973_b() != listStack.func_77973_b() || testStack.func_77952_i() != listStack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static boolean inEntityList(String list, Class testClass) {
        if (!entityLists.containsKey(list = list.toLowerCase())) {
            return false;
        }
        return false;
    }

    public static boolean inEffectList(String list, Potion testPotion) {
        if (!effectLists.containsKey(list = list.toLowerCase())) {
            return false;
        }
        return effectLists.get(list).contains(testPotion);
    }

    public static boolean isInOreDictionary(String oreEntry, Item item) {
        return ObjectLists.isInOreDictionary(oreEntry, new ItemStack(item));
    }

    public static boolean isInOreDictionary(String oreEntry, Block block) {
        return ObjectLists.isInOreDictionary(oreEntry, new ItemStack(block));
    }

    public static boolean isInOreDictionary(String oreEntry, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        List ores = OreDictionary.getOres((String)oreEntry);
        if (ores == null) {
            return false;
        }
        for (ItemStack ore : ores) {
            if (ore.func_77973_b() != itemStack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public static void createCustomItems() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "itemlists");
        config.setCategoryComment("Custom Objects", "here you can add your own custom items! These items wont do anything and will have no crafting recipes you can however have them drop from mobs by adding them to the custom mob drops. To add items just create a comma seperated list of names (spaces will be removed), you will need to use the item.youritem.name and item.youritem.description lang file entries in your resource pack to name your item and you will also need to save a texture for your item as: assets/lycanitesmobs/items/youritem.png");
        String customItems = config.getString("Custom Objects", "Custom Items", "");
        if ("".equals(customItems)) {
            return;
        }
        for (String itemEntry : customItems.replace(" ", "").split(",")) {
            ObjectManager.addItem(itemEntry, new ItemCustom(itemEntry, LycanitesMobs.group));
        }
    }

    public static void createLists() {
        ObjectLists.addItem("rawmeat", Items.field_151082_bd);
        ObjectLists.addItem("rawmeat", Items.field_151147_al);
        ObjectLists.addItem("rawmeat", Items.field_151076_bf);
        ObjectLists.addItem("cookedmeat", Items.field_151083_be);
        ObjectLists.addItem("cookedmeat", Items.field_151157_am);
        ObjectLists.addItem("cookedmeat", Items.field_151077_bg);
        ObjectLists.addItem("vegetables", Items.field_151015_O);
        ObjectLists.addItem("vegetables", Items.field_151172_bF);
        ObjectLists.addItem("vegetables", Items.field_151174_bG);
        ObjectLists.addItem("fruit", Items.field_151034_e);
        ObjectLists.addItem("fruit", Items.field_151127_ba);
        ObjectLists.addItem("fruit", Blocks.field_150423_aK);
        ObjectLists.addItem("fruit", Items.field_151158_bO);
        ObjectLists.addItem("rawfish", Items.field_151115_aP);
        ObjectLists.addItem("cookedfish", Items.field_179566_aV);
        ObjectLists.addItem("cactusfood", new ItemStack(Items.field_151100_aR, 1, 2));
        ObjectLists.addItem("mushrooms", Items.field_151009_A);
        ObjectLists.addItem("mushrooms", Blocks.field_150337_Q);
        ObjectLists.addItem("mushrooms", Blocks.field_150338_P);
        ObjectLists.addItem("mushrooms", Blocks.field_150337_Q);
        ObjectLists.addItem("mushrooms", Blocks.field_150420_aW);
        ObjectLists.addItem("mushrooms", Blocks.field_150419_aX);
        ObjectLists.addItem("sweets", Items.field_151102_aT);
        ObjectLists.addItem("sweets", new ItemStack(Items.field_151100_aR, 1, 15));
        ObjectLists.addItem("sweets", Items.field_151106_aX);
        ObjectLists.addItem("sweets", Blocks.field_150414_aQ);
        ObjectLists.addItem("sweets", Items.field_151158_bO);
        ObjectLists.addItem("fuel", Items.field_151044_h);
        for (String itemListName : itemListNames) {
            ObjectLists.addFromConfig(itemListName.toLowerCase());
        }
        ObjectLists.addEffect("buffs", MobEffects.field_76420_g);
        ObjectLists.addEffect("buffs", MobEffects.field_76422_e);
        ObjectLists.addEffect("buffs", MobEffects.field_76426_n);
        ObjectLists.addEffect("buffs", MobEffects.field_76432_h);
        ObjectLists.addEffect("buffs", MobEffects.field_76441_p);
        ObjectLists.addEffect("buffs", MobEffects.field_76430_j);
        ObjectLists.addEffect("buffs", MobEffects.field_76424_c);
        ObjectLists.addEffect("buffs", MobEffects.field_76439_r);
        ObjectLists.addEffect("buffs", MobEffects.field_76428_l);
        ObjectLists.addEffect("buffs", MobEffects.field_76429_m);
        ObjectLists.addEffect("buffs", MobEffects.field_76427_o);
        ObjectLists.addEffect("buffs", MobEffects.field_180152_w);
        ObjectLists.addEffect("buffs", MobEffects.field_76444_x);
        ObjectLists.addEffect("buffs", MobEffects.field_76443_y);
        ObjectLists.addEffect("buffs", MobEffects.field_188423_x);
        ObjectLists.addEffect("buffs", MobEffects.field_188424_y);
        ObjectLists.addEffect("buffs", MobEffects.field_188425_z);
        ObjectLists.addEffect("buffs", MobEffects.field_76440_q);
        ObjectLists.addEffect("buffs", MobEffects.field_76431_k);
        ObjectLists.addEffect("buffs", MobEffects.field_76419_f);
        ObjectLists.addEffect("buffs", MobEffects.field_76433_i);
        ObjectLists.addEffect("buffs", MobEffects.field_76438_s);
        ObjectLists.addEffect("buffs", MobEffects.field_76421_d);
        ObjectLists.addEffect("buffs", MobEffects.field_76436_u);
        ObjectLists.addEffect("buffs", MobEffects.field_76437_t);
        ObjectLists.addEffect("buffs", MobEffects.field_82731_v);
        ObjectLists.addEffect("buffs", MobEffects.field_189112_A);
    }

    public static void addFromConfig(String listName) {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "itemlists");
        config.setCategoryComment("item lists", "Here you can add items from vanilla Minecraft or other mods to various lists used by this mod. These are mostly food items that can be fed to farmable/tameable mobs. Format is: mod:itemname,metadata Multiple entries should be semicolon separated, be sure to use a colon and semicolon in the correct place.");
        String customDropsString = config.getString("Item Lists", listName).replace(" ", "");
        LycanitesMobs.printDebug("ItemSetup", "~O========== Custom " + listName + " ==========O~");
        if (customDropsString != null && customDropsString.length() > 0) {
            for (String customDropEntryString : customDropsString.replace(" ", "").split(";")) {
                LycanitesMobs.printDebug("ItemSetup", "Adding: " + customDropEntryString);
                String[] customDropValues = customDropEntryString.split(",");
                String dropName = customDropValues[0];
                int dropMeta = 0;
                if (customDropValues.length > 1) {
                    dropMeta = Integer.parseInt(customDropValues[1]);
                }
                if (Item.func_111206_d((String)dropName) != null) {
                    Item customItem = Item.func_111206_d((String)dropName);
                    ObjectLists.addItem(listName, new ItemStack(customItem, 1, dropMeta));
                    LycanitesMobs.printDebug("ItemSetup", "As Item: " + customItem);
                    continue;
                }
                if (Block.func_149684_b((String)dropName) == null) continue;
                Block customBlock = Block.func_149684_b((String)dropName);
                ObjectLists.addItem(listName, new ItemStack(customBlock, 1, dropMeta));
                LycanitesMobs.printDebug("ItemSetup", "As Block: " + customBlock);
            }
        }
    }

    public static boolean isSword(Item item) {
        if (item == null) {
            return false;
        }
        if (item instanceof ItemSword) {
            return true;
        }
        if (item instanceof ItemShears) {
            return false;
        }
        return item.func_150893_a(new ItemStack(item), Blocks.field_150440_ba.func_176223_P()) > 1.0f;
    }

    public static boolean isPickaxe(Item item) {
        if (item == null) {
            return false;
        }
        try {
            String[] toolNameParts = item.func_77658_a().split("\\.");
            if (toolNameParts.length >= 3 && "InfiTool".equalsIgnoreCase(toolNameParts[1])) {
                String toolName = toolNameParts[2];
                return "Pickaxe".equalsIgnoreCase(toolName) || "Hammer".equalsIgnoreCase(toolName);
            }
            if (item instanceof ItemPickaxe) {
                return true;
            }
            if (item.getHarvestLevel(new ItemStack(item), "pickaxe") != -1) {
                return true;
            }
            return item.func_150893_a(new ItemStack(item), Blocks.field_150348_b.func_176223_P()) > 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAxe(Item item) {
        if (item == null) {
            return false;
        }
        try {
            String[] toolNameParts;
            for (String toolNamePart : toolNameParts = item.func_77658_a().split("\\.")) {
                if (toolNameParts.length < 3 || !"InfiTool".equalsIgnoreCase(toolNameParts[1])) continue;
                String toolName = toolNameParts[2];
                return "Axe".equalsIgnoreCase(toolName) || "LumberAxe".equalsIgnoreCase(toolName) || "Mattock".equalsIgnoreCase(toolName) || "Battleaxe".equalsIgnoreCase(toolName);
            }
            if (item instanceof ItemAxe) {
                return true;
            }
            if (item.getHarvestLevel(new ItemStack(item), "axe") != -1) {
                return true;
            }
            return item.func_150893_a(new ItemStack(item), Blocks.field_150364_r.func_176223_P()) > 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isShovel(Item item) {
        if (item == null) {
            return false;
        }
        try {
            String[] toolNameParts = item.func_77658_a().split("\\.");
            if (toolNameParts.length >= 3 && "InfiTool".equalsIgnoreCase(toolNameParts[1])) {
                String toolName = toolNameParts[2];
                return "Shovel".equalsIgnoreCase(toolName) || "Excavator".equalsIgnoreCase(toolName) || "Mattock".equalsIgnoreCase(toolName);
            }
            if (item instanceof ItemSpade) {
                return true;
            }
            if (item.getHarvestLevel(new ItemStack(item), "shovel") != -1) {
                return true;
            }
            return item.func_150893_a(new ItemStack(item), Blocks.field_150346_d.func_176223_P()) > 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isName(Item item, String name) {
        if (item == null) {
            return false;
        }
        String itemName = item.func_77658_a().toLowerCase();
        return itemName.contains(name);
    }

    public static boolean isName(Block block, String name) {
        if (block == null) {
            return false;
        }
        name = name.toLowerCase();
        String blockName = block.func_149739_a().toLowerCase();
        return blockName.contains(name);
    }
}

