/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.info;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.LycanitesMobs;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityListCustom {
    public Map<String, Class> IDtoClassMapping = new HashMap<String, Class>();
    private Map<Class, String> classToIDMapping = new HashMap<Class, String>();
    public Map<String, EntityEggInfo> entityEggs = Maps.newLinkedHashMap();

    public void addMapping(Class entityClass, String entityID) {
        this.IDtoClassMapping.put(entityID, entityClass);
        this.classToIDMapping.put(entityClass, entityID);
    }

    public void addMapping(Class entityClass, String entityID, int baseColor, int spotColor) {
        this.addMapping(entityClass, entityID);
        this.entityEggs.put(entityID, new EntityEggInfo(entityID, baseColor, spotColor));
    }

    public Entity createEntityFromNBT(NBTTagCompound nbtTagCompound, World world) {
        Entity entity = null;
        if ("Minecart".equals(nbtTagCompound.func_74779_i("id"))) {
            switch (nbtTagCompound.func_74762_e("Type")) {
                case 0: {
                    nbtTagCompound.func_74778_a("id", "MinecartRideable");
                    break;
                }
                case 1: {
                    nbtTagCompound.func_74778_a("id", "MinecartChest");
                    break;
                }
                case 2: {
                    nbtTagCompound.func_74778_a("id", "MinecartFurnace");
                }
            }
            nbtTagCompound.func_82580_o("Type");
        }
        this.createEntityByID(nbtTagCompound.func_74779_i("id"), world);
        return entity;
    }

    public Entity createEntityByID(String entityID, World world) {
        Entity entity = null;
        try {
            Class entityClass = this.getClassFromID(entityID);
            if (entityClass != null) {
                entity = (Entity)entityClass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            LycanitesMobs.printWarning("", "Unable to spawn entity with the id " + entityID);
        }
        return entity;
    }

    public String getEntityID(Entity entity) {
        Class<?> entityClass = entity.getClass();
        return this.classToIDMapping.containsKey(entityClass) ? this.classToIDMapping.get(entityClass) : null;
    }

    public Class getClassFromID(String entityID) {
        return this.IDtoClassMapping.get(entityID);
    }

    public static class EntityEggInfo {
        public final String spawnedID;
        public final int primaryColor;
        public final int secondaryColor;

        public EntityEggInfo(String entityID, int primaryColor, int secondaryColor) {
            this.spawnedID = entityID;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }
    }
}

