/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.info;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class DropRate {
    public ItemStack item = null;
    public ItemStack burningItem = null;
    public Map<Integer, ItemStack> effectsItem = new HashMap<Integer, ItemStack>();
    public int minAmount = 1;
    public int maxAmount = 1;
    public float chance = 0.0f;
    public int subspeciesID = -1;

    public DropRate(ItemStack item, float chance) {
        this.item = item;
        this.minAmount = 1;
        this.maxAmount = 1;
        this.chance = chance;
    }

    public DropRate setDrop(ItemStack item) {
        this.item = item;
        return this;
    }

    public DropRate setBurningDrop(ItemStack item) {
        this.burningItem = item;
        return this;
    }

    public DropRate setEffectDrop(int effectID, ItemStack item) {
        this.effectsItem.put(effectID, item);
        return this;
    }

    public DropRate setMinAmount(int amount) {
        this.minAmount = amount;
        return this;
    }

    public DropRate setMaxAmount(int amount) {
        this.maxAmount = amount;
        return this;
    }

    public DropRate setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public DropRate setSubspecies(int subspeciesID) {
        this.subspeciesID = subspeciesID;
        return this;
    }

    public int getQuantity(Random random, int bonus) {
        float roll = random.nextFloat();
        if ((roll = Math.max(roll, 0.0f)) > this.chance) {
            return 0;
        }
        int max = this.maxAmount + bonus;
        int min = this.minAmount;
        if (max <= min) {
            return min;
        }
        float dropRange = (float)(max - min) * (roll /= this.chance);
        int dropAmount = min + Math.round(dropRange);
        return dropAmount;
    }

    public ItemStack getItemStack(EntityLivingBase entity, int quantity) {
        ItemStack drop = this.item;
        if (entity.func_70027_ad() && this.burningItem != null) {
            drop = this.burningItem;
        }
        for (Object potionEffect : entity.func_70651_bq()) {
            int effectID;
            if (!(potionEffect instanceof PotionEffect) || !this.effectsItem.containsKey(effectID = Potion.func_188409_a((Potion)((PotionEffect)potionEffect).func_188419_a()))) continue;
            drop = this.effectsItem.get(effectID);
        }
        if (drop != null) {
            drop.field_77994_a = quantity;
        }
        return drop;
    }
}

