/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.info;

import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.info.CreatureKnowledge;
import lycanite.lycanitesmobs.api.info.GroupInfo;
import lycanite.lycanitesmobs.api.network.MessageBeastiary;
import lycanite.lycanitesmobs.api.network.MessageCreatureKnowledge;
import lycanite.lycanitesmobs.api.pets.SummonSet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Beastiary {
    public ExtendedPlayer extendedPlayer;
    public Map<String, CreatureKnowledge> creatureKnowledgeList = new HashMap<String, CreatureKnowledge>();

    public Beastiary(ExtendedPlayer extendedPlayer) {
        this.extendedPlayer = extendedPlayer;
    }

    public void newKnowledgeList(Map<String, CreatureKnowledge> newKnowledgeList) {
        this.creatureKnowledgeList = newKnowledgeList;
    }

    public void addToKnowledgeList(CreatureKnowledge newKnowledge) {
        if (ObjectManager.getMob(newKnowledge.creatureName) == null) {
            return;
        }
        this.creatureKnowledgeList.put(newKnowledge.creatureName, newKnowledge);
    }

    public boolean hasFullKnowledge(String creatureName) {
        if (!this.creatureKnowledgeList.containsKey(creatureName)) {
            return false;
        }
        return !(this.creatureKnowledgeList.get((Object)creatureName).completion < 1.0);
    }

    public boolean hasCreatureFromGroup(GroupInfo group) {
        if (this.creatureKnowledgeList.size() == 0) {
            return false;
        }
        for (Map.Entry<String, CreatureKnowledge> creatureKnowledgeEntry : this.creatureKnowledgeList.entrySet()) {
            if (creatureKnowledgeEntry.getValue() == null || creatureKnowledgeEntry.getValue().creatureInfo.group != group) continue;
            return true;
        }
        return false;
    }

    public Map<Integer, String> getSummonableList() {
        HashMap<Integer, String> minionList = new HashMap<Integer, String>();
        int minionIndex = 0;
        for (String minionName : this.creatureKnowledgeList.keySet()) {
            if (!SummonSet.isSummonableCreature(minionName)) continue;
            minionList.put(minionIndex++, minionName);
        }
        return minionList;
    }

    public void sendNewToClient(CreatureKnowledge newKnowledge) {
        MessageCreatureKnowledge message = new MessageCreatureKnowledge(newKnowledge);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.extendedPlayer.getPlayer());
    }

    public void sendAllToClient() {
        MessageBeastiary message = new MessageBeastiary(this);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.extendedPlayer.getPlayer());
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (!nbtTagCompound.func_74764_b("CreatureKnowledge")) {
            return;
        }
        this.newKnowledgeList(new HashMap<String, CreatureKnowledge>());
        NBTTagList knowledgeList = nbtTagCompound.func_150295_c("CreatureKnowledge", 10);
        for (int i = 0; i < knowledgeList.func_74745_c(); ++i) {
            NBTTagCompound nbtKnowledge = knowledgeList.func_150305_b(i);
            if (!nbtKnowledge.func_74764_b("CreatureName") || !nbtKnowledge.func_74764_b("Completion")) continue;
            CreatureKnowledge creatureKnowledge = new CreatureKnowledge(this, nbtKnowledge.func_74779_i("CreatureName"), nbtKnowledge.func_74769_h("Completion"));
            this.addToKnowledgeList(creatureKnowledge);
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList knowledgeList = new NBTTagList();
        for (Map.Entry<String, CreatureKnowledge> creatureKnowledgeEntry : this.creatureKnowledgeList.entrySet()) {
            CreatureKnowledge creatureKnowledge = creatureKnowledgeEntry.getValue();
            NBTTagCompound nbtKnowledge = new NBTTagCompound();
            nbtKnowledge.func_74778_a("CreatureName", creatureKnowledge.creatureName);
            nbtKnowledge.func_74780_a("Completion", creatureKnowledge.completion);
            knowledgeList.func_74742_a((NBTBase)nbtKnowledge);
        }
        nbtTagCompound.func_74782_a("CreatureKnowledge", (NBTBase)knowledgeList);
    }
}

