/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.info;

import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.config.ConfigBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AltarInfo {
    public static boolean altarsEnabled = true;
    public static boolean checkDimensions = false;
    public static Map<String, Double> rareSubspeciesMutlipliers = new HashMap<String, Double>();
    public static Map<String, AltarInfo> altars = new HashMap<String, AltarInfo>();
    public String name = "Altar";

    public static void loadGlobalSettings() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "general");
        config.setCategoryComment("Altars", "Altars are block arrangements that can be activated using Soulkeys to summon rare subspecies as mini bosses or trigger events including boss events.");
        altarsEnabled = config.getBool("Altars", "Altars Enabled", altarsEnabled, "Set to false to disable altars, Soulkeys can still be crafted but wont work on Altars.");
        checkDimensions = config.getBool("Altars", "Check Dimension", checkDimensions, "If set to true, Altars will only activate in dimensions that the monster spawned or event started is allowed in.");
        String[] statNames = new String[]{"Health", "Defense", "Speed", "Damage", "Haste", "Effect", "Pierce"};
        rareSubspeciesMutlipliers = new HashMap<String, Double>();
        for (String statName : statNames) {
            double defaultValue = 10.0;
            if ("Speed".equalsIgnoreCase(statName)) {
                defaultValue = 1.5;
            }
            rareSubspeciesMutlipliers.put(statName.toUpperCase(), config.getDouble("Altars", statName + " Altar Stat Multiplier", defaultValue));
        }
    }

    public static boolean checkAltarsEnabled() {
        if (altars.size() < 1) {
            return false;
        }
        return altarsEnabled;
    }

    public static void addAltar(AltarInfo altarInfo) {
        altars.put(altarInfo.name, altarInfo);
    }

    public static AltarInfo getAltar(String name) {
        if (altars.containsKey(name)) {
            return altars.get(name);
        }
        return null;
    }

    public AltarInfo(String name) {
        this.name = name;
    }

    public boolean checkBlockEvent(Entity entity, World world, BlockPos pos) {
        return true;
    }

    public boolean quickCheck(Entity entity, World world, BlockPos pos) {
        return false;
    }

    public boolean fullCheck(Entity entity, World world, BlockPos pos) {
        return false;
    }

    public boolean activate(Entity entity, World world, BlockPos pos) {
        return false;
    }

    public BlockPos getFacingPosition(BlockPos pos, double distance, double angle) {
        double xAmount = -Math.sin(Math.toRadians(angle));
        double zAmount = Math.cos(Math.toRadians(angle));
        BlockPos facingPos = new BlockPos((double)Math.round((double)pos.func_177958_n() + distance * xAmount), (double)pos.func_177956_o(), (double)Math.round((double)pos.func_177952_p() + distance * zAmount));
        return facingPos;
    }
}

