/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.gui;

import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.api.gui.GUIMinion;
import lycanite.lycanitesmobs.api.info.MobInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;

public class GUIMinionList
extends GuiScrollingList {
    GUIMinion parentGUI;
    Map<Integer, String> minionList = new HashMap<Integer, String>();

    public GUIMinionList(GUIMinion parentGUI, ExtendedPlayer playerExt, int width, int height, int top, int bottom, int left) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, left, 28);
        this.parentGUI = parentGUI;
        this.minionList = playerExt.getBeastiary().getSummonableList();
    }

    protected int getSize() {
        return this.minionList.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parentGUI.selectMinion(this.minionList.get(index));
    }

    protected boolean isSelected(int index) {
        return this.parentGUI.getSelectedMinion() != null && this.parentGUI.getSelectedMinion().equals(this.minionList.get(index));
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int index, int boxRight, int boxTop, int boxBottom, Tessellator tessellator) {
        String mobName = this.minionList.get(index);
        MobInfo mobInfo = MobInfo.mobNameToInfo.get(mobName);
        int boxLeft = this.left;
        int levelBarWidth = 9;
        int levelBarHeight = 9;
        int levelBarX = boxLeft + 20;
        int levelBarY = boxTop + boxBottom - levelBarHeight - 4;
        int levelBarU = 256 - levelBarWidth * 2;
        int levelBarV = 256 - levelBarHeight;
        int level = mobInfo.summonCost;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AssetManager.getTexture("GUIBeastiary"));
        for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
            this.parentGUI.func_73729_b(levelBarX + levelBarWidth * currentLevel, levelBarY, levelBarU, levelBarV, levelBarWidth, levelBarHeight);
        }
        this.parentGUI.getFontRenderer().func_78276_b(mobInfo.getTitle(), this.left + 20, boxTop + 4, 0xFFFFFF);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(mobInfo.getIcon());
        this.parentGUI.drawTexturedModalRect(this.left + 2, boxTop + 4, 0, 0, 16, 16, 16);
    }
}

