/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.gui;

import java.io.IOException;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ExtendedPlayer;
import lycanite.lycanitesmobs.GuiHandler;
import lycanite.lycanitesmobs.LycanitesMobs;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.gui.GUIBaseScreen;
import lycanite.lycanitesmobs.api.gui.GUIButtonCreature;
import lycanite.lycanitesmobs.api.gui.GUIMinionList;
import lycanite.lycanitesmobs.api.gui.GUITabMain;
import lycanite.lycanitesmobs.api.info.MobInfo;
import lycanite.lycanitesmobs.api.pets.SummonSet;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.GuiScrollingList;
import org.lwjgl.opengl.GL11;

public class GUIMinion
extends GUIBaseScreen {
    public static int tabButtonID = 100;
    public EntityPlayer player;
    public ExtendedPlayer playerExt;
    public int editSet;
    public SummonSet summonSet;
    public int minionListSize = 0;
    public GuiScrollingList list;
    public int centerX;
    public int centerY;
    public int windowWidth;
    public int windowHeight;
    public int halfX;
    public int halfY;
    public int windowX;
    public int windowY;

    public static void openToPlayer(EntityPlayer player, int editSet) {
        if (player != null && player.field_70170_p != null) {
            player.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.PLAYER.id, player.field_70170_p, (int)GuiHandler.PlayerGuiType.MINION_MANAGER.id, editSet, 0);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public boolean func_73868_f() {
        return false;
    }

    public GUIMinion(EntityPlayer player, int editSet) {
        this.player = player;
        this.playerExt = ExtendedPlayer.getForPlayer(player);
        this.editSet = editSet;
        this.summonSet = this.playerExt.getSummonSet(editSet);
        this.minionListSize = this.playerExt.getBeastiary().getSummonableList().size();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.centerX = this.field_146294_l / 2;
        this.centerY = this.field_146295_m / 2;
        this.windowWidth = 176;
        this.windowHeight = 166;
        this.halfX = this.windowWidth / 2;
        this.halfY = this.windowHeight / 2;
        this.windowX = this.centerX - this.windowWidth / 2;
        this.windowY = this.centerY - this.windowHeight / 2;
        this.drawControls();
        if (this.hasSummonableMinions()) {
            int buttonSpacing = 2;
            this.list = new GUIMinionList(this, this.playerExt, this.windowWidth / 2 - buttonSpacing * 2, this.windowHeight - 16 - buttonSpacing * 2, this.windowY + 52, this.windowY + 16 + this.windowHeight - 16 - buttonSpacing * 2, this.windowX + buttonSpacing * 2);
            this.list.registerScrollButtons(this.field_146292_n, 51, 52);
        }
    }

    public void func_73863_a(int x, int y, float f) {
        this.drawGuiContainerBackgroundLayer();
        this.updateControls();
        this.drawGuiContainerForegroundLayer();
        if (this.list != null) {
            this.list.drawScreen(x, y, f);
        }
        super.func_73863_a(x, y, f);
    }

    protected void drawGuiContainerForegroundLayer() {
        if (this.hasSummonableMinions()) {
            this.getFontRenderer().func_78276_b(I18n.func_74838_a((String)"gui.minion.name"), this.windowX + 52, this.windowY + 6, 0xFFFFFF);
            return;
        }
        boolean hasSomeKnowledge = this.playerExt.beastiary.creatureKnowledgeList.size() > 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (hasSomeKnowledge) {
            this.getFontRenderer().func_78276_b(I18n.func_74838_a((String)"gui.minion.empty"), this.windowX + 18, this.windowY + 6, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_74838_a((String)"gui.minion.info"), this.windowX + 8, this.windowY + 24, this.windowWidth - 16, 0xFFFFFF);
        } else {
            this.getFontRenderer().func_78276_b(I18n.func_74838_a((String)"gui.beastiary.empty"), this.windowX + 52, this.windowY + 6, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_74838_a((String)"gui.beastiary.soulgazerinfo"), this.windowX + 8, this.windowY + 24, this.windowWidth - 16, 0xFFFFFF);
            int recipeWidth = 108;
            int recipeHeight = 54;
            this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIBeastiary"));
            this.func_73729_b(this.windowX + this.windowWidth / 2 - recipeWidth / 2, this.windowY + this.windowHeight - recipeHeight - 16, 0, 256 - recipeHeight, recipeWidth, recipeHeight);
        }
    }

    protected void drawGuiContainerBackgroundLayer() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIMinion"));
        this.func_73729_b(this.windowX, this.windowY, 0, 0, this.windowWidth, this.windowHeight);
    }

    protected void drawControls() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonSpacing = 2;
        int buttonWidth = 32;
        int buttonHeight = 32;
        int buttonX = this.windowX + 2;
        int buttonY = this.windowY + 16;
        this.field_146292_n.add(new GUITabMain(55555, buttonX, this.windowY - 27));
        if (!this.hasSummonableMinions()) {
            return;
        }
        int tabCount = 5;
        int tabSpacing = buttonSpacing;
        for (int i = 1; i <= tabCount; ++i) {
            String buttonText = String.valueOf(i);
            MobInfo mobInfo = this.playerExt.getSummonSet(i).getMobInfo();
            GUIButtonCreature tabButton = new GUIButtonCreature(tabButtonID + i, buttonX += tabSpacing, buttonY, buttonWidth, buttonHeight, buttonText, mobInfo);
            this.field_146292_n.add(tabButton);
            if (i == this.editSet) {
                tabButton.field_146124_l = false;
            }
            tabSpacing = buttonWidth + buttonSpacing;
        }
        buttonSpacing = 1;
        buttonWidth = this.windowWidth / 2 - buttonSpacing * 4;
        buttonHeight = 20;
        buttonX = this.centerX + buttonSpacing;
        buttonY = this.windowY + 30;
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.SITTING.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.STANCE.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.PVP.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
    }

    public void updateControls() {
        if (!this.hasSummonableMinions()) {
            return;
        }
        for (Object buttonObj : this.field_146292_n) {
            if (!(buttonObj instanceof GuiButton)) continue;
            GuiButton button = (GuiButton)buttonObj;
            if (button.field_146127_k < tabButtonID) {
                if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SITTING.id) {
                    button.field_146126_j = I18n.func_74838_a((String)"gui.pet.sitting") + ": " + (this.summonSet.getSitting() ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
                }
                if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id) {
                    String string = button.field_146126_j = this.summonSet.getFollowing() ? I18n.func_74838_a((String)"gui.pet.follow") : I18n.func_74838_a((String)"gui.pet.wander");
                }
                if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id) {
                    button.field_146126_j = I18n.func_74838_a((String)"gui.pet.passive") + ": " + (this.summonSet.getPassive() ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
                }
                if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.STANCE.id) {
                    String string = button.field_146126_j = this.summonSet.getAggressive() ? I18n.func_74838_a((String)"gui.pet.aggressive") : I18n.func_74838_a((String)"gui.pet.defensive");
                }
                if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PVP.id) {
                    button.field_146126_j = I18n.func_74838_a((String)"gui.pet.pvp") + ": " + (this.summonSet.getPVP() ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
                }
            }
            if (button.field_146127_k < tabButtonID) continue;
            button.field_146124_l = button.field_146127_k - tabButtonID != this.editSet;
        }
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        if (guiButton != null) {
            if (guiButton.field_146127_k < tabButtonID) {
                if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SITTING.id) {
                    boolean bl = this.summonSet.sitting = !this.summonSet.sitting;
                }
                if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id) {
                    boolean bl = this.summonSet.following = !this.summonSet.following;
                }
                if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id) {
                    boolean bl = this.summonSet.passive = !this.summonSet.passive;
                }
                if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.STANCE.id) {
                    boolean bl = this.summonSet.aggressive = !this.summonSet.aggressive;
                }
                if (guiButton.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PVP.id) {
                    this.summonSet.pvp = !this.summonSet.pvp;
                }
                this.playerExt.sendSummonSetToServer((byte)this.editSet);
            }
            if (guiButton.field_146127_k >= tabButtonID) {
                this.editSet = guiButton.field_146127_k - tabButtonID;
                if (this.editSet > 0 && this.editSet <= this.playerExt.summonSetMax) {
                    this.summonSet = this.playerExt.getSummonSet(this.editSet);
                }
            }
        }
        super.func_146284_a(guiButton);
    }

    public void selectMinion(String minionName) {
        this.summonSet.setSummonType(minionName);
        this.playerExt.sendSummonSetToServer((byte)this.editSet);
        for (Object buttonObj : this.field_146292_n) {
            MobInfo mobInfo;
            GuiButton button = (GuiButton)buttonObj;
            if (!(button instanceof GUIButtonCreature)) continue;
            if (button.field_146127_k != this.editSet + tabButtonID) continue;
            ((GUIButtonCreature)button).mobInfo = mobInfo = this.playerExt.getSummonSet(this.editSet).getMobInfo();
        }
    }

    public String getSelectedMinion() {
        return this.summonSet.summonType;
    }

    public boolean hasSummonableMinions() {
        return this.minionListSize > 0;
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == 1 || par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73869_a(par1, par2);
    }
}

