/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity.ai;

import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.EntityCreatureTameable;
import lycanite.lycanitesmobs.api.info.ObjectLists;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.BlockPos;

public class EntityAITempt
extends EntityAIBase {
    private EntityCreatureBase host;
    private EntityPlayer player;
    private double speed = 1.0;
    private ItemStack temptItem = null;
    private boolean ignoreTemptMeta = false;
    private String temptList = null;
    private int retemptTime;
    private int retemptTimeMax = 10;
    private double temptDistanceMin = 1.0;
    private double temptDistanceMax = 10.0;
    private boolean scaredByPlayerMovement = false;
    private boolean stopAttack = false;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double targetPitch;
    private double targetYaw;
    private boolean canSwim;
    private boolean isRunning;

    public EntityAITempt(EntityCreatureBase setHost) {
        this.host = setHost;
        this.func_75248_a(3);
    }

    public EntityAITempt setSpeed(double setSpeed) {
        this.speed = setSpeed;
        return this;
    }

    public EntityAITempt setItem(ItemStack item) {
        this.temptItem = item;
        return this;
    }

    public EntityAITempt setIgnoreMeta(boolean ignore) {
        this.ignoreTemptMeta = ignore;
        return this;
    }

    public EntityAITempt setItemList(String list) {
        this.temptList = list;
        return this;
    }

    public EntityAITempt setRetemptTime(int time) {
        this.retemptTimeMax = time;
        return this;
    }

    public EntityAITempt setTemptDistanceMin(double dist) {
        this.temptDistanceMin = dist;
        return this;
    }

    public EntityAITempt setTemptDistanceMax(double dist) {
        this.temptDistanceMax = dist;
        return this;
    }

    public EntityAITempt setScaredByMovement(boolean scared) {
        this.scaredByPlayerMovement = scared;
        return this;
    }

    public EntityAITempt setStopAttack(boolean setStopAttack) {
        this.stopAttack = setStopAttack;
        return this;
    }

    public boolean func_75250_a() {
        if (this.retemptTime > 0) {
            --this.retemptTime;
            return false;
        }
        if (!this.host.canBeTempted()) {
            return false;
        }
        if (this.host instanceof EntityCreatureTameable && ((EntityCreatureTameable)this.host).isTamed()) {
            return false;
        }
        this.player = this.host.field_70170_p.func_72890_a((Entity)this.host, this.temptDistanceMax);
        if (this.player == null) {
            return false;
        }
        if (!this.isTemptStack(this.player.func_184614_ca()) && !this.isTemptStack(this.player.func_184592_cb())) {
            return false;
        }
        this.host.setStealth(0.0f);
        return true;
    }

    public boolean isTemptStack(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (this.temptList != null) {
            if (!ObjectLists.inItemList(this.temptList, itemStack)) {
                return false;
            }
        } else {
            if (itemStack.func_77973_b() != this.temptItem.func_77973_b()) {
                return false;
            }
            if (!this.ignoreTemptMeta && itemStack.func_77973_b() == this.temptItem.func_77973_b() && itemStack.func_77952_i() != this.temptItem.func_77952_i()) {
                return false;
            }
        }
        return true;
    }

    public boolean func_75253_b() {
        if (this.scaredByPlayerMovement) {
            if (this.host.func_70068_e((Entity)this.player) < 36.0) {
                if (this.player.func_70092_e(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.player.field_70125_A - this.targetPitch) > 5.0 || Math.abs((double)this.player.field_70177_z - this.targetYaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.player.field_70165_t;
                this.targetY = this.player.field_70163_u;
                this.targetZ = this.player.field_70161_v;
            }
            this.targetPitch = this.player.field_70125_A;
            this.targetYaw = this.player.field_70177_z;
        }
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.targetX = this.player.field_70165_t;
        this.targetY = this.player.field_70163_u;
        this.targetZ = this.player.field_70161_v;
        this.isRunning = true;
        if (this.host.func_70661_as() instanceof PathNavigateGround) {
            PathNavigateGround navigateGround = (PathNavigateGround)this.host.func_70661_as();
            this.canSwim = !navigateGround.func_179684_h();
            navigateGround.func_179693_d(true);
        }
        if (this.stopAttack) {
            this.host.func_70624_b(null);
        }
    }

    public void func_75251_c() {
        EntityCreatureAgeable ageable;
        this.player = null;
        this.host.func_70661_as().func_75499_g();
        this.retemptTime = this.retemptTimeMax;
        if (this.host instanceof EntityCreatureAgeable && !(ageable = (EntityCreatureAgeable)this.host).func_70631_g_() && !ageable.canBreed()) {
            this.retemptTime *= 10;
        }
        this.isRunning = false;
        if (this.host.func_70661_as() instanceof PathNavigateGround) {
            PathNavigateGround navigateGround = (PathNavigateGround)this.host.func_70661_as();
            navigateGround.func_179693_d(this.canSwim);
        }
    }

    public void func_75246_d() {
        if (this.stopAttack) {
            this.host.func_70624_b(null);
        }
        this.host.func_70671_ap().func_75651_a((Entity)this.player, 30.0f, (float)this.host.func_70646_bf());
        if (this.host.func_70068_e((Entity)this.player) < this.temptDistanceMin) {
            this.host.clearMovement();
        } else if (!this.host.useDirectNavigator()) {
            this.host.func_70661_as().func_75497_a((Entity)this.player, this.speed);
        } else {
            this.host.directNavigator.setTargetPosition(new BlockPos((int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v), this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

