/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity.ai;

import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;

public class EntityAIStayByWater
extends EntityAIBase {
    private EntityCreatureBase host;
    private double speed = 1.0;
    private double strayDistance = 64.0;
    private BlockPos waterPos;
    private boolean hasWaterPos = false;
    private int waterSearchRate = 0;
    private int updateRate = 0;

    public EntityAIStayByWater(EntityCreatureBase setHost) {
        this.host = setHost;
        this.func_75248_a(1);
    }

    public EntityAIStayByWater setSpeed(double setSpeed) {
        this.speed = setSpeed;
        return this;
    }

    public EntityAIStayByWater setStrayDistance(double strayDistance) {
        this.strayDistance = strayDistance;
        return this;
    }

    public boolean func_75250_a() {
        if (this.host.func_70090_H()) {
            IBlockState waterBlock = this.host.field_70170_p.func_180495_p(this.host.func_180425_c());
            if (!this.host.isLavaCreature && waterBlock.func_185904_a() == Material.field_151586_h || this.host.isLavaCreature && waterBlock.func_185904_a() == Material.field_151587_i) {
                this.waterPos = this.host.func_180425_c();
                this.hasWaterPos = true;
                return false;
            }
        }
        if (!this.host.func_70090_H()) {
            if (this.hasWaterPos && !this.isValidWaterPosition(this.waterPos)) {
                this.hasWaterPos = false;
            }
            if (this.waterSearchRate-- <= 0) {
                this.waterSearchRate = !this.hasWaterPos ? 40 : 100;
                double closestDistance = 99999.0;
                if (this.hasWaterPos) {
                    closestDistance = this.getDistanceFromWater();
                }
                int searchRangeX = 32;
                int searchRangeY = 8;
                int searchRangeZ = 32;
                BlockPos hostPos = this.host.func_180425_c();
                for (int searchX = hostPos.func_177958_n() - searchRangeX; searchX <= hostPos.func_177958_n() + searchRangeX; ++searchX) {
                    for (int searchY = hostPos.func_177956_o() - searchRangeY; searchY <= hostPos.func_177956_o() + searchRangeY; ++searchY) {
                        for (int searchZ = hostPos.func_177952_p() - searchRangeZ; searchZ <= hostPos.func_177952_p() + searchRangeZ; ++searchZ) {
                            boolean enoughSpace;
                            BlockPos searchPos = new BlockPos(searchX, searchY, searchZ);
                            double searchDistance = this.host.func_174818_b(searchPos);
                            if (this.hasWaterPos && !(searchDistance < closestDistance) || !this.isValidWaterPosition(searchPos)) continue;
                            boolean bl = enoughSpace = Math.round(this.host.field_70130_N) <= 1;
                            if (!enoughSpace) {
                                enoughSpace = true;
                                int neededSpace = Math.round(this.host.field_70130_N + 0.5f);
                                block3: for (int adjX = searchX - neededSpace; adjX <= searchX + neededSpace; ++adjX) {
                                    for (int adjZ = searchZ - neededSpace; adjZ <= searchZ + neededSpace; ++adjZ) {
                                        if (!this.host.field_70170_p.func_180495_p(new BlockPos(adjX, searchY, adjZ)).func_185904_a().func_76220_a()) continue;
                                        enoughSpace = false;
                                        continue block3;
                                    }
                                }
                            }
                            if (!enoughSpace) continue;
                            closestDistance = searchDistance;
                            this.waterPos = searchPos;
                            this.hasWaterPos = true;
                        }
                    }
                }
            }
        }
        if (!this.host.isLavaCreature && this.host.waterContact() && this.getDistanceFromWater() <= this.strayDistance) {
            return false;
        }
        if (this.host.hasAttackTarget() && this.host.func_70086_ai() > -100 && this.getDistanceFromWater() <= this.strayDistance) {
            return false;
        }
        return this.hasWaterPos;
    }

    public boolean isValidWaterPosition(BlockPos pos) {
        if (!this.host.func_70648_aU()) {
            return false;
        }
        if (!this.host.waterDamage() && this.host.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            return true;
        }
        return (this.host.func_70045_F() || this.host.isLavaCreature) && this.host.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151587_i;
    }

    public void func_75249_e() {
        this.updateRate = 0;
    }

    public void func_75246_d() {
        if (this.updateRate-- <= 0) {
            this.updateRate = 20;
            if (!this.host.useDirectNavigator()) {
                this.host.func_70661_as().func_75492_a((double)this.waterPos.func_177958_n() + 0.5, (double)this.waterPos.func_177956_o(), (double)this.waterPos.func_177952_p() + 0.5, this.speed);
            } else {
                this.host.directNavigator.setTargetPosition(this.waterPos, this.speed);
            }
        }
    }

    public void func_75251_c() {
        this.host.clearMovement();
    }

    public double getDistanceFromWater() {
        if (!this.hasWaterPos) {
            return 0.0;
        }
        return this.host.func_174818_b(this.waterPos);
    }
}

