/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.api.entity;

import java.util.HashMap;
import java.util.UUID;
import lycanite.lycanitesmobs.AssetManager;
import lycanite.lycanitesmobs.ObjectManager;
import lycanite.lycanitesmobs.api.entity.EntityCreatureAgeable;
import lycanite.lycanitesmobs.api.entity.EntityCreatureBase;
import lycanite.lycanitesmobs.api.entity.MinionEntityDamageSource;
import lycanite.lycanitesmobs.api.entity.ai.EntityAISit;
import lycanite.lycanitesmobs.api.info.MobInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCreatureTameable
extends EntityCreatureAgeable
implements IEntityOwnable {
    public float hunger = this.getCreatureHungerMax();
    public float stamina = this.getStaminaMax();
    public float staminaRecovery = 0.5f;
    public boolean isMobWhenNotTamed = true;
    public float sittingGuardRange = 16.0f;
    public UUID ownerUUID;
    public EntityAISit aiSit = new EntityAISit(this);
    protected static final DataParameter<Byte> TAMED = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<String> OWNER = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Float> HUNGER = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> STAMINA = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityCreatureTameable(World world) {
        super(world);
        this.setTamed(false);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)0);
        this.field_70180_af.func_187214_a(OWNER, (Object)"");
        this.field_70180_af.func_187214_a(HUNGER, (Object)new Float(this.getCreatureHungerMax()));
        this.field_70180_af.func_187214_a(STAMINA, (Object)new Float(this.getStaminaMax()));
    }

    @Override
    public String func_70005_c_() {
        if (!this.isTamed() || !MobInfo.ownerTags) {
            return super.func_70005_c_();
        }
        String ownerName = this.getOwnerName();
        String ownerSuffix = "'s ";
        if (ownerName != null && ownerName.length() > 0 && ("s".equals(ownerName.substring(ownerName.length() - 1)) || "S".equals(ownerName.substring(ownerName.length() - 1)))) {
            ownerSuffix = "' ";
        }
        String ownedName = ownerName + ownerSuffix + this.getFullName();
        if (this.func_145818_k_()) {
            return super.func_70005_c_() + " (" + ownedName + ")";
        }
        return ownedName;
    }

    @Override
    protected boolean func_70692_ba() {
        if (this.isTamed()) {
            return false;
        }
        return super.func_70692_ba();
    }

    @Override
    public boolean despawnCheck() {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.getPetEntry() != null && this.getPetEntry().entity != this && this.getPetEntry().entity != null) {
            return true;
        }
        if (this.isTamed() && !this.isTemporary) {
            return false;
        }
        return super.despawnCheck();
    }

    @Override
    public boolean isPersistant() {
        return this.isTamed() || super.isPersistant();
    }

    @Override
    public void applySubspeciesHealthMultiplier() {
        if (this.isTamed()) {
            return;
        }
        super.applySubspeciesHealthMultiplier();
    }

    public void applyTamedHealthMultiplier() {
        double tamedHealth = this.getBaseHealth();
        if (this.isTamed()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(tamedHealth *= 3.0);
            if ((double)this.func_110143_aJ() > tamedHealth) {
                this.func_70606_j((float)tamedHealth);
            }
        } else {
            this.applySubspeciesHealthMultiplier();
        }
    }

    @Override
    public boolean func_184652_a(EntityPlayer player) {
        if (this.isTamed() && player.func_70005_c_().equalsIgnoreCase(this.getOwnerName())) {
            return true;
        }
        return super.func_184652_a(player);
    }

    @Override
    public void testLeash(float distance) {
        if (this.isSitting() && distance > 10.0f) {
            this.func_110160_i(true, true);
        } else {
            super.testLeash(distance);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.staminaUpdate();
    }

    public void staminaUpdate() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.stamina < this.getStaminaMax() && this.staminaRecovery >= this.getStaminaRecoveryMax() / 2.0f) {
            this.setStamina(Math.min(this.stamina + this.staminaRecovery, this.getStaminaMax()));
        }
        if (this.staminaRecovery < this.getStaminaRecoveryMax()) {
            this.staminaRecovery = Math.min(this.staminaRecovery + this.getStaminaRecoveryMax() / (float)this.getStaminaRecoveryWarmup(), this.getStaminaRecoveryMax());
        }
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        if (!this.field_70170_p.field_72995_K && this.isTamed() && (itemStack == null || player.func_70093_af()) && player.func_70005_c_().equalsIgnoreCase(this.getOwnerName())) {
            commands.put(EntityCreatureBase.CMD_PRIOR.MAIN.id, "GUI");
        }
        if (!this.field_70170_p.field_72995_K && itemStack != null && !player.func_70093_af()) {
            String equipSlot;
            if (!this.isTamed() && this.isTamingItem(itemStack) && MobInfo.tamingEnabled) {
                commands.put(EntityCreatureBase.CMD_PRIOR.IMPORTANT.id, "Tame");
            }
            if (this.isTamed() && this.isHealingItem(itemStack) && this.func_110143_aJ() < this.func_110138_aP()) {
                commands.put(EntityCreatureBase.CMD_PRIOR.ITEM_USE.id, "Feed");
            }
            if (this.isTamed() && !this.func_70631_g_() && this.canEquip() && player.func_70005_c_().equalsIgnoreCase(this.getOwnerName()) && (equipSlot = this.inventory.getSlotForEquipment(itemStack)) != null && (this.inventory.getEquipmentStack(equipSlot) == null || this.inventory.getEquipmentStack(equipSlot).func_77973_b() != itemStack.func_77973_b())) {
                commands.put(EntityCreatureBase.CMD_PRIOR.EQUIPPING.id, "Equip Item");
            }
        }
        return commands;
    }

    @Override
    public void performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        if (command.equals("GUI")) {
            this.playTameSound();
            this.openGUI(player);
        }
        if (command.equals("Tame")) {
            this.tame(player);
            this.consumePlayersItem(player, itemStack);
        }
        if (command.equals("Feed")) {
            int healAmount = 4;
            if (itemStack.func_77973_b() instanceof ItemFood) {
                ItemFood itemFood = (ItemFood)itemStack.func_77973_b();
                healAmount = itemFood.func_150905_g(itemStack);
            }
            this.func_70691_i(healAmount);
            this.playEatSound();
            if (this.field_70170_p.field_72995_K) {
                EnumParticleTypes particle = EnumParticleTypes.HEART;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                for (int i = 0; i < 25; ++i) {
                    this.field_70170_p.func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
            this.consumePlayersItem(player, itemStack);
        }
        if (command.equals("Equip Item")) {
            ItemStack equippedItem = this.inventory.getEquipmentStack(this.inventory.getSlotForEquipment(itemStack));
            if (equippedItem != null) {
                this.dropItem(equippedItem);
            }
            ItemStack equipStack = itemStack.func_77946_l();
            equipStack.field_77994_a = 1;
            this.inventory.setEquipmentStack(equipStack.func_77946_l());
            this.consumePlayersItem(player, itemStack);
        }
        if (command.equals("Sit")) {
            this.playTameSound();
            this.func_70624_b(null);
            this.clearMovement();
            this.setSitting(!this.isSitting());
            this.field_70703_bu = false;
        }
        super.performCommand(command, player, itemStack);
    }

    @Override
    public boolean canNameTag(EntityPlayer player) {
        if (!this.isTamed()) {
            return super.canNameTag(player);
        }
        if (this.isTamed() && player.func_70005_c_().equalsIgnoreCase(this.getOwnerName())) {
            return super.canNameTag(player);
        }
        return false;
    }

    @Override
    public void performGUICommand(EntityPlayer player, byte guiCommandID) {
        if (!this.petControlsEnabled()) {
            return;
        }
        if (player != this.func_70902_q()) {
            return;
        }
        if (guiCommandID == EntityCreatureBase.GUI_COMMAND_ID.SITTING.id) {
            this.setSitting(!this.isSitting());
            this.playTameSound();
        }
        if (guiCommandID == EntityCreatureBase.GUI_COMMAND_ID.FOLLOWING.id) {
            this.setFollowing(!this.isFollowing());
            this.playTameSound();
        }
        if (guiCommandID == EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id) {
            this.setPassive(!this.isPassive());
            this.playTameSound();
        }
        if (guiCommandID == EntityCreatureBase.GUI_COMMAND_ID.STANCE.id) {
            this.setAggressive(!this.isAggressive());
            this.playTameSound();
        }
        if (guiCommandID == EntityCreatureBase.GUI_COMMAND_ID.PVP.id) {
            this.setPVP(!this.isPVP());
            this.playTameSound();
        }
        if (this.petEntry != null && this.petEntry.summonSet != null) {
            this.petEntry.summonSet.updateBehaviour(this);
        }
        super.performGUICommand(player, guiCommandID);
    }

    public Team func_96124_cp() {
        Entity owner;
        if (this.isTamed() && (owner = this.func_70902_q()) != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity target) {
        if (this.isTamed()) {
            EntityCreatureTameable tamedTarget;
            if (target == this.func_70902_q()) {
                return true;
            }
            if (target instanceof EntityCreatureTameable && ((tamedTarget = (EntityCreatureTameable)target).isTamed() && !this.field_70170_p.func_73046_m().func_71219_W() || !this.isPVP() || tamedTarget.func_70902_q() == this.func_70902_q())) {
                return true;
            }
            if (this.func_70902_q() != null) {
                return this.func_70902_q().func_184191_r(target);
            }
        }
        return super.func_184191_r(target);
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (this.isPassive()) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (this.isPassive()) {
            return false;
        }
        if (this.isTamed()) {
            if (this.func_70902_q() == targetEntity) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityCreatureTameable targetTameable;
                boolean canPVP;
                boolean bl = canPVP = this.field_70170_p.func_73046_m().func_71219_W() && this.isPVP();
                if (targetEntity instanceof EntityPlayer && !canPVP) {
                    return false;
                }
                if (targetEntity instanceof EntityCreatureTameable && (targetTameable = (EntityCreatureTameable)targetEntity).isTamed()) {
                    if (!canPVP) {
                        return false;
                    }
                    if (targetTameable.func_70902_q() == this.func_70902_q()) {
                        return false;
                    }
                }
            }
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public DamageSource getDamageSource(EntityDamageSource nestedDamageSource) {
        if (this.isTamed() && this.func_70902_q() != null) {
            if (nestedDamageSource == null) {
                nestedDamageSource = new EntityDamageSource("mob", (Entity)this);
            }
            return new MinionEntityDamageSource(nestedDamageSource, this.func_70902_q());
        }
        return super.getDamageSource(nestedDamageSource);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSrc, float damage) {
        Entity entity;
        if (this.func_180431_b(damageSrc)) {
            return false;
        }
        if (!this.isPassive()) {
            this.setSitting(false);
        }
        if ((entity = damageSrc.func_76364_f()) instanceof EntityThrowable) {
            entity = ((EntityThrowable)entity).func_85052_h();
        }
        if (this.isTamed() && this.func_70902_q() == entity) {
            return false;
        }
        return super.func_70097_a(damageSrc, damage);
    }

    public boolean isTamed() {
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & TAMED_ID.IS_TAMED.id) != 0;
    }

    public void setTamed(boolean setTamed) {
        byte tamed = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (setTamed) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamed | TAMED_ID.IS_TAMED.id)));
            this.spawnEventType = "";
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamed - (tamed & TAMED_ID.IS_TAMED.id))));
        }
        this.func_174805_g(setTamed);
        this.applyTamedHealthMultiplier();
    }

    public boolean isTamingItem(ItemStack itemstack) {
        return false;
    }

    public boolean tame(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.getSubspeciesIndex() < 3) {
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.setPlayerOwner(player);
                this.unsetTemporary();
                String tameMessage = I18n.func_74838_a((String)"message.pet.tamed");
                tameMessage = tameMessage.replace("%creature%", this.getSpeciesName());
                player.func_145747_a((ITextComponent)new TextComponentString(tameMessage));
                this.playTameEffect(this.isTamed());
                player.func_71064_a((StatBase)ObjectManager.getAchievement(this.mobInfo.name + ".tame"), 1);
                if (this.field_71088_bW > this.func_82147_ab()) {
                    this.field_71088_bW = this.func_82147_ab();
                }
            } else {
                String tameFailedMessage = I18n.func_74838_a((String)"message.pet.tamefail");
                tameFailedMessage = tameFailedMessage.replace("%creature%", this.getSpeciesName());
                player.func_145747_a((ITextComponent)new TextComponentString(tameFailedMessage));
                this.playTameEffect(this.isTamed());
            }
        }
        return this.isTamed();
    }

    public void setPlayerOwner(EntityPlayer player) {
        this.setPlayerOwner();
        this.setOwnerId(player.func_110124_au());
        this.setOwner(player.func_70005_c_());
    }

    public void setPlayerOwner(UUID playerUUID, String playerName) {
        this.setPlayerOwner();
        this.setOwnerId(playerUUID);
        this.setOwner(playerName);
    }

    public void setPlayerOwner() {
        this.setTamed(true);
        this.clearMovement();
        this.func_70624_b(null);
        this.setSitting(false);
        this.setFollowing(true);
        this.setPassive(false);
        this.setAggressive(false);
        this.setPVP(true);
        this.playTameSound();
    }

    public String getOwnerName() {
        return (String)this.field_70180_af.func_187225_a(OWNER);
    }

    public void setOwner(String owner) {
        this.field_70180_af.func_187227_b(OWNER, (Object)owner);
    }

    public UUID func_184753_b() {
        return this.ownerUUID;
    }

    public void setOwnerId(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public Entity func_70902_q() {
        if (this.func_184753_b() == null) {
            return null;
        }
        return this.field_70170_p.func_152378_a(this.func_184753_b());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte status) {
        if (status == 7) {
            this.playTameEffect(true);
        } else if (status == 6) {
            this.playTameEffect(false);
        } else {
            super.func_70103_a(status);
        }
    }

    public boolean isHealingItem(ItemStack testStack) {
        return false;
    }

    public boolean petControlsEnabled() {
        return false;
    }

    public byte behaviourBitMask() {
        return (Byte)this.field_70180_af.func_187225_a(TAMED);
    }

    public boolean isSitting() {
        if (!this.isTamed()) {
            return false;
        }
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & TAMED_ID.MOVE_SIT.id) != 0;
    }

    public void setSitting(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.MOVE_SIT.id)));
            this.setHome((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.sittingGuardRange);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.MOVE_SIT.id))));
            this.detachHome();
        }
    }

    public boolean isFollowing() {
        if (!this.isTamed()) {
            return false;
        }
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & TAMED_ID.MOVE_FOLLOW.id) != 0;
    }

    public void setFollowing(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.MOVE_FOLLOW.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.MOVE_FOLLOW.id))));
        }
    }

    public boolean isPassive() {
        if (!this.isTamed()) {
            return false;
        }
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & TAMED_ID.STANCE_PASSIVE.id) != 0;
    }

    public void setPassive(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.STANCE_PASSIVE.id)));
            this.func_70624_b(null);
            this.setStealth(0.0f);
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.STANCE_PASSIVE.id))));
        }
    }

    @Override
    public boolean isAggressive() {
        if (!this.isTamed()) {
            return super.isAggressive();
        }
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & TAMED_ID.STANCE_AGGRESSIVE.id) != 0;
    }

    public void setAggressive(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.STANCE_AGGRESSIVE.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.STANCE_AGGRESSIVE.id))));
        }
    }

    public boolean isPVP() {
        return ((Byte)this.field_70180_af.func_187225_a(TAMED) & TAMED_ID.PVP.id) != 0;
    }

    public void setPVP(boolean set) {
        if (!this.petControlsEnabled()) {
            set = false;
        }
        byte tamedStatus = (Byte)this.field_70180_af.func_187225_a(TAMED);
        if (set) {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus | TAMED_ID.PVP.id)));
        } else {
            this.field_70180_af.func_187227_b(TAMED, (Object)((byte)(tamedStatus - (tamedStatus & TAMED_ID.PVP.id))));
        }
    }

    public float getCreatureHunger() {
        if (this.field_70170_p == null) {
            return this.getCreatureHungerMax();
        }
        if (!this.field_70170_p.field_72995_K) {
            return this.hunger;
        }
        return Float.valueOf(((Float)this.field_70180_af.func_187225_a(HUNGER)).floatValue()).floatValue();
    }

    public void setCreatureHunger(float setHunger) {
        this.hunger = setHunger;
    }

    public float getCreatureHungerMax() {
        return 20.0f;
    }

    public float getStamina() {
        if (this.field_70170_p != null && this.field_70170_p.field_72995_K) {
            this.stamina = ((Float)this.field_70180_af.func_187225_a(STAMINA)).floatValue();
        }
        return this.stamina;
    }

    public void setStamina(float setStamina) {
        this.stamina = setStamina;
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(STAMINA, (Object)Float.valueOf(setStamina));
        }
    }

    public float getStaminaMax() {
        return 100.0f;
    }

    public float getStaminaRecoveryMax() {
        return 0.5f;
    }

    public int getStaminaRecoveryWarmup() {
        return 200;
    }

    public float getStaminaCost() {
        return 1.0f;
    }

    public void applyStaminaCost() {
        float newStamina = this.getStamina() - this.getStaminaCost();
        if (newStamina < 0.0f) {
            newStamina = 0.0f;
        }
        this.setStamina(newStamina);
        this.staminaRecovery = 0.0f;
    }

    public float getStaminaPercent() {
        return this.getStamina() / this.getStaminaMax();
    }

    public String getStaminaType() {
        return "energy";
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        EntityCreatureAgeable spawnedBaby = super.createChild(baby);
        String ownerName = this.getOwnerName();
        if (ownerName != null && ownerName.trim().length() > 0 && spawnedBaby != null && spawnedBaby instanceof EntityCreatureTameable) {
            EntityCreatureTameable tamedBaby = (EntityCreatureTameable)spawnedBaby;
            tamedBaby.setOwner(ownerName);
            tamedBaby.setTamed(true);
        }
        return spawnedBaby;
    }

    @Override
    public boolean isHostile() {
        if (this.isMobWhenNotTamed) {
            return !this.isTamed();
        }
        return super.isHostile();
    }

    @Override
    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.isTamed()) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    @Override
    public boolean canBeTempted() {
        return !this.isTamed();
    }

    public boolean canSit() {
        return true;
    }

    protected void playTameEffect(boolean success) {
        EnumParticleTypes particle = EnumParticleTypes.HEART;
        if (!success) {
            particle = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @Override
    public boolean canBeColored(EntityPlayer player) {
        if (player == null) {
            return true;
        }
        return this.isTamed() && player.func_70005_c_().equalsIgnoreCase(this.getOwnerName());
    }

    @Override
    public boolean showBossInfo() {
        if (this.isTamed()) {
            return false;
        }
        return super.showBossInfo();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("Owner")) {
            String owner = nbtTagCompound.func_74779_i("Owner");
            if (owner.length() > 0) {
                this.setOwner(owner);
                this.setTamed(true);
            }
        } else {
            this.setOwner("");
            this.setTamed(false);
        }
        if (nbtTagCompound.func_74764_b("OwnerUUID")) {
            String uuidString = nbtTagCompound.func_74779_i("OwnerUUID");
            if (!"".equals(uuidString)) {
                this.setOwnerId(UUID.fromString(uuidString));
            } else {
                this.setOwnerId(null);
            }
        } else {
            this.ownerUUID = null;
        }
        if (nbtTagCompound.func_74764_b("Sitting")) {
            this.setSitting(nbtTagCompound.func_74767_n("Sitting"));
        } else {
            this.setSitting(false);
        }
        if (nbtTagCompound.func_74764_b("Following")) {
            this.setFollowing(nbtTagCompound.func_74767_n("Following"));
        } else {
            this.setFollowing(true);
        }
        if (nbtTagCompound.func_74764_b("Passive")) {
            this.setPassive(nbtTagCompound.func_74767_n("Passive"));
        } else {
            this.setPassive(false);
        }
        if (nbtTagCompound.func_74764_b("Aggressive")) {
            this.setAggressive(nbtTagCompound.func_74767_n("Aggressive"));
        } else {
            this.setAggressive(false);
        }
        if (nbtTagCompound.func_74764_b("PVP")) {
            this.setPVP(nbtTagCompound.func_74767_n("PVP"));
        } else {
            this.setPVP(true);
        }
        if (nbtTagCompound.func_74764_b("Hunger")) {
            this.setCreatureHunger(nbtTagCompound.func_74760_g("Hunger"));
        } else {
            this.setCreatureHunger(this.getCreatureHungerMax());
        }
        if (nbtTagCompound.func_74764_b("Stamina")) {
            this.setStamina(nbtTagCompound.func_74760_g("Stamina"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        if (this.getOwnerName() == null) {
            nbtTagCompound.func_74778_a("Owner", "");
        } else {
            nbtTagCompound.func_74778_a("Owner", this.getOwnerName());
        }
        if (this.func_184753_b() == null) {
            nbtTagCompound.func_74778_a("OwnerUUID", "");
        } else {
            nbtTagCompound.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
        nbtTagCompound.func_74757_a("Sitting", this.isSitting());
        nbtTagCompound.func_74757_a("Following", this.isFollowing());
        nbtTagCompound.func_74757_a("Passive", this.isPassive());
        nbtTagCompound.func_74757_a("Aggressive", this.isAggressive());
        nbtTagCompound.func_74757_a("PVP", this.isPVP());
        nbtTagCompound.func_74776_a("Hunger", this.getCreatureHunger());
        nbtTagCompound.func_74776_a("Stamina", this.getStamina());
    }

    @Override
    public int func_70627_aG() {
        if (this.isTamed()) {
            return 600;
        }
        return super.func_70627_aG();
    }

    @Override
    protected SoundEvent func_184639_G() {
        String sound = "_say";
        if (this.isTamed() && this.func_110143_aJ() < this.func_110138_aP()) {
            sound = "_beg";
        }
        return AssetManager.getSound(this.mobInfo.name + sound);
    }

    public void playTameSound() {
        this.func_184185_a(AssetManager.getSound(this.mobInfo.name + "_tame"), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public void playEatSound() {
        this.func_184185_a(AssetManager.getSound(this.mobInfo.name + "_eat"), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    public static enum TAMED_ID {
        IS_TAMED(1),
        MOVE_SIT(2),
        MOVE_FOLLOW(4),
        STANCE_PASSIVE(8),
        STANCE_AGGRESSIVE(16),
        PVP(32);

        public final byte id;

        private TAMED_ID(byte value) {
            this.id = value;
        }

        public byte getValue() {
            return this.id;
        }
    }
}

