/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.handler;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;

public class SORecipes {
    private static List<CastingRecipe> tableCastRegistryWithFluidStack = Lists.newLinkedList();

    public ItemStack getCastingRecipes(FluidStack fluid, ItemStack itemStack) {
        CastingRecipe tableRecipe = TinkerRegistry.getTableCasting((ItemStack)itemStack, (Fluid)fluid.getFluid());
        CastingRecipe tableRecipeWithFluidStack = SORecipes.getTableCastingWithFluidStack(itemStack, fluid);
        if (tableRecipe != null) {
            return tableRecipe.getResult();
        }
        if (tableRecipeWithFluidStack != null) {
            return tableRecipeWithFluidStack.getResult();
        }
        return null;
    }

    public FluidStack getCastingFluidCost(FluidStack fluid, ItemStack itemStack) {
        CastingRecipe tableRecipe = TinkerRegistry.getTableCasting((ItemStack)itemStack, (Fluid)fluid.getFluid());
        CastingRecipe tableRecipeWithFluidStack = SORecipes.getTableCastingWithFluidStack(itemStack, fluid);
        CastingRecipe useAbleTableRecipe = null;
        if (tableRecipe != null) {
            useAbleTableRecipe = tableRecipe;
        } else if (tableRecipeWithFluidStack != null) {
            useAbleTableRecipe = tableRecipeWithFluidStack;
        }
        if (useAbleTableRecipe != null) {
            FluidStack tableFluid = useAbleTableRecipe.getFluid();
            if (tableFluid != null) {
                return tableFluid;
            }
            return null;
        }
        return null;
    }

    public boolean isPattern(ItemStack output) {
        Collection items = TinkerRegistry.getPatternItems();
        Item item = output.func_77973_b();
        for (Item i : items) {
            if (!item.equals(i)) continue;
            return true;
        }
        return false;
    }

    public FluidStack getBasinFluid(FluidStack fluid, ItemStack itemStack) {
        CastingRecipe basinRecipe = TinkerRegistry.getBasinCasting((ItemStack)itemStack, (Fluid)fluid.getFluid());
        if (basinRecipe != null) {
            FluidStack basinFluid = basinRecipe.getFluid();
            if (basinFluid != null) {
                return basinFluid;
            }
            return null;
        }
        return null;
    }

    public static void registerTableCastingWithFluidStack(CastingRecipe recipe) {
        tableCastRegistryWithFluidStack.add(recipe);
    }

    public static CastingRecipe getTableCastingWithFluidStack(ItemStack cast, FluidStack fluidstack) {
        for (CastingRecipe recipe : tableCastRegistryWithFluidStack) {
            if (!SORecipes.matches(cast, fluidstack, recipe)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean matches(ItemStack cast, FluidStack fluidStack, CastingRecipe recipe) {
        if (cast == null && recipe.cast == null || recipe.cast != null && recipe.cast.matches(new ItemStack[]{cast}) != null) {
            return recipe.getFluid().isFluidEqual(fluidStack);
        }
        return false;
    }
}

