/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.handler;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import tinker_io.handler.OreCrusherRecipe;
import tinker_io.registry.FluidRegister;
import tinker_io.registry.SmelteryRecipeRegistry;

public class PureMetalCastingRegistry {
    public static void registerPureMetalCasting() {
        String[] oreDicts = OreDictionary.getOreNames();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < oreDicts.length; ++i) {
            if (!OreCrusherRecipe.isOreDicAccepted(oreDicts[i])) continue;
            FluidStack fluidStack = new FluidStack((Fluid)FluidRegister.pureMetal, 144, new NBTTagCompound());
            fluidStack.tag.func_74778_a("oreDic", oreDicts[i]);
            if (PureMetalCastingRegistry.getOutput(fluidStack) == null) continue;
            SmelteryRecipeRegistry.registerSmaetOutputCasting(PureMetalCastingRegistry.getOutput(fluidStack), TinkerSmeltery.castIngot, fluidStack);
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        System.out.println("[Tinker I/O]Pure Metal casting registry loaded. Cost " + totalTime + " ms");
    }

    private static ItemStack getOutput(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        NBTTagCompound nbt = stack.tag;
        ItemStack oreStack = null;
        ItemStack resultStack = null;
        if (nbt != null && (oreStack = PureMetalCastingRegistry.getItemByOreDic(nbt.func_74779_i("oreDic"))) != null) {
            resultStack = FurnaceRecipes.func_77602_a().func_151395_a(oreStack);
        }
        return resultStack;
    }

    private static ItemStack getItemByOreDic(String oreDic) {
        List oreStack = OreDictionary.getOres((String)oreDic);
        ItemStack result = null;
        if (!oreStack.isEmpty()) {
            result = (ItemStack)oreStack.get(0);
        }
        return result;
    }
}

