/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;
import tinker_io.TileEntity.StirlingEngineTileEntity;
import tinker_io.main.Main;

public class StirlingEngine
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public StirlingEngine(String unlocalizedName) {
        super(Material.field_151576_e);
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(Main.TinkerIOTabs);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(3.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new StirlingEngineTileEntity();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean func_180648_a(World worldIn, BlockPos pos, IBlockState state, int eventID, int eventParam) {
        super.func_180648_a(worldIn, pos, state, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        String fuelAmountText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.liquidAmount", (Object[])new Object[0]);
        String fuelTempText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.liquidTemp", (Object[])new Object[0]);
        String energyStoredText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.energyStored", (Object[])new Object[0]);
        String generatePerTickText = I18n.func_135052_a((String)"tio.toolTips.StirlingEngine.generatePerTick", (Object[])new Object[0]);
        StirlingEngineTileEntity te = (StirlingEngineTileEntity)worldIn.func_175625_s(pos);
        if (te != null) {
            TileTank teTank = te.getTETank();
            if (teTank != null) {
                int liquidAmount = teTank.tank.getFluidAmount();
                FluidStack fluid = teTank.tank.getFluid();
                int fuildTemp = 0;
                if (fluid != null) {
                    fuildTemp = fluid.getFluid().getTemperature();
                }
                if (worldIn.field_72995_K) {
                    playerIn.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.WHITE + fuelAmountText + " : " + liquidAmount));
                    playerIn.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.WHITE + fuelTempText + " : " + fuildTemp));
                }
            }
            int energy = te.getEnergyStored(null);
            if (worldIn.field_72995_K) {
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.WHITE + energyStoredText + " : " + energy + " / " + te.getMaxEnergyStored(null) + " RF"));
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.WHITE + generatePerTickText + " : " + te.getGeneratePetTick() + " RF"));
                playerIn.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "-----"));
            }
        }
        return true;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            Block block = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
            Block block1 = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
            Block block2 = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
            Block block3 = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j() && !block1.func_149730_j()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j() && !block.func_149730_j()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j() && !block3.func_149730_j()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j() && !block2.func_149730_j()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null) {
            StirlingEngineTileEntity engine = (StirlingEngineTileEntity)te;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                engine.getStorage().setEnergyStored(nbt.func_74762_e("energy"));
            }
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176217_b(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos));
        }
        world.func_175698_g(pos);
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List items = super.getDrops(world, pos, state, fortune);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof StirlingEngineTileEntity) {
            StirlingEngineTileEntity engine = (StirlingEngineTileEntity)te;
            for (ItemStack item : items) {
                if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("energy", engine.getStorage().getEnergyStored());
                item.func_77982_d(tag);
            }
        }
        return items;
    }
}

