/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity.fim;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import tinker_io.TileEntity.fim.Adapter;
import tinker_io.TileEntity.fim.FIMTileEntity;
import tinker_io.TileEntity.fim.SCTileAdapter;
import tinker_io.api.vanilla.PosInfo;

public class SCInfo {
    private final FIMTileEntity fim;
    private final BlockPos FIMBlockPos;
    private final World worldObj;
    @Deprecated
    public BlockPos pos;
    @Deprecated
    public List<BlockPos> posList;
    public TileSmeltery sc;
    public Adapter adap;

    public SCInfo(FIMTileEntity tile) {
        this.fim = tile;
        this.FIMBlockPos = tile.func_174877_v();
        this.worldObj = tile.func_145831_w();
    }

    public boolean canFindSCPos() {
        return this.sc != null;
    }

    protected void update() {
    }

    protected void update(TileSmeltery tile) {
        this.sc = tile;
        this.adap = SCInfo.getAdapter(tile);
    }

    private List<BlockPos> findSCPos(BlockPos pos) {
        List<BlockPos> posList = PosInfo.getFacingList().stream().filter(f -> this.isSmelteryController(pos, (EnumFacing)f)).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).collect(Collectors.toList());
        return posList;
    }

    private boolean isOnlyOneSmelteryController(List list) {
        int amount = list.size();
        return amount == 1;
    }

    private List<Block> getAllAroundBlocks(BlockPos pos) {
        List<Block> blocks = PosInfo.getAllAmountBlockPosList(pos).stream().map(this::getBlock).collect(Collectors.toList());
        return blocks;
    }

    private boolean isSmelteryController(BlockPos pos, EnumFacing facing) {
        return SCInfo.isSmelteryController(this.getBlock(pos, facing));
    }

    public static boolean isSmelteryController(Block block) {
        return block == TinkerSmeltery.smelteryController;
    }

    private Block getBlock(BlockPos pos) {
        Block block = this.worldObj.func_180495_p(pos).func_177230_c();
        return block;
    }

    private Block getBlock(BlockPos pos, EnumFacing facing) {
        return this.getBlock(pos.func_177972_a(facing));
    }

    public static TileSmeltery getTileSmeltery(World world, BlockPos pos) {
        return (TileSmeltery)world.func_175625_s(pos);
    }

    public boolean isSCHeatingItem() {
        return this.adap.isHeatingItem() && !this.adap.isAllItemFinishHeating();
    }

    public Adapter getAdapter() {
        return this.adap;
    }

    public static Adapter getAdapter(TileSmeltery tile) {
        return new SCTileAdapter(tile);
    }

    public String getFacing() {
        String facing = PosInfo.getFacingList().stream().filter(f -> this.isSmelteryController(this.FIMBlockPos, (EnumFacing)f)).map(Enum::name).reduce((f, b) -> String.join((CharSequence)", ", f, b)).orElse("NONE");
        return facing;
    }

    public BlockPos getSCpos() {
        return this.pos;
    }
}

