/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity.fim;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;
import tinker_io.TileEntity.SidedInventory;
import tinker_io.TileEntity.fim.Adapter;
import tinker_io.TileEntity.fim.FuelFSM;
import tinker_io.TileEntity.fim.FuelFSMFactory;
import tinker_io.TileEntity.fim.SCInfo;
import tinker_io.TileEntity.fim.SCInfoFactory;
import tinker_io.api.Observable;
import tinker_io.api.Observer;
import tinker_io.reflection.TempField;
import tinker_io.registry.ItemRegistry;

public class FIMTileEntity
extends TileSmelteryComponent
implements ITickable,
Observable<Observer>,
ISidedInventory {
    private static final int[] slotsSpeedUPG = new int[]{0};
    private static final int[] slotsFuel = new int[]{1};
    public ItemStack fuel = new ItemStack(ItemRegistry.SolidFuel);
    private List<Observer> obs = new ArrayList<Observer>();
    protected SCInfo scInfo;
    protected FuelFSM fuelFSM = FuelFSMFactory.getNewFuelFSM(this);
    protected int tick = 0;
    public int keepInputTime;
    public int inputTime;
    public int fuelTemp;
    private SidedInventory inv = new SidedInventory((TileEntity)this, null, 2){

        public boolean func_94041_b(int index, ItemStack itemstack) {
            return TileEntityFurnace.func_145952_a((ItemStack)itemstack) > 0;
        }

        public int[] func_180463_a(EnumFacing side) {
            return slotsFuel;
        }

        public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
            return this.func_94041_b(index, itemStackIn);
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            return false;
        }

        public void func_70296_d() {
            throw new UnsupportedOperationException();
        }
    };

    public void onLoad() {
        this.scInfo = SCInfoFactory.getSmelyeryControllerInfo(this);
        this.fuelFSM.init();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tick % 4 == 0) {
                this.toUpdateSCInfoAndSpeedUpSC();
            }
            this.tick = (this.tick + 1) % 20;
        }
    }

    private void toUpdateSCInfoAndSpeedUpSC() {
        this.scInfo.update(this.getSmeltery());
        this.fuelFSM.func_73660_a();
        if (this.scInfo.canFindSCPos() && this.scInfo.isSCHeatingItem()) {
            this.fuelFSM.startChangeState();
            Adapter adap = this.scInfo.getAdapter();
            this.toSpeedUpSC(adap.getFuelTemp(), adap);
        }
        if (this.fuelFSM.isActive) {
            this.notifyObservers();
        }
    }

    private void toSpeedUpSC(int originFuelTemp, Adapter adap) {
        double ratio = this.getSpeedUpInfo().ratio;
        int fuelTempWithRatio = this.fuelTemp * (int)ratio;
        int f = fuelTempWithRatio / 2 + originFuelTemp;
        if (fuelTempWithRatio <= 20000) {
            f = fuelTempWithRatio * 6 / 100 + originFuelTemp;
        }
        if (f >= 200000) {
            f = 200000;
        }
        TempField field = new TempField(this.field_145850_b, adap.getPos());
        field.setTemp(f);
    }

    public int getSpeedUpTemp(int originFuelTemp) {
        return TileEntityFurnace.func_145952_a((ItemStack)this.inv.getSlot(1)) + originFuelTemp;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos neighbor) {
    }

    public int getStackSize(ItemStack stack) {
        return stack == null ? 0 : stack.field_77994_a;
    }

    @Override
    public void addObserver(Observer o) {
        this.obs.add(o);
    }

    @Override
    public void removeObserver(Observer o) {
        int index = this.obs.indexOf(o);
        if (index >= 0) {
            this.obs.remove(index);
        }
    }

    @Override
    public void notifyObservers() {
        for (Observer o : this.obs) {
            o.receivedTopic();
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputTime = tag.func_74765_d("InputTime");
        this.keepInputTime = tag.func_74765_d("keepInputTime");
        this.inv.readFromNBT(tag);
        this.fuelFSM.readFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("InputTime", (short)this.inputTime);
        tag.func_74777_a("keepInputTime", (short)this.keepInputTime);
        this.inv.writeToNBT(tag);
        this.fuelFSM.writeToNBT(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int pixels) {
        int n = this.inputTime < 0 ? 0 : this.inputTime;
        int i = this.keepInputTime;
        if (i == 0) {
            i = 1000;
        }
        return pixels - n * pixels / i;
    }

    public boolean hasFuel() {
        return this.inv.getSlot(1) != null && TileEntityFurnace.func_145952_a((ItemStack)this.inv.getSlot(1)) > 0;
    }

    public SpeedUpRatio getSpeedUpInfo() {
        double temp = (double)this.getStackSize(this.inv.getSlot(0)) * 0.1 + 1.0;
        return new SpeedUpRatio(temp);
    }

    @SideOnly(value=Side.CLIENT)
    public String getDirection() {
        return "NONE";
    }

    public int getInputTime() {
        return this.inputTime;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inv.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inv.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inv.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inv.func_174886_c(player);
    }

    public int func_174887_a_(int id) {
        throw new UnsupportedOperationException();
    }

    public void func_174885_b(int id, int value) {
        throw new UnsupportedOperationException();
    }

    public int func_174890_g() {
        throw new UnsupportedOperationException();
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inv.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inv.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.inv.func_145748_c_();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inv.func_94041_b(index, stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.inv.func_180463_a(side);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.inv.func_180461_b(index, itemStackIn, direction);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return this.inv.func_180461_b(index, stack, direction);
    }

    public ItemStack getSlot(int i) {
        return this.inv.getSlot(i);
    }

    public void setSlot(int i, ItemStack stack) {
        this.inv.setSlot(i, stack);
    }

    public static class SpeedUpRatio {
        public double ratio;

        public SpeedUpRatio(double temp) {
            this.ratio = temp;
        }
    }
}

