/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.multiblock.MultiServantLogic;
import tinker_io.handler.SORecipe;
import tinker_io.registry.ItemRegistry;

public class SOTileEntity
extends MultiServantLogic
implements IFluidHandler,
ISidedInventory,
ITickable {
    public FluidTank tank;
    public FluidStack otherLiquid;
    public FluidTankInfo[] otherTankInfo = null;
    public ItemStack[] itemStacksSO = new ItemStack[4];
    private static final int[] slotsPattern = new int[]{0};
    private static final int[] slotsProduct = new int[]{1};
    private static final int[] slotsUPGup = new int[]{2};
    private static final int[] slotsUPGdown = new int[]{3};
    int connection = 0;
    public int currentFrozenTime = 0;
    public int frozenTimeMax = 2;
    SORecipe recipes = new SORecipe();
    private String nameSO;
    boolean canFrozen = false;
    boolean canBasin = false;

    public SOTileEntity() {
        this.tank = new FluidTank(10000);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
        return amount;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.drain(resource, doDrain);
    }

    FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.tank.getFluidAmount() == 0) {
            return null;
        }
        if (this.tank.getFluid().getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
        return amount;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tank.getFluidAmount() == 0 || this.tank.getFluid().getFluid() == fluid && this.tank.getFluidAmount() < this.tank.getCapacity();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tank.getFluidAmount() > 0;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.getTankInfo();
    }

    public FluidTankInfo[] getTankInfo() {
        FluidStack fluid = null;
        if (this.tank.getFluid() != null) {
            fluid = this.tank.getFluid().copy();
        }
        return new FluidTankInfo[]{new FluidTankInfo(fluid, this.tank.getCapacity())};
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readCustomNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.currentFrozenTime = tags.func_74762_e("CurrentFrozenTime");
        if (tags.func_74767_n("hasFluid")) {
            if (tags.func_74762_e("itemID") == 0) {
                FluidStack tankFluid = FluidRegistry.getFluidStack((String)tags.func_74779_i("fluidName"), (int)tags.func_74762_e("amount"));
                if (tags.func_74779_i("fluidTag") != null) {
                    tankFluid = new FluidStack(tankFluid.getFluid(), tankFluid.amount, (NBTTagCompound)tags.func_74781_a("fluidTag"));
                }
                this.tank.setFluid(tankFluid);
            }
        } else {
            this.tank.setFluid(null);
        }
        NBTTagList tagList = tags.func_150295_c("Items", 10);
        this.itemStacksSO = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tabCompound1 = tagList.func_150305_b(i);
            byte byte0 = tabCompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.itemStacksSO.length) continue;
            this.itemStacksSO[byte0] = ItemStack.func_77949_a((NBTTagCompound)tabCompound1);
        }
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74768_a("CurrentFrozenTime", this.currentFrozenTime);
        FluidStack liquid = this.tank.getFluid();
        tags.func_74757_a("hasFluid", liquid != null);
        if (liquid != null) {
            tags.func_74778_a("fluidName", liquid.getFluid().getName());
            tags.func_74768_a("amount", liquid.amount);
            if (this.tank.getFluid() != null && this.tank.getFluid().tag != null) {
                tags.func_74782_a("fluidTag", (NBTBase)this.tank.getFluid().tag);
            }
        }
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.itemStacksSO.length; ++i) {
            if (this.itemStacksSO[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            this.itemStacksSO[i].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tags.func_74782_a("Items", (NBTBase)tagList);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.itemStacksSO.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.itemStacksSO[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemStacksSO[par1] != null) {
            if (this.itemStacksSO[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemStacksSO[par1];
                this.itemStacksSO[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemStacksSO[par1].func_77979_a(par2);
            if (this.itemStacksSO[par1].field_77994_a == 0) {
                this.itemStacksSO[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.itemStacksSO[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public int getLiquidAmount(int par1) {
        FluidTankInfo[] info = this.getTankInfo();
        FluidStack liquid = info[0].fluid;
        int capacity = 0;
        int liquidAmount = 0;
        int bar = 0;
        if (liquid != null && info != null) {
            liquidAmount = liquid.amount;
            capacity = info[0].capacity;
        } else {
            liquidAmount = 0;
            capacity = 0;
        }
        bar = liquidAmount != 0 && capacity != 0 ? (int)Math.floor((double)liquidAmount / (double)capacity * (double)par1) : 0;
        return bar;
    }

    public int getOutputSize() {
        int size = 1;
        ItemStack slotUPG1 = new ItemStack(ItemRegistry.Upgrade, 1, 1);
        ItemStack slotUPG2 = new ItemStack(ItemRegistry.Upgrade, 1, 2);
        ItemStack slotUPG3 = new ItemStack(ItemRegistry.Upgrade, 1, 3);
        ItemStack slotUPG4 = new ItemStack(ItemRegistry.Upgrade, 1, 4);
        if (this.itemStacksSO[2] != null) {
            if (this.itemStacksSO[2].func_77969_a(slotUPG1)) {
                size += this.itemStacksSO[2].field_77994_a * 1;
            } else if (this.itemStacksSO[2].func_77969_a(slotUPG2)) {
                size += this.itemStacksSO[2].field_77994_a * 2;
            } else if (this.itemStacksSO[2].func_77969_a(slotUPG3)) {
                size += this.itemStacksSO[2].field_77994_a * 3;
            } else if (this.itemStacksSO[2].func_77969_a(slotUPG4)) {
                size += this.itemStacksSO[2].field_77994_a * 4;
            }
        }
        if (this.itemStacksSO[3] != null) {
            if (this.itemStacksSO[3].func_77969_a(slotUPG1)) {
                size += this.itemStacksSO[3].field_77994_a * 1;
            } else if (this.itemStacksSO[3].func_77969_a(slotUPG2)) {
                size += this.itemStacksSO[3].field_77994_a * 2;
            } else if (this.itemStacksSO[3].func_77969_a(slotUPG3)) {
                size += this.itemStacksSO[3].field_77994_a * 3;
            } else if (this.itemStacksSO[3].func_77969_a(slotUPG4)) {
                size += this.itemStacksSO[3].field_77994_a * 4;
            }
        }
        if (size > 64) {
            return 64;
        }
        return size;
    }

    public boolean hasRedstoneUPG() {
        ItemStack redStoneUPG = new ItemStack(ItemRegistry.Upgrade, 1, 5);
        if (this.itemStacksSO[2] != null && this.itemStacksSO[2].func_77969_a(redStoneUPG)) {
            return true;
        }
        return this.itemStacksSO[3] != null && this.itemStacksSO[3].func_77969_a(redStoneUPG);
    }

    public boolean canFrozen() {
        FluidTankInfo[] info = this.getTankInfo();
        FluidStack liquid = info[0].fluid;
        boolean hasPowered = true;
        boolean canStart = false;
        if (!this.field_145850_b.field_72995_K) {
            boolean hasPower = this.field_145850_b.func_175640_z(this.field_174879_c);
            hasPowered = hasPower;
        }
        if (this.hasRedstoneUPG()) {
            if (hasPowered) {
                return false;
            }
            canStart = true;
        } else {
            canStart = true;
        }
        if (info != null && liquid != null && this.itemStacksSO[0] != null && canStart && this.recipes.getCastingFluidCost(liquid, this.itemStacksSO[0]) != null && this.recipes.getCastingFluidCost((FluidStack)liquid, (ItemStack)this.itemStacksSO[0]).amount <= liquid.amount && this.recipes.getCastingRecipes(liquid, this.itemStacksSO[0]) != null) {
            ItemStack itemstack = this.recipes.getCastingRecipes(liquid, this.itemStacksSO[0]);
            if (this.itemStacksSO[1] != null) {
                int result = this.itemStacksSO[1].field_77994_a + itemstack.field_77994_a;
                return result <= this.getOutputSize() && result <= this.func_70297_j_() && result <= this.itemStacksSO[1].func_77976_d() && this.itemStacksSO[1].func_77969_a(itemstack);
            }
            return true;
        }
        return false;
    }

    public void frozen() {
        FluidTankInfo[] info = this.getTankInfo();
        FluidStack liquid = info[0].fluid;
        if (this.canFrozen() && info != null) {
            ItemStack itemstack = this.recipes.getCastingRecipes(liquid, this.itemStacksSO[0]);
            ItemStack bucket = new ItemStack(Items.field_151133_ar);
            if (this.recipes.getCastingFluidCost(liquid, this.itemStacksSO[0]) != null && this.recipes.getCastingFluidCost((FluidStack)liquid, (ItemStack)this.itemStacksSO[0]).amount <= liquid.amount) {
                this.drain(this.recipes.getCastingFluidCost(liquid, this.itemStacksSO[0]), true);
                if (this.itemStacksSO[1] == null) {
                    this.itemStacksSO[1] = itemstack.func_77946_l();
                } else if (this.itemStacksSO[1].func_77973_b() == itemstack.func_77973_b()) {
                    this.itemStacksSO[1].field_77994_a += itemstack.field_77994_a;
                }
                if (this.recipes.isConsumeCast(liquid, this.itemStacksSO[0])) {
                    if (this.itemStacksSO[0].field_77994_a == 1) {
                        this.itemStacksSO[0] = null;
                    } else {
                        --this.itemStacksSO[0].field_77994_a;
                    }
                }
            }
        }
    }

    public void voidLiquid() {
        FluidTankInfo[] info = this.getTankInfo();
        FluidStack liquid = info[0].fluid;
        if (liquid != null) {
            int amount = liquid.amount;
            int toVoid = this.tank.drain((int)amount, (boolean)false).amount;
            this.tank.drain(toVoid, true);
            this.func_70296_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFrozenProgressScaled(int par1) {
        return this.currentFrozenTime * par1 / this.frozenTimeMax;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.field_145850_b.func_175689_h(this.field_174879_c);
        if (this.canFrozen()) {
            if (this.currentFrozenTime >= this.frozenTimeMax) {
                this.currentFrozenTime = 0;
                this.frozen();
            } else {
                ++this.currentFrozenTime;
            }
            this.func_70296_d();
        } else {
            this.currentFrozenTime = 0;
        }
    }

    public ItemStack func_70304_b(int index) {
        if (this.itemStacksSO[index] != null) {
            ItemStack itemstack = this.itemStacksSO[index];
            this.itemStacksSO[index] = null;
            return itemstack;
        }
        return null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.nameSO : StatCollector.func_74838_a((String)"tile.smart_output.name");
    }

    public boolean func_145818_k_() {
        return this.nameSO != null && this.nameSO.length() > 0;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        return slotsProduct;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return stack != null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }
}

