/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import tinker_io.TileEntity.TileEntityContainerAdapter;
import tinker_io.handler.OreCrusherBanList;
import tinker_io.registry.ItemRegistry;

public class OreCrusherTileEntity
extends TileEntityContainerAdapter
implements ITickable,
IEnergyReceiver {
    private final int[] slotsSpeedUPG = new int[]{0};
    private final int[] slotsOre = new int[]{1};
    private final int[] slotsProduct = new int[]{2};
    private final int[] slotsFortuneUPG1 = new int[]{3};
    private final int[] slotsFortuneUPG2 = new int[]{4};
    private final int[] slotsFortuneUPG3 = new int[]{5};
    protected EnergyStorage storage = new EnergyStorage(100000, 2000, 0);
    private int speed = 300;
    private int crushTime = 0;
    private int doubleProductRate;
    private String nameOreCrusher;

    public OreCrusherTileEntity() {
        super(null, 6);
    }

    public void nameOreCrusher(String string) {
        this.nameOreCrusher = string;
    }

    @Override
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.nameOreCrusher : StatCollector.func_74838_a((String)"tile.Ore_Crusher.name");
    }

    @Override
    public boolean func_145818_k_() {
        return this.nameOreCrusher != null && this.nameOreCrusher.length() > 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] slot = null;
        slot = side == EnumFacing.DOWN ? this.slotsProduct : this.slotsOre;
        return slot;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        OreCrusherBanList banList = OreCrusherBanList.banedOreDicList();
        return this.isOreInOreDic(itemStackIn) && banList.canItemCrush(itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 2;
    }

    public boolean func_94041_b(int index, ItemStack itemstack) {
        OreCrusherBanList banList = OreCrusherBanList.banedOreDicList();
        return this.isOreInOreDic(itemstack) && banList.canItemCrush(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCrushProgressScaled(int par1) {
        return this.crushTime * par1 / this.speed;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyBar(int par1) {
        return this.storage.getEnergyStored() * par1 / this.storage.getMaxEnergyStored();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.crush();
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void updateEntity() {
    }

    public boolean isOreInOreDic(ItemStack itemStack) {
        if (itemStack != null) {
            if (OreDictionary.getOreIDs((ItemStack)itemStack).length > 0) {
                int oreID = OreDictionary.getOreIDs((ItemStack)itemStack)[0];
                String oreName = OreDictionary.getOreName((int)oreID);
                String title = oreName.substring(0, 3);
                return title.equals("ore");
            }
            return false;
        }
        return false;
    }

    public String getOreDicName(ItemStack itemStack) {
        String oreDicName = null;
        if (itemStack != null && OreDictionary.getOreIDs((ItemStack)itemStack).length > 0) {
            int oreID = OreDictionary.getOreIDs((ItemStack)itemStack)[0];
            oreDicName = OreDictionary.getOreName((int)oreID);
        }
        return oreDicName;
    }

    private boolean isOreDicNBTTagEqual(ItemStack itemStack1, ItemStack itemStack2) {
        if (itemStack1 != null && itemStack2 != null && itemStack1.func_77978_p() != null && itemStack2.func_77978_p() != null) {
            NBTTagCompound nbt1 = itemStack1.func_77978_p();
            NBTTagCompound nbt2 = itemStack2.func_77978_p();
            if (nbt1.func_74779_i("oreDic").equals(nbt2.func_74779_i("oreDic"))) {
                return true;
            }
        }
        return false;
    }

    private ItemStack getProduct() {
        int productAmount = 2;
        if (this.canGetMoreProduct()) {
            productAmount = 3;
        }
        ItemStack product = new ItemStack(ItemRegistry.CrushedOre, productAmount);
        product.func_77982_d(new NBTTagCompound());
        NBTTagCompound nbt = product.func_77978_p();
        if (this.isOreInOreDic(this.getSlots()[1])) {
            nbt.func_74778_a("oreDic", this.getOreDicName(this.getSlots()[1]));
        }
        return product;
    }

    private boolean canGetMoreProduct() {
        int bookAmount = 0;
        ItemStack slotForutne1 = this.getSlots()[3];
        ItemStack slotForutne2 = this.getSlots()[4];
        ItemStack slotForutne3 = this.getSlots()[5];
        if (this.isFortuenEnchantedBook(slotForutne1)) {
            bookAmount += 2;
        }
        if (this.isFortuenEnchantedBook(slotForutne2)) {
            bookAmount += 2;
        }
        if (slotForutne3 != null && slotForutne3.func_77969_a(new ItemStack(ItemRegistry.Upgrade, 1, 6))) {
            bookAmount += 3;
        }
        this.doubleProductRate = 30 + bookAmount * 10;
        int rate = (int)(Math.random() * 99.0);
        return rate <= this.doubleProductRate;
    }

    public boolean isFortuenEnchantedBook(ItemStack itemstack) {
        return itemstack != null && this.getEnchantID(itemstack) == 35;
    }

    private int getEnchantID(ItemStack itemstack) {
        ItemEnchantedBook book;
        NBTTagCompound tag;
        if (itemstack != null && itemstack.func_77973_b() instanceof ItemEnchantedBook && (tag = (NBTTagCompound)(book = (ItemEnchantedBook)itemstack.func_77973_b()).func_92110_g(itemstack).func_179238_g(0)) != null) {
            return tag.func_74762_e("id");
        }
        return 0;
    }

    private boolean canCrush() {
        ItemStack product = this.getProduct();
        OreCrusherBanList banList = OreCrusherBanList.banedOreDicList();
        if (this.getSlots()[1] == null) {
            return false;
        }
        if (!this.isOreInOreDic(this.getSlots()[1]) || !banList.canItemCrush(this.getSlots()[1])) {
            return false;
        }
        if (this.getSlots()[2] == null && this.storage.getEnergyStored() > this.speed) {
            return true;
        }
        return this.getSlots()[2] != null && this.getSlots()[2].func_77969_a(product) && this.isOreDicNBTTagEqual(this.getSlots()[2], product) && this.storage.getEnergyStored() > this.speed && this.getSlots()[2].field_77994_a <= product.func_77976_d() - 3;
    }

    public int getRate() {
        return this.doubleProductRate;
    }

    public void crush() {
        ItemStack product = this.getProduct();
        if (this.canCrush()) {
            if (this.crushTime >= this.speed) {
                this.crushTime = 0;
                if (this.getSlots()[2] == null) {
                    this.getSlots()[2] = product.func_77946_l();
                } else if (this.getSlots()[2].func_77973_b() == product.func_77973_b()) {
                    this.getSlots()[2].field_77994_a += product.field_77994_a;
                }
                if (this.getSlots()[1].field_77994_a == 1) {
                    this.getSlots()[1] = null;
                } else {
                    --this.getSlots()[1].field_77994_a;
                }
            } else {
                ++this.crushTime;
                this.speedUPG();
                this.storage.setEnergyStored(this.storage.getEnergyStored() - 45);
            }
        } else {
            this.crushTime = 0;
        }
    }

    private void speedUPG() {
        ItemStack stackSpeedUPG = new ItemStack(ItemRegistry.SpeedUPG);
        if (this.getSlots()[0] != null && this.getSlots()[0].func_77969_a(stackSpeedUPG)) {
            this.crushTime += this.getSlots()[0].field_77994_a / 3 / 2;
        }
    }

    public boolean isActive() {
        return this.canCrush();
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.crushTime = tagCompound.func_74765_d("CrushTime");
        this.doubleProductRate = tagCompound.func_74762_e("Rate");
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.nameOreCrusher = tagCompound.func_74779_i("CustomName");
        }
        this.storage.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("CrushTime", (short)this.crushTime);
        tagCompound.func_74768_a("Rate", this.doubleProductRate);
        this.storage.writeToNBT(tagCompound);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(Math.min(this.storage.getMaxReceive(), maxReceive), simulate);
    }

    public EnergyStorage getStorage() {
        return this.storage;
    }
}

