/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.worldGenerators;

import de.comeight.crystallogy.util.Utilities;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenerator
implements IWorldGenerator {
    private Block block;
    private int chancesToSpawn;
    private int maxHeight;
    private int minHeight;
    private int maxSize;

    public WorldGenerator(Block block, int chancesToSpawn, int maxSize, int minHeight, int maxHeight) {
        this.block = block;
        this.chancesToSpawn = chancesToSpawn;
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
        this.maxSize = maxSize;
    }

    private void runGenerator(Random random, World world, int chunkX, int chunkZ) {
        chunkX *= 16;
        chunkZ *= 16;
        if (this.minHeight < 0 || this.maxHeight > 256 || this.minHeight > this.maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        for (int i = 0; i < this.chancesToSpawn; ++i) {
            int x = chunkX + random.nextInt(16);
            int y = Utilities.getRandInt(this.minHeight, this.maxHeight);
            int z = chunkZ + random.nextInt(16);
            WorldGenMinable wgM = new WorldGenMinable(this.block.func_176223_P(), this.maxSize);
            wgM.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.runGenerator(random, world, chunkX, chunkZ);
            }
        }
    }
}

