/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.util.armor;

import de.comeight.crystallogy.util.armor.ArmorListEntry;
import java.util.LinkedList;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CombinedArmorList {
    private static LinkedList<ArmorListEntry> list = new LinkedList();
    private static long lastCall = System.currentTimeMillis();

    public static void addArmor(ItemStack armor, UUID id) {
        int index = -1;
        index = CombinedArmorList.findEntryPos(id);
        if (index < 0) {
            ArmorListEntry entry = new ArmorListEntry(id);
            entry.addArmor(armor);
            list.add(entry);
        } else {
            list.get(index).addArmor(armor);
        }
    }

    public static ArmorListEntry getEntry(int index) {
        return list.get(index);
    }

    public static ArmorListEntry getEntry(UUID id) {
        for (ArmorListEntry armorListEntry : list) {
            if (armorListEntry.id.compareTo(id) != 0) continue;
            return armorListEntry;
        }
        return null;
    }

    public static ArmorListEntry removeEntry(UUID id) {
        int index = CombinedArmorList.findEntryPos(id);
        if (index < 0) {
            return null;
        }
        ArmorListEntry ret = list.get(index);
        list.remove(index);
        return ret;
    }

    public static ArmorListEntry removeEntry(int index) {
        if (index < 0) {
            return null;
        }
        ArmorListEntry ret = list.get(index);
        list.remove(index);
        return ret;
    }

    public static int findEntryPos(UUID id) {
        for (int i = 0; i < list.size(); ++i) {
            if (CombinedArmorList.list.get((int)i).id.compareTo(id) != 0) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasEntry(UUID id) {
        return CombinedArmorList.findEntryPos(id) >= 0;
    }

    public static void writeToNBT(UUID id, NBTTagCompound compound) {
        ArmorListEntry entry = CombinedArmorList.getEntry(id);
        if (entry != null) {
            entry.writeToNBT(compound);
        }
        CombinedArmorList.tryCleanup(false);
    }

    public static void readFromNBT(NBTTagCompound compound) {
        UUID id = compound.func_186857_a("id");
        int index = -1;
        index = CombinedArmorList.findEntryPos(id);
        if (index < 0) {
            list.add(new ArmorListEntry(compound));
        } else {
            list.get(index).readFromNBT(compound);
        }
        CombinedArmorList.tryCleanup(false);
    }

    public static void tryCleanup(boolean force) {
        if (!force && System.currentTimeMillis() - 10000L < lastCall) {
            return;
        }
        lastCall = System.currentTimeMillis();
        CombinedArmorList.runCleanup();
    }

    private static void runCleanup() {
        boolean foundOne;
        int count = 0;
        block0: do {
            foundOne = false;
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).isDead()) continue;
                list.remove(i);
                foundOne = true;
                ++count;
                continue block0;
            }
        } while (foundOne);
    }
}

