/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.util.armor;

import java.util.LinkedList;
import java.util.UUID;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ArmorListEntry {
    public UUID id;
    public long lastTimeActive;
    private LinkedList<ItemStack> list;

    public ArmorListEntry(UUID id) {
        this.id = id;
        this.list = new LinkedList();
        this.setActive();
    }

    public ArmorListEntry(NBTTagCompound compound) {
        this.readFromNBT(compound);
    }

    public void addArmor(ItemStack armor) {
        if (armor == null) {
            throw new NullPointerException("ItemStack == null! This is NOT allowed");
        }
        if (!(armor.func_77973_b() instanceof ItemArmor)) {
            throw new IllegalArgumentException("Item is no instance of ItemArmor!");
        }
        this.list.add(armor);
        this.setActive();
    }

    public ItemStack getArmor(int index) {
        return this.list.get(index);
    }

    public LinkedList<ItemStack> getList() {
        this.setActive();
        return this.list;
    }

    private void setActive() {
        this.lastTimeActive = System.currentTimeMillis();
    }

    public boolean isDead() {
        return System.currentTimeMillis() - this.lastTimeActive > 60000L;
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList armorList = new NBTTagList();
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.list.get(i).func_77955_b(stackTag);
            armorList.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a("armorList", (NBTBase)armorList);
        compound.func_186854_a("id", this.id);
        this.setActive();
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.list = new LinkedList();
        this.id = compound.func_186857_a("id");
        NBTTagList armorList = compound.func_150295_c("armorList", 10);
        for (int i = 0; i < armorList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = armorList.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            if (slot < 0) continue;
            this.list.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
        }
        this.setActive();
    }
}

