/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.util;

import com.sun.org.apache.xml.internal.security.utils.I18n;
import de.comeight.crystallogy.util.Log;
import java.util.Random;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Utilities {
    public static int getRandInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }

    public static double getRandDouble(double min, double max) {
        Random rand = new Random();
        double randomValue = min + (max - min) * rand.nextDouble();
        return randomValue;
    }

    public static float getRandFloat(float min, float max) {
        Random rand = new Random();
        float randomValue = min + (max - min) * rand.nextFloat();
        return randomValue;
    }

    public static double calcNewColorPercentage(double color, double modifire) {
        color += modifire;
        if ((color = Utilities.round((float)color, 2)) > 1.0) {
            color = 1.0;
        }
        if (color < 0.0) {
            color = 0.0;
        }
        return color;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static void addConsoleText(String text) {
        Log.info(text);
    }

    public static Vec3d vec3FormString(String s) {
        String s1 = s.substring(0, s.indexOf(")"));
        double posX = Double.parseDouble(s1.substring(1, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        double posY = Double.parseDouble(s1.substring(0, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        double posZ = Double.parseDouble(s1);
        return new Vec3d(posX, posY, posZ);
    }

    public static void printWorldSide(World worldObj) {
        if (worldObj.field_72995_K) {
            Utilities.addConsoleText("Side.Client!");
        } else {
            Utilities.addConsoleText("Side.Server!");
        }
    }

    public static String localizeText(String text) {
        return I18n.translate(text);
    }
}

