/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.util;

import de.comeight.crystallogy.util.StructureMaterialDescription;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureAreaDescription {
    private int[][] area;
    private ArrayList<StructureMaterialDescription> areaDescription;

    public StructureAreaDescription() {
        this.area = new int[5][5];
        this.areaDescription = new ArrayList();
    }

    public StructureAreaDescription(int[][] area) {
        this.area = area;
        this.areaDescription = new ArrayList();
    }

    public Block getBlockAtPos(int x, int y) {
        return this.getBlockFromType(this.getTypeAtPos(x, y));
    }

    public int getTypeAtPos(int x, int y) {
        return this.area[x][y];
    }

    public Block getBlockFromType(int type) {
        if (this.areaDescription != null) {
            for (int i = 0; i < this.areaDescription.size(); ++i) {
                if (this.areaDescription.get((int)i).type != type) continue;
                return this.areaDescription.get((int)i).block;
            }
        }
        return null;
    }

    public String toString() {
        String s = "{";
        for (int i = 0; i < this.areaDescription.size(); ++i) {
            s = s + this.areaDescription.get(i).toString() + ",";
        }
        s = s + "}";
        return s;
    }

    public void addBlockType(int type, Block block) {
        this.areaDescription.add(new StructureMaterialDescription(type, block));
    }

    public boolean testForStructure(World worldIn, BlockPos pos, int startX, int startZ) {
        BlockPos startPos = new BlockPos(pos.func_177958_n() - startX, pos.func_177956_o(), pos.func_177952_p() - startZ);
        for (int i = 0; i < this.area.length; ++i) {
            for (int e = 0; e < this.area[i].length; ++e) {
                IBlockState bS;
                if (this.area[i][e] == 0 || (bS = worldIn.func_180495_p(new BlockPos(startPos.func_177958_n() + i, startPos.func_177956_o(), startPos.func_177952_p() + e))).func_177230_c() == this.getBlockFromType(this.area[i][e])) continue;
                return false;
            }
        }
        return true;
    }

    private int getTypeCount(int type) {
        int count = 0;
        for (int i = 0; i < this.area.length; ++i) {
            for (int e = 0; e < this.area[i].length; ++e) {
                if (this.area[i][e] != type) continue;
                ++count;
            }
        }
        return count;
    }
}

