/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.util;

import java.awt.Color;
import net.minecraft.nbt.NBTTagCompound;

public class RGBColor {
    public float r;
    public float g;
    public float b;

    public RGBColor() {
    }

    public RGBColor(int rgbColor) {
        Color c = RGBColor.hex2Rgb(Integer.toHexString(rgbColor));
        this.r = (float)c.getRed() / 255.0f;
        this.g = (float)c.getGreen() / 255.0f;
        this.b = (float)c.getBlue() / 255.0f;
    }

    public RGBColor(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void setRGB(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void fromNBTTagCompound(NBTTagCompound compound, String key) {
        this.r = compound.func_74760_g(key + 'R');
        this.g = compound.func_74760_g(key + 'G');
        this.b = compound.func_74760_g(key + 'B');
    }

    public NBTTagCompound toNBTTagCompound(NBTTagCompound compound, String key) {
        compound.func_74776_a(key + 'R', this.r);
        compound.func_74776_a(key + 'G', this.g);
        compound.func_74776_a(key + 'B', this.b);
        return compound;
    }

    public static Color hex2Rgb(String colorStr) {
        if (colorStr.length() > 6) {
            colorStr = colorStr.substring(0, 6);
        }
        if (colorStr.length() < 6) {
            for (int i = 0; i < 6 - colorStr.length(); ++i) {
                colorStr = "0" + colorStr;
            }
        }
        colorStr = "0x" + colorStr;
        return Color.decode(colorStr);
    }
}

