/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.util;

import de.comeight.crystallogy.util.Log;
import net.minecraft.entity.player.EntityPlayer;

public enum EnumPlayerCapabilities {
    FLIGHT(0, "flight", false),
    DAMAGE(1, "damage", false),
    SPEED(2, "speed", false);

    private int id;
    private String name;
    private boolean enabled;
    private static final EnumPlayerCapabilities[] LOOKUP;

    private EnumPlayerCapabilities(int id, String name, boolean enabled) {
        this.id = id;
        this.name = name;
        this.enabled = enabled;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static EnumPlayerCapabilities getById(int id) {
        return LOOKUP[id];
    }

    public void setCapabilityForPlayer(EntityPlayer player, boolean enable) {
        if (enable) {
            switch (this.id) {
                case 0: {
                    player.field_71075_bZ.field_75101_c = true;
                    break;
                }
                case 1: {
                    player.field_71075_bZ.field_75102_a = true;
                    break;
                }
                case 2: {
                    player.field_71075_bZ.func_82877_b(0.12f);
                    player.field_71075_bZ.func_75092_a(0.06f);
                    break;
                }
                default: {
                    Log.error("Unknown Capabilities id:" + this.id);
                    break;
                }
            }
        } else {
            switch (this.id) {
                case 0: {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    break;
                }
                case 1: {
                    player.field_71075_bZ.field_75102_a = false;
                    break;
                }
                case 2: {
                    player.field_71075_bZ.func_82877_b(0.1f);
                    player.field_71075_bZ.func_75092_a(0.05f);
                    break;
                }
                default: {
                    Log.error("Unknown Capabilities id:" + this.id);
                }
            }
        }
    }

    static {
        LOOKUP = new EnumPlayerCapabilities[EnumPlayerCapabilities.values().length];
        EnumPlayerCapabilities[] enumPlayerCapabilitiesArray = EnumPlayerCapabilities.values();
        int n = enumPlayerCapabilitiesArray.length;
        for (int i = 0; i < n; ++i) {
            EnumPlayerCapabilities enumPlayerCapabilities;
            EnumPlayerCapabilities.LOOKUP[enumPlayerCapabilities.getId()] = enumPlayerCapabilities = enumPlayerCapabilitiesArray[i];
        }
    }
}

