/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.tileEntitys.machines;

import de.comeight.crystallogy.handler.BaseRecipeHandler;
import de.comeight.crystallogy.network.NetworkPacketTileEntitySync;
import de.comeight.crystallogy.tileEntitys.TileEntityInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public abstract class BaseTileEntityMachine
extends TileEntityInventory
implements ITickable,
ISidedInventory {
    protected int cookTime;
    protected int totalCookTime;
    public boolean crafting;
    protected BaseRecipeHandler recipeHandler;
    protected int slotsInput;
    protected int slotsOutput;

    public BaseTileEntityMachine(BaseRecipeHandler recipeHandler, int slotsInput, int slotsOutput) {
        super(slotsInput + slotsOutput);
        this.recipeHandler = recipeHandler;
        this.slotsInput = slotsInput;
        this.slotsOutput = slotsOutput;
        this.crafting = false;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index > this.slotsInput) {
            return false;
        }
        if (this.inventory[index] != null) {
            return this.inventory[index].func_77973_b() == stack.func_77973_b() && this.inventory[index].field_77994_a < this.inventory[index].func_77976_d();
        }
        return true;
    }

    public int getCookTime(ItemStack[] stack) {
        return this.recipeHandler.getTotalCookTime(stack);
    }

    public abstract void setBlockState();

    public ItemStack[] getInputSlots() {
        ItemStack[] ret = new ItemStack[this.slotsInput];
        for (int i = 0; i < this.slotsInput; ++i) {
            ret[i] = this.func_70301_a(i);
        }
        return ret;
    }

    public ItemStack[] getOutputSlots() {
        ItemStack[] ret = new ItemStack[this.slotsOutput];
        for (int i = 0; i < this.slotsOutput; ++i) {
            ret[i] = this.func_70301_a(this.slotsInput + i);
        }
        return ret;
    }

    public double fractionOfCookTimeComplete() {
        return (double)this.cookTime / (double)this.totalCookTime;
    }

    protected boolean canCraft() {
        int i;
        int i2;
        ItemStack[] output = this.recipeHandler.getResults(this.getInputSlots());
        if (output == null) {
            return false;
        }
        boolean flag1 = true;
        for (i2 = 0; i2 < this.slotsOutput; ++i2) {
            if (this.inventory[this.slotsInput + i2] == null) continue;
            flag1 = false;
            if (this.inventory[this.slotsInput + i2].field_77994_a < this.inventory[this.slotsInput + i2].func_77976_d()) continue;
            return false;
        }
        if (flag1) {
            return true;
        }
        for (i2 = 0; i2 < this.slotsOutput; ++i2) {
            if (this.inventory[this.slotsInput + i2].func_77973_b() == output[i2].func_77973_b()) continue;
            return false;
        }
        int[] resultStackSize = new int[this.slotsOutput];
        for (i = 0; i < this.slotsOutput; ++i) {
            resultStackSize[i] = this.inventory[this.slotsInput + i].field_77994_a + output[i].field_77994_a;
        }
        for (i = 0; i < this.slotsOutput; ++i) {
            if (resultStackSize[i] <= this.func_70297_j_() && resultStackSize[i] <= this.inventory[this.slotsInput + i].func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void craftItem() {
        if (this.canCraft()) {
            ItemStack[] res = this.recipeHandler.getResults(this.getInputSlots());
            for (int i = 0; i < this.slotsOutput; ++i) {
                if (this.inventory[this.slotsInput + i] == null) {
                    this.inventory[this.slotsInput + i] = res[i].func_77946_l();
                    continue;
                }
                if (this.inventory[this.slotsInput + i].func_77973_b() != res[i].func_77973_b()) continue;
                this.inventory[this.slotsInput + i].field_77994_a += res[i].field_77994_a;
            }
            int[] numOfInputs = this.recipeHandler.getNumberOfInputItems(this.getInputSlots());
            for (int i = 0; i < this.slotsInput; ++i) {
                if (this.inventory[i] == null || numOfInputs == null) continue;
                this.inventory[i].field_77994_a -= numOfInputs[i];
                if (this.inventory[i].field_77994_a > 0) continue;
                this.inventory[i] = null;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readAdditionalData(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeAdditionalData(compound);
        return compound;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void onCustomDataPacket(NetworkPacketTileEntitySync packet) {
        this.readAdditionalData(packet.getNBTTagCompound());
    }

    @Override
    public NetworkPacketTileEntitySync getCustomDataPacket(NBTTagCompound compound) {
        this.writeAdditionalData(compound);
        return new NetworkPacketTileEntitySync(this.field_174879_c, compound);
    }

    protected void readAdditionalData(NBTTagCompound compound) {
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.crafting = compound.func_74767_n("crushing");
    }

    protected void writeAdditionalData(NBTTagCompound compound) {
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.totalCookTime);
        compound.func_74757_a("crushing", this.crafting);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (this.crafting) {
                ++this.cookTime;
                if (this.cookTime >= this.totalCookTime) {
                    this.cookTime = 1;
                    this.crafting = false;
                }
            }
            return;
        }
        boolean flag1 = false;
        if (this.crafting) {
            if (!this.canCraft()) {
                this.crafting = false;
                this.cookTime = 1;
                this.sync();
            } else {
                ++this.cookTime;
                if (this.cookTime >= this.totalCookTime) {
                    this.cookTime = 1;
                    this.craftItem();
                    this.crafting = false;
                }
            }
            flag1 = true;
        } else if (this.inventory[0] != null && this.canCraft()) {
            flag1 = true;
            this.crafting = true;
            this.cookTime = 1;
            this.totalCookTime = this.getCookTime(this.getInputSlots());
            this.sync();
        }
        if (flag1) {
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.setBlockState();
            }
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] ret = new int[this.slotsInput + this.slotsOutput];
        for (int i = 0; i < this.slotsInput + this.slotsOutput; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index > this.slotsInput - 1;
    }
}

