/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.tileEntitys;

import com.mojang.authlib.GameProfile;
import de.comeight.crystallogy.CommonProxy;
import de.comeight.crystallogy.entity.PlayerClientDummy;
import de.comeight.crystallogy.network.NetworkPacketParticle;
import de.comeight.crystallogy.network.NetworkParticle;
import de.comeight.crystallogy.particles.ParticleB;
import de.comeight.crystallogy.tileEntitys.TileEntityEntityJar;
import de.comeight.crystallogy.util.Log;
import de.comeight.crystallogy.util.Utilities;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityPlayerJar
extends TileEntityEntityJar {
    protected GameProfile profile = null;

    @Override
    public void setEntity(EntityLivingBase entity) {
        if (entity instanceof PlayerClientDummy) {
            PlayerClientDummy player = (PlayerClientDummy)entity;
            this.profile = player.func_146103_bH();
            super.setEntity(entity);
        } else {
            Log.error("Entity is no instance of PlayerClientDummy!");
        }
    }

    @Override
    public boolean hasEntity() {
        return this.profile != null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeCustomDataToNBT(compound);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void readCustomDataToNBT(NBTTagCompound compound) {
        if (compound.func_74767_n("hasEntity")) {
            String name = compound.func_74779_i("name");
            UUID uuid = compound.func_186857_a("uuid");
            if (!name.equals("")) {
                this.profile = new GameProfile(uuid, name);
                if (this.field_145850_b != null) {
                    this.entity = new PlayerClientDummy(this.field_145850_b, this.profile);
                }
            }
        } else {
            this.entity = null;
            this.profile = null;
        }
    }

    @Override
    public void writeCustomDataToNBT(NBTTagCompound compound) {
        if (this.hasEntity()) {
            compound.func_74757_a("hasEntity", true);
            compound.func_74778_a("name", this.profile.getName());
            compound.func_186854_a("uuid", this.profile.getId());
        } else {
            compound.func_74757_a("hasEntity", false);
        }
    }

    @Override
    public void removeEntity(World worldIn, Vec3d pos, boolean release) {
        if (this.hasEntity() && release) {
            this.entity = null;
            this.profile = null;
            this.sync();
            if (worldIn.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    ParticleB gP = new ParticleB(worldIn, pos.field_72450_a + 0.5, pos.field_72448_b, pos.field_72449_c + 0.5, 0.0, 0.0, 0.0);
                    gP.setParticleMaxAge(120);
                    gP.func_70538_b(Utilities.getRandFloat(0.0f, 100.0f), Utilities.getRandFloat(0.0f, 100.0f), Utilities.getRandFloat(0.0f, 100.0f));
                    NetworkParticle nP = new NetworkParticle(gP, gP.name);
                    nP.setSize(new Vec3d(1.0, 2.0, 1.0));
                    nP.setNumberOfParticle(30);
                    NetworkPacketParticle pMtS = new NetworkPacketParticle(nP);
                    CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)pMtS);
                }
                worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, false));
                worldIn.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187533_aW, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187525_aO, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187855_gD, SoundCategory.BLOCKS, 1.0f, 0.6f);
            }
        }
    }

    @Override
    protected void tryCastOnEntity() {
        EntityPlayer ePlayer = this.getPlayerFromServer();
        if (ePlayer != null) {
            this.threat.castOnEntity(ePlayer.func_130014_f_(), (EntityLivingBase)ePlayer);
        }
    }

    private EntityPlayer getPlayerFromServer() {
        WorldServer server = (WorldServer)this.field_145850_b;
        PlayerList playerList = server.func_73046_m().func_184103_al();
        EntityPlayerMP ePlayer = null;
        ePlayer = playerList.func_177451_a(this.profile.getId());
        if (ePlayer == null) {
            ePlayer = playerList.func_152612_a(this.profile.getName());
        }
        return ePlayer;
    }
}

