/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.tileEntitys;

import de.comeight.crystallogy.CommonProxy;
import de.comeight.crystallogy.blocks.FarmersGreen;
import de.comeight.crystallogy.network.NetworkPacketParticle;
import de.comeight.crystallogy.network.NetworkPacketTileEntitySync;
import de.comeight.crystallogy.network.NetworkParticle;
import de.comeight.crystallogy.particles.ParticleB;
import de.comeight.crystallogy.tileEntitys.BaseTileEntity;
import de.comeight.crystallogy.util.Utilities;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityFarmersGreen
extends BaseTileEntity
implements ITickable {
    public int growthLeft = 0;
    private NBTTagCompound data;

    private boolean isActive() {
        return this.getBlockState() == 3;
    }

    private int getBlockState() {
        return (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)FarmersGreen.STATUS);
    }

    private void setBlockState(int state) {
        FarmersGreen.setBlockState(state, this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.requestSync();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeCustomDataToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomDataFromNBT(compound);
    }

    public void writeCustomDataToNBT(NBTTagCompound compound) {
        compound.func_74768_a("growthLeft", this.growthLeft);
    }

    public void readCustomDataFromNBT(NBTTagCompound compound) {
        this.growthLeft = compound.func_74762_e("growthLeft");
    }

    @Override
    public void onCustomDataPacket(NetworkPacketTileEntitySync packet) {
        this.func_145839_a(packet.getNBTTagCompound());
    }

    @Override
    public NetworkPacketTileEntitySync getCustomDataPacket(NBTTagCompound compound) {
        this.func_189515_b(compound);
        return new NetworkPacketTileEntitySync(this.field_174879_c, compound);
    }

    public void refuel() {
        this.growthLeft = 12000;
    }

    public void func_73660_a() {
        if (!this.isActive()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (Utilities.getRandInt(0, 5) == 0) {
                this.spawnActiveParticle();
            }
        } else {
            this.applyGrowth();
            if (this.growthLeft > 0) {
                --this.growthLeft;
            } else if (this.isActive()) {
                this.setBlockState(2);
            }
        }
    }

    private void applyGrowth() {
        int range = 3;
        for (int i = 0; i < 20; ++i) {
            BlockPos posGrowth = new BlockPos(this.field_174879_c.func_177958_n() + Utilities.getRandInt(-range, range + 1), this.field_174879_c.func_177956_o() + Utilities.getRandInt(-range, range + 1), this.field_174879_c.func_177952_p() + Utilities.getRandInt(-range, range + 1));
            IBlockState state = this.field_145850_b.func_180495_p(posGrowth);
            if (!(state.func_177230_c() instanceof IPlantable) && !(state.func_177230_c() instanceof IGrowable)) continue;
            state.func_177230_c().func_180650_b(this.field_145850_b, posGrowth, state, this.field_145850_b.field_73012_v);
            this.spawnParticlesNetwork(posGrowth);
        }
    }

    private void spawnActiveParticle() {
        ParticleB gP = new ParticleB(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, 0.2, 0.2, 0.2);
        gP.func_70538_b(Utilities.getRandFloat(0.0f, 0.5f), 1.0f, Utilities.getRandFloat(0.0f, 0.5f));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)gP);
    }

    private void spawnParticlesNetwork(BlockPos posGrowth) {
        ParticleB gP = new ParticleB(this.field_145850_b, (double)posGrowth.func_177958_n() + 0.5, posGrowth.func_177956_o(), (double)posGrowth.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        gP.setParticleMaxAge(60);
        gP.func_70538_b(Utilities.getRandFloat(0.0f, 0.5f), 1.0f, Utilities.getRandFloat(0.0f, 0.5f));
        NetworkParticle nP = new NetworkParticle(gP, gP.name);
        nP.setSize(new Vec3d(0.0, 0.0, 0.0));
        nP.setNumberOfParticle(3);
        NetworkPacketParticle pMtS = new NetworkPacketParticle(nP);
        CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)pMtS);
    }
}

