/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.tileEntitys;

import de.comeight.crystallogy.CommonProxy;
import de.comeight.crystallogy.handler.ItemHandler;
import de.comeight.crystallogy.items.threatDusts.ThreatDust;
import de.comeight.crystallogy.network.NetworkPacketParticle;
import de.comeight.crystallogy.network.NetworkPacketTileEntitySync;
import de.comeight.crystallogy.network.NetworkParticle;
import de.comeight.crystallogy.particles.ParticleB;
import de.comeight.crystallogy.tileEntitys.BaseTileEntity;
import de.comeight.crystallogy.util.RGBColor;
import de.comeight.crystallogy.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityEntityJar
extends BaseTileEntity
implements ITickable {
    protected EntityLivingBase entity = null;
    protected EnumThreats threat = null;
    protected int threatTick = 0;
    protected int tick = 0;
    protected boolean couldNotLoad = false;
    protected NBTTagCompound couldNotLoadCompund = null;

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public void setEntity(EntityLivingBase entity) {
        this.entity = entity;
        this.sync();
    }

    public void setThreat(EnumThreats threat) {
        this.threat = threat;
    }

    public EnumThreats getThreat() {
        return this.threat;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public void addThreat(EnumThreats threat) {
        this.threatTick = 0;
        this.threat = threat;
    }

    public void writeCustomDataToNBT(NBTTagCompound compound) {
        if (this.hasEntity()) {
            compound.func_74757_a("hasEntity", true);
            compound.func_74778_a("name", this.entity.func_70005_c_());
            compound.func_186854_a("uuid", this.entity.func_110124_au());
        } else {
            compound.func_74757_a("hasEntity", false);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeCustomDataToNBT(compound);
        super.func_189515_b(compound);
        return compound;
    }

    public void readCustomDataToNBT(NBTTagCompound compound) {
        if (compound.func_74767_n("hasEntity")) {
            this.couldNotLoad = true;
            this.couldNotLoadCompund = (NBTTagCompound)compound.func_74737_b();
        } else {
            this.entity = null;
        }
    }

    protected EntityLivingBase findEntity(UUID uuid) {
        List list = this.field_145850_b.func_72910_y();
        for (Entity entity : list) {
            if (!uuid.equals(entity.func_110124_au())) continue;
            return (EntityLivingBase)entity;
        }
        return null;
    }

    @Override
    public NetworkPacketTileEntitySync getCustomDataPacket(NBTTagCompound compound) {
        this.func_189515_b(compound);
        return new NetworkPacketTileEntitySync(this.field_174879_c, compound);
    }

    @Override
    public void onCustomDataPacket(NetworkPacketTileEntitySync packet) {
        this.func_145839_a(packet.getNBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.readCustomDataToNBT(compound);
        super.func_145839_a(compound);
    }

    public void removeEntity(World worldIn, Vec3d pos, boolean release) {
        if (this.hasEntity() && release) {
            this.entity = null;
            this.sync();
            if (worldIn.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    ParticleB gP = new ParticleB(worldIn, pos.field_72450_a + 0.5, pos.field_72448_b, pos.field_72449_c + 0.5, 0.0, 0.0, 0.0);
                    gP.setParticleMaxAge(120);
                    gP.func_70538_b(Utilities.getRandFloat(0.0f, 100.0f), Utilities.getRandFloat(0.0f, 100.0f), Utilities.getRandFloat(0.0f, 100.0f));
                    NetworkParticle nP = new NetworkParticle(gP, gP.name);
                    nP.setSize(new Vec3d(1.0, 2.0, 1.0));
                    nP.setNumberOfParticle(30);
                    NetworkPacketParticle pMtS = new NetworkPacketParticle(nP);
                    CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)pMtS);
                }
                worldIn.func_72942_c((Entity)new EntityLightningBolt(worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, false));
                worldIn.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187533_aW, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187525_aO, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_184148_a((EntityPlayer)null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187855_gD, SoundCategory.BLOCKS, 1.0f, 0.6f);
            }
        }
    }

    protected void incTick() {
        ++this.tick;
        if (this.tick >= 20) {
            this.tick = 0;
        }
    }

    public void func_73660_a() {
        if (!this.hasEntity()) {
            if (this.couldNotLoad) {
                UUID uuid = this.couldNotLoadCompund.func_186857_a("uuid");
                this.entity = this.findEntity(uuid);
            }
            if (this.threat != null) {
                this.threat = null;
            }
            return;
        }
        this.incTick();
        if (this.entity != null && this.entity.field_70128_L) {
            this.entity = null;
            if (!this.field_145850_b.field_72995_K) {
                this.sync();
            }
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (Utilities.getRandInt(0, 5) == 0) {
                double d1 = Utilities.getRandDouble(0.5, 0.7);
                double d2 = Utilities.getRandDouble(0.5, 0.7);
                double d3 = Utilities.getRandDouble(0.2, 0.6);
                this.field_145850_b.func_175688_a(EnumParticleTypes.WATER_WAKE, (double)this.field_174879_c.func_177958_n() + d1, (double)this.field_174879_c.func_177956_o() + 0.65, (double)this.field_174879_c.func_177952_p() + d2, 0.0, -0.015, 0.0, new int[0]);
                this.spawnThreatParticles();
            }
        } else if (this.tick == 10 && this.threat != null) {
            ++this.threatTick;
            this.tryCastOnEntity();
            if (this.threat.getNumOfCalls() <= this.threatTick) {
                this.threat = null;
                this.threatTick = 0;
            }
        }
    }

    protected void tryCastOnEntity() {
        if (this.hasEntity()) {
            this.threat.castOnEntity(this.entity.func_130014_f_(), this.entity);
        }
    }

    protected void spawnThreatParticles() {
        if (this.threat == null) {
            return;
        }
        ParticleB gP = new ParticleB(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + Utilities.getRandDouble(0.3, 0.7), (double)this.field_174879_c.func_177956_o() + Utilities.getRandDouble(0.2, 0.6), (double)this.field_174879_c.func_177952_p() + Utilities.getRandDouble(0.25, 0.9), 0.2, 0.2, 0.2);
        RGBColor color = this.threat.getColor();
        gP.func_70538_b(color.r, color.g, color.b);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)gP);
    }

    public static enum EnumThreats {
        POISON(new RGBColor(0.0f, 1.0f, 0.0f), ItemHandler.poisDust, 0),
        DAMAGE(new RGBColor(1.0f, 0.2f, 0.2f), ItemHandler.damDust, 1),
        FIRE(new RGBColor(1.0f, 0.0f, 0.0f), ItemHandler.fireDust, 2),
        DROWN(new RGBColor(0.0f, 0.0f, 1.0f), ItemHandler.drowDust, 3),
        HUNGER(new RGBColor(0.5f, 0.5f, 0.5f), ItemHandler.hungDust, 4),
        BADLUCK(new RGBColor(0.2f, 0.1f, 0.0f), ItemHandler.badLuckDust, 5),
        BLIND(new RGBColor(0.1f, 0.1f, 0.1f), ItemHandler.blindDust, 6),
        ENDER(new RGBColor(0.5f, 0.0f, 0.5f), ItemHandler.enderDust, 7),
        GLOW(new RGBColor(0.5f, 0.1f, 0.5f), ItemHandler.glowDust, 8),
        LEVITATION(new RGBColor(0.3f, 0.3f, 1.0f), ItemHandler.levDust, 9);

        private final int id;
        private final RGBColor color;
        private ThreatDust threatDust;
        private static ArrayList<EnumThreats> list;

        private EnumThreats(RGBColor color, ThreatDust threatDust, int id) {
            this.color = color;
            this.threatDust = threatDust;
            this.id = id;
        }

        public static EnumThreats getThreatDust(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof ThreatDust)) {
                return null;
            }
            for (EnumThreats threat : EnumThreats.values()) {
                if (threat.threatDust != stack.func_77973_b()) continue;
                return threat;
            }
            return null;
        }

        public int getNumOfCalls() {
            return this.threatDust.numOfCalls;
        }

        public void castOnEntity(World worldIn, EntityLivingBase entity) {
            this.threatDust.castOnEntity(worldIn, entity);
        }

        public int getID() {
            return this.id;
        }

        public RGBColor getColor() {
            return this.color;
        }

        public NBTTagCompound toNBTTagCompound(NBTTagCompound compound, String key) {
            compound.func_74768_a(key + "_EnumThreat", this.id);
            return compound;
        }

        public static EnumThreats fromNBTTagCompound(NBTTagCompound compound, String key) {
            int _id = compound.func_74762_e(key + "_EnumThreat");
            return EnumThreats.fromID(_id);
        }

        public static EnumThreats fromID(int _id) {
            for (EnumThreats threat : EnumThreats.values()) {
                if (threat.getID() != _id) continue;
                return threat;
            }
            return null;
        }

        static {
            list = new ArrayList();
        }
    }
}

