/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.tileEntitys;

import de.comeight.crystallogy.CommonProxy;
import de.comeight.crystallogy.handler.InfusionRecipeHandler;
import de.comeight.crystallogy.items.crafting.infusion.InfusionRecipe;
import de.comeight.crystallogy.network.NetworkPacketInfuserBlockEnabled;
import de.comeight.crystallogy.particles.InfuserBlockActiveParticle;
import de.comeight.crystallogy.renderer.InfusionAnimation;
import de.comeight.crystallogy.structures.StructureInfuser;
import de.comeight.crystallogy.tileEntitys.TileEntityInventory;
import de.comeight.crystallogy.util.StructureAreaDescription;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEnityInfuserBlock
extends TileEntityInventory
implements ITickable {
    public static final int invSize = 1;
    private int tick = 0;
    private StructureInfuser struct = new StructureInfuser();
    private boolean active;
    private InfuserBlockActiveParticle infuserBlockActiveParticle;
    private InfusionRecipe recipe;
    private InfusionAnimation infusionAnimation;

    public TileEnityInfuserBlock() {
        super(1);
        this.setActive(false);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.updateParticle();
    }

    @Override
    public String func_70005_c_() {
        return "TileEnityInfuserBlock";
    }

    protected ItemStack[] getSurroundingItemStacks() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        BlockPos[] surr = StructureInfuser.getSurroundingPedals(this.field_174879_c);
        for (int i = 0; i < surr.length; ++i) {
            TileEnityInfuserBlock tEI;
            TileEntity tE = this.field_145850_b.func_175625_s(surr[i]);
            if (!(tE instanceof TileEnityInfuserBlock) || (tEI = (TileEnityInfuserBlock)tE).func_70301_a(0) == null) continue;
            list.add(tEI.func_70301_a(0));
        }
        ItemStack[] stacks = new ItemStack[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stacks[i] = (ItemStack)list.get(i);
        }
        return stacks;
    }

    public void tryInfuse() {
        if (!this.active) {
            this.checkForStructure();
        }
        if (this.active) {
            if (this.recipe != null && this.recipe.isActive()) {
                return;
            }
            this.recipe = InfusionRecipeHandler.matchRecipes(this.func_70301_a(0), this.getSurroundingItemStacks());
            if (this.recipe != null) {
                this.recipe.cook(this.field_174879_c, StructureInfuser.getSurroundingPedals(this.field_174879_c), this.field_145850_b);
            } else {
                return;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    public void updateParticle() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NetworkPacketInfuserBlockEnabled message = new NetworkPacketInfuserBlockEnabled(new Vec3d((Vec3i)this.field_174879_c), this.active);
            CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)message);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.recipe != null && this.recipe.isActive()) {
                this.recipe.tick();
                this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.tick % 4 == 0) {
                this.updateParticle();
            }
            if (this.tick == 100) {
                this.setActive(this.checkForStructure());
            }
            if (this.tick > 200) {
                this.tick = 0;
            }
        } else if (this.infusionAnimation != null && this.infusionAnimation.isActive()) {
            this.infusionAnimation.tick();
        }
        ++this.tick;
    }

    public boolean checkForStructure() {
        StructureAreaDescription structureArea = this.struct.infuserArea;
        return structureArea.testForStructure(this.field_145850_b, this.func_174877_v(), 2, 2);
    }

    public void changeRecipeStatus(boolean status, WorldClient worldClient, int recipeIndex, boolean successfully) {
        if (status) {
            this.recipe = InfusionRecipeHandler.getRecipe(recipeIndex);
            this.infusionAnimation = new InfusionAnimation(this.field_174879_c, StructureInfuser.getSurroundingPedals(this.field_174879_c), this.field_145850_b, this.recipe.getTotalCookTime());
            this.infusionAnimation.start();
        } else if (this.infusionAnimation != null) {
            this.infusionAnimation.stop(successfully);
        }
    }

    public void changeParticleActive(Boolean status) {
        if (status.booleanValue()) {
            if (this.infuserBlockActiveParticle == null) {
                this.infuserBlockActiveParticle = new InfuserBlockActiveParticle(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                this.infuserBlockActiveParticle.setParticleMaxAge(10);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)this.infuserBlockActiveParticle);
            } else {
                this.infuserBlockActiveParticle.setParticleAge(0);
            }
        } else if (this.infuserBlockActiveParticle != null) {
            this.infuserBlockActiveParticle.func_187112_i();
            this.infuserBlockActiveParticle = null;
        }
    }
}

