/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.renderer;

import de.comeight.crystallogy.particles.InfusionParticle;
import de.comeight.crystallogy.tileEntitys.TileEnityInfuserBlock;
import de.comeight.crystallogy.util.Utilities;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class InfusionAnimation {
    private BlockPos center;
    private BlockPos[] surrounding;
    private World world;
    private int timeInMS;
    private boolean active;
    private int ticks;
    private InfusionParticle[] infusionParticles;

    public InfusionAnimation(BlockPos center, BlockPos[] surrounding, World world, int timeInMS) {
        this.center = center;
        this.surrounding = surrounding;
        this.world = world;
        this.timeInMS = timeInMS;
        this.active = false;
        this.ticks = 0;
        this.infusionParticles = null;
        this.setActiveInfusers();
    }

    public boolean isActive() {
        return this.active;
    }

    private void setActiveInfusers() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int i = 0; i < this.surrounding.length; ++i) {
            if (this.surrounding[i] != null) {
                TileEnityInfuserBlock tEI;
                TileEntity tE = this.world.func_175625_s(this.surrounding[i]);
                if (!(tE instanceof TileEnityInfuserBlock) || (tEI = (TileEnityInfuserBlock)tE).func_70301_a(0) == null) continue;
                list.add(this.surrounding[i]);
                continue;
            }
            System.out.println("null");
        }
        BlockPos[] a = new BlockPos[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            a[i] = (BlockPos)list.get(i);
        }
        this.surrounding = a;
    }

    public void start() {
        if (this.active) {
            return;
        }
        this.infusionParticles = new InfusionParticle[this.surrounding.length];
        for (int i = 0; i < this.surrounding.length; ++i) {
            if (this.center == null || this.surrounding[i] == null) continue;
            BlockPos p = this.surrounding[i];
            this.infusionParticles[i] = new InfusionParticle(this.world, 0.0, 0.0, 0.0, new Vec3d((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.75, (double)p.func_177952_p() + 0.5), new Vec3d((double)this.center.func_177958_n() + 0.5, (double)this.center.func_177956_o() + 0.75, (double)this.center.func_177952_p() + 0.5), this.timeInMS);
            this.infusionParticles[i].func_70538_b(Utilities.getRandFloat(0.0f, 1.0f), Utilities.getRandFloat(0.0f, 1.0f), Utilities.getRandFloat(0.0f, 1.0f));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)this.infusionParticles[i]);
        }
        this.active = true;
    }

    public void stop(boolean successfully) {
        if (!this.active) {
            return;
        }
        if (successfully) {
            this.world.func_184134_a((double)this.center.func_177958_n(), (double)this.center.func_177956_o(), (double)this.center.func_177952_p(), SoundEvents.field_187754_de, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        } else {
            this.world.func_184134_a((double)this.center.func_177958_n(), (double)this.center.func_177956_o(), (double)this.center.func_177952_p(), SoundEvents.field_187855_gD, SoundCategory.BLOCKS, 1.0f, Utilities.getRandFloat(0.55f, 1.25f), false);
        }
        for (int i = 0; i < this.infusionParticles.length; ++i) {
            if (this.infusionParticles[i] == null) continue;
            this.infusionParticles[i].func_187112_i();
        }
        this.active = false;
    }

    public void tick() {
        double x = (double)this.center.func_177958_n() + Utilities.getRandDouble(0.1, 0.9);
        double y = (double)this.center.func_177956_o() + Utilities.getRandDouble(0.5, 1.3);
        double z = (double)this.center.func_177952_p() + Utilities.getRandDouble(0.1, 0.9);
        this.world.func_175688_a(EnumParticleTypes.DRAGON_BREATH, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        if (this.ticks % 4 == 0) {
            this.world.func_175688_a(EnumParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.ticks == 0) {
            this.world.func_184134_a((double)this.center.func_177958_n(), (double)this.center.func_177956_o(), (double)this.center.func_177952_p(), SoundEvents.field_187658_bx, SoundCategory.BLOCKS, 1.0f, 0.75f, false);
        }
        this.ticks = this.ticks >= 20 ? 0 : ++this.ticks;
    }
}

