/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.particles;

import de.comeight.crystallogy.particles.BaseParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class JumpParticleBetweenCrystalls
extends BaseParticle {
    public static ResourceLocation[] rL = JumpParticleBetweenCrystalls.getTextures("crystallogy:particles/f", "f", 19);
    public static final String NAME = "1";
    private Vec3d targetPos;
    private Vec3d startPos;
    private double periode;
    private double div;

    public JumpParticleBetweenCrystalls(World world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Vec3d targetPos) {
        super(NAME, world, x, y, z, velocityX, velocityY, velocityZ);
        this.targetPos = targetPos;
        this.startPos = new Vec3d(x, y, z);
        this.noClip = true;
        this.field_70547_e = 2000;
        this.initVariables();
    }

    public JumpParticleBetweenCrystalls(String s) {
        if (s != null) {
            this.fromString(s);
            this.initVariables();
        }
    }

    public JumpParticleBetweenCrystalls() {
    }

    private void initVariables() {
        this.div = this.getDifference(this.field_187126_f, this.targetPos.field_72450_a);
        this.periode = Math.PI * 2 / this.getDifference(this.field_187126_f, this.targetPos.field_72450_a);
    }

    @Override
    protected void updateTexture() {
        this.tIndex += this.annimationSpeed;
        if (this.tIndex >= (double)rL.length) {
            this.tIndex = 0.0;
        }
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(rL[(int)this.tIndex].toString());
        this.func_187117_a(sprite);
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        this.moveParticle();
    }

    protected void moveParticle() {
        if (this.checkTargetReached()) {
            this.func_187112_i();
            return;
        }
        this.func_187110_a(this.calcMotionX(), this.calcMotionY(), this.calcMotionZ());
    }

    protected double getSin(double x) {
        return 0.15 * Math.sin(this.periode * x);
    }

    protected double calcMotionX() {
        if (this.targetPos.field_72450_a == this.field_187126_f) {
            return 0.0;
        }
        double differece = this.getDifference(this.targetPos.field_72450_a, this.field_187126_f);
        if (this.targetPos.field_72450_a > this.field_187126_f) {
            if (differece > 0.1) {
                return 0.05;
            }
            return differece;
        }
        if (differece > 0.1) {
            return -0.05;
        }
        return -differece;
    }

    protected double calcMotionY() {
        return this.getSin(this.div - this.getDifference(this.field_187126_f, this.targetPos.field_72450_a));
    }

    protected double calcMotionZ() {
        if (this.targetPos.field_72449_c == this.field_187128_h) {
            return 0.0;
        }
        double differece = this.getDifference(this.targetPos.field_72449_c, this.field_187128_h);
        if (this.targetPos.field_72449_c > this.field_187128_h) {
            if (differece > 0.1) {
                return 0.05;
            }
            return differece;
        }
        if (differece > 0.1) {
            return -0.05;
        }
        return -differece;
    }

    protected boolean checkTargetReached() {
        if (!this.checkTargetReachedX()) {
            return false;
        }
        if (!this.checkTargetReachedY()) {
            return false;
        }
        return this.checkTargetReachedZ();
    }

    protected boolean checkTargetReachedX() {
        return this.field_187126_f == this.targetPos.field_72450_a;
    }

    protected boolean checkTargetReachedY() {
        return this.field_187127_g == this.field_187124_d;
    }

    protected boolean checkTargetReachedZ() {
        return this.field_187128_h == this.targetPos.field_72449_c;
    }

    protected double getDifference(double val1, double val2) {
        if (val1 >= 0.0) {
            if (val2 >= 0.0) {
                if (val1 > val2) {
                    return val1 - val2;
                }
                return val2 - val1;
            }
            return val1 - val2;
        }
        if (val2 >= 0.0) {
            return val2 - val1;
        }
        if (val1 > val2) {
            return val1 - val2;
        }
        return val2 - val1;
    }

    @Override
    public String toString() {
        String s = this.targetPos.toString() + ";" + super.toString();
        return s;
    }

    @Override
    public void fromString(String s) {
        s = this.getTargetPos(s);
        super.fromString(s);
    }

    protected String getTargetPos(String s) {
        String s1 = s.substring(0, s.indexOf(")"));
        s = s.substring(s.indexOf(";") + 1);
        double x = Double.parseDouble(s1.substring(1, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        double y = Double.parseDouble(s1.substring(0, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        double z = Double.parseDouble(s1);
        this.targetPos = new Vec3d(x, y, z);
        return s;
    }
}

