/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.particles;

import de.comeight.crystallogy.particles.BaseParticle;
import de.comeight.crystallogy.util.Utilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class InfusionParticle
extends BaseParticle {
    public static ResourceLocation[] rL = InfusionParticle.getTextures("crystallogy:particles/n_color", "n", 32);
    public static final String NAME = "2";
    private Vec3d targetPos;
    private Vec3d startPos;
    private Vec3d difStartTarget;
    private int timeInTicks = 100;

    public InfusionParticle(World world, double velocityX, double velocityY, double velocityZ, Vec3d startPos, Vec3d targetPos, int timeInTicks) {
        super(NAME, world, startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c, velocityX, velocityY, velocityZ);
        this.targetPos = targetPos;
        this.startPos = startPos;
        this.timeInTicks = timeInTicks;
        this.noClip = true;
        this.setParticleMaxAge(timeInTicks);
        this.field_70544_f = Utilities.getRandFloat(3.0f, 5.0f);
        this.initVariables();
    }

    public InfusionParticle(String s) {
        if (s != null) {
            this.fromString(s);
            this.initVariables();
        }
    }

    public InfusionParticle() {
    }

    private void initVariables() {
        this.difStartTarget = this.startPos.func_178787_e(new Vec3d(-this.targetPos.field_72450_a, -this.targetPos.field_72448_b, -this.targetPos.field_72449_c));
        double x = this.difStartTarget.field_72450_a;
        double y = this.difStartTarget.field_72448_b;
        double z = this.difStartTarget.field_72449_c;
        if (x != 0.0) {
            x /= (double)this.timeInTicks;
        }
        if (y != 0.0) {
            y /= (double)this.timeInTicks;
        }
        if (z != 0.0) {
            z /= (double)this.timeInTicks;
        }
        this.difStartTarget = new Vec3d(-x, -y, -z);
    }

    @Override
    protected void updateTexture() {
        this.tIndex += this.annimationSpeed;
        if (this.tIndex >= (double)rL.length) {
            this.tIndex = 0.0;
        }
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(rL[(int)this.tIndex].toString());
        this.func_187117_a(sprite);
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        this.moveParticle();
    }

    protected void moveParticle() {
        this.func_187110_a(this.difStartTarget.field_72450_a, this.difStartTarget.field_72448_b, this.difStartTarget.field_72449_c);
        --this.timeInTicks;
        if (this.timeInTicks == 0) {
            this.func_187112_i();
        }
    }

    @Override
    public String toString() {
        String s = this.targetPos.toString() + ";" + super.toString();
        return s;
    }

    @Override
    public void fromString(String s) {
        s = this.getTargetPos(s);
        super.fromString(s);
    }

    protected String getTargetPos(String s) {
        String s1 = s.substring(0, s.indexOf(")"));
        s = s.substring(s.indexOf(";") + 1);
        double x = Double.parseDouble(s1.substring(1, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        double y = Double.parseDouble(s1.substring(0, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        double z = Double.parseDouble(s1);
        this.targetPos = new Vec3d(x, y, z);
        return s;
    }
}

