/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.particles;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;

public enum EnumCrystallogyParticleTypes {
    PARTICLE_A("particleA", 0),
    PARTICLE_B("particleB", 1),
    PARTICLE_C("particleC", 2),
    PARTICLE_D("particleD", 3),
    PARTICLE_E("particleE", 4),
    PARTICLE_F("particleF", 5),
    PARTICLE_N_COLOR("particleN_color", 6),
    JUMP_PARTICLE_BETWEEN_CRYSTALLS("jumpParticleBetweenCrystalls", 7),
    INFUSION_PARTICLE("infusionParticle", 8),
    LIGHT_PARTICLE("light_particle", 9);

    private final String particleName;
    private final int particleID;
    private static final Map<Integer, EnumCrystallogyParticleTypes> PARTICLES;
    private static final String[] PARTICLE_NAMES;

    private EnumCrystallogyParticleTypes(String particleNameIn, int particleIDIn) {
        this.particleName = particleNameIn;
        this.particleID = particleIDIn;
    }

    public static String[] getParticleNames() {
        return PARTICLE_NAMES;
    }

    public String getParticleName() {
        return this.particleName;
    }

    public int getParticleID() {
        return this.particleID;
    }

    public static EnumCrystallogyParticleTypes getParticleFromId(int particleId) {
        return PARTICLES.get(particleId);
    }

    static {
        PARTICLES = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        for (EnumCrystallogyParticleTypes enumparticletypes : EnumCrystallogyParticleTypes.values()) {
            PARTICLES.put(enumparticletypes.getParticleID(), enumparticletypes);
            if (enumparticletypes.getParticleName().endsWith("_")) continue;
            list.add(enumparticletypes.getParticleName());
        }
        PARTICLE_NAMES = list.toArray(new String[list.size()]);
    }
}

