/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.particles;

import de.comeight.crystallogy.util.RGBColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BaseParticle
extends Particle {
    public static final String NAME = "baseParticle";
    public String name;
    protected boolean noClip;
    private boolean canTickToDeath;
    protected double tIndex;
    protected double annimationSpeed;
    private static ResourceLocation[] rL;

    public BaseParticle(String name, World world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.name = name;
        this.tIndex = 0.0;
        this.annimationSpeed = 1.0;
        this.field_70547_e = 60;
        this.noClip = false;
        this.canTickToDeath = true;
        this.updateTexture();
    }

    public BaseParticle() {
        super(null, 0.0, 0.0, 0.0);
    }

    public BaseParticle(String s) {
        super(null, 0.0, 0.0, 0.0);
        if (s != null) {
            this.fromString(s);
        }
    }

    public Vec3d getPos() {
        return new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    protected static ResourceLocation[] getTextures(String dirPath, String name, int count) {
        try {
            ResourceLocation[] temp = new ResourceLocation[count];
            for (int i = 0; i < count; ++i) {
                temp[i] = new ResourceLocation(dirPath + "/" + name + i);
            }
            return temp;
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public boolean isCanTickToDeath() {
        return this.canTickToDeath;
    }

    public void setCanTickToDeath(boolean canTickToDeath) {
        this.canTickToDeath = canTickToDeath;
    }

    public void setParticleMaxAge(int ticks) {
        this.field_70547_e = ticks;
    }

    public int getParticleMaxAge() {
        return this.field_70547_e;
    }

    public void setParticleAge(int ticks) {
        this.field_70546_d = ticks;
    }

    public int getParticleAge() {
        return this.field_70546_d;
    }

    protected void updateTexture() {
        this.tIndex += this.annimationSpeed;
        if (this.tIndex >= (double)rL.length) {
            this.tIndex = 0.0;
        }
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(rL[(int)this.tIndex].toString());
        this.func_187117_a(sprite);
    }

    public int func_70537_b() {
        return 1;
    }

    public int func_189214_a(float partialTicks) {
        int FULL_BRIGHTNESS_VALUE = 0xF000F0;
        return 0xF000F0;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.canTickToDeath) {
            if (this.field_70547_e <= this.field_70546_d) {
                this.func_187112_i();
            }
            ++this.field_70546_d;
        }
        this.updateTexture();
    }

    public void func_187110_a(double x, double y, double z) {
        super.func_187110_a(x, y, z);
    }

    public String toString() {
        String s = new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h).toString() + ";" + this.func_70534_d() + ";" + this.func_70542_f() + ";" + this.func_70535_g() + ";" + this.field_70547_e + ";" + this.field_70544_f + ";" + this.noClip + ";";
        return s;
    }

    public void fromString(String s) {
        s = this.getCoordinates(s);
        s = this.getRGB(s);
        s = this.getMaxAge(s);
        s = this.getScale(s);
        s = this.getNoClip(s);
    }

    protected String getCoordinates(String s) {
        String s1 = s.substring(0, s.indexOf(")"));
        s = s.substring(s.indexOf(";") + 1);
        this.field_187126_f = Double.parseDouble(s1.substring(1, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        this.field_187127_g = Double.parseDouble(s1.substring(0, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        this.field_187128_h = Double.parseDouble(s1);
        return s;
    }

    protected String getRGB(String s) {
        RGBColor c = new RGBColor();
        c.r = Float.parseFloat(s.substring(0, s.indexOf(";")));
        s = s.substring(s.indexOf(";") + 1);
        c.g = Float.parseFloat(s.substring(0, s.indexOf(";")));
        s = s.substring(s.indexOf(";") + 1);
        c.b = Float.parseFloat(s.substring(0, s.indexOf(";")));
        s = s.substring(s.indexOf(";") + 1);
        this.func_70538_b(c.r, c.g, c.b);
        return s;
    }

    protected String getMaxAge(String s) {
        this.field_70547_e = Integer.parseInt(s.substring(0, s.indexOf(";")));
        return s.substring(s.indexOf(";") + 1);
    }

    protected String getScale(String s) {
        this.field_70544_f = Float.parseFloat(s.substring(0, s.indexOf(";")));
        return s.substring(s.indexOf(";") + 1);
    }

    protected String getNoClip(String s) {
        this.noClip = Boolean.parseBoolean(s.substring(0, s.indexOf(";")));
        return s.substring(s.indexOf(";") + 1);
    }
}

