/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.network;

import de.comeight.crystallogy.handler.ParticleHandler;
import de.comeight.crystallogy.particles.BaseParticle;
import de.comeight.crystallogy.particles.BaseParticleExtended;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;

public class NetworkParticle {
    private String type;
    private Vec3d size;
    private int numberOfParticle;
    private BaseParticle particle;

    public NetworkParticle() {
        this.type = "";
        this.particle = new BaseParticle();
        this.size = new Vec3d(0.0, 0.0, 0.0);
        this.numberOfParticle = 1;
    }

    public NetworkParticle(BaseParticle p, String type) {
        this.particle = p;
        this.type = type;
        this.size = new Vec3d(1.0, 2.0, 1.0);
        this.numberOfParticle = 1;
    }

    public NetworkParticle(BaseParticleExtended p, String type) {
        this.particle = p;
        this.type = type;
        this.size = new Vec3d(1.0, 2.0, 1.0);
        this.numberOfParticle = 1;
    }

    public NetworkParticle(String type, Vec3d coordinates, int maxAge) {
        this.type = type;
        this.particle = ParticleHandler.getBaseParticleFromType(type);
        this.particle.func_187109_b(coordinates.field_72450_a, coordinates.field_72448_b, coordinates.field_72449_c);
        this.particle.setParticleMaxAge(maxAge);
        this.size = new Vec3d(0.0, 0.0, 0.0);
        this.numberOfParticle = 1;
    }

    public int getNumberOfParticle() {
        return this.numberOfParticle;
    }

    public BaseParticle getParticle() {
        if (this.particle == null) {
            System.out.println("nullref");
        }
        return this.particle;
    }

    public void setParticle(BaseParticle particle) {
        this.particle = particle;
    }

    public void setNumberOfParticle(int numberOfParticle) {
        this.numberOfParticle = numberOfParticle;
    }

    public Vec3d getSize() {
        return this.size;
    }

    public void setSize(Vec3d dimension) {
        this.size = dimension;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        String s = this.type + ";";
        s = s + this.size.toString() + ";";
        s = s + this.numberOfParticle + ";";
        s = this.particle == null ? s + "null" : s + this.particle.toString();
        return s;
    }

    public void fromString(String s) {
        s = this.getType(s);
        s = this.getSize(s);
        if (!(s = this.getNumberOfParticle(s)).equals("null")) {
            this.particle = ParticleHandler.getBaseParticleFromType(this.type, s);
        }
    }

    private String getType(String s) {
        this.type = s.substring(0, s.indexOf(";"));
        return s.substring(s.indexOf(";") + 1);
    }

    private String getSize(String s) {
        String s1 = s.substring(0, s.indexOf(")"));
        s = s.substring(s.indexOf(";") + 1);
        double x = Double.parseDouble(s1.substring(1, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        double y = Double.parseDouble(s1.substring(0, s1.indexOf(",")));
        s1 = s1.substring(s1.indexOf(" ") + 1);
        double z = Double.parseDouble(s1);
        this.size = new Vec3d(x, y, z);
        return s;
    }

    private String getNumberOfParticle(String s) {
        this.numberOfParticle = Integer.parseInt(s.substring(0, s.indexOf(";")));
        return s.substring(s.indexOf(";") + 1);
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", this.type);
        tag.func_74780_a("sizeX", this.size.field_72450_a);
        tag.func_74780_a("sizeY", this.size.field_72448_b);
        tag.func_74780_a("sizeZ", this.size.field_72449_c);
        tag.func_74768_a("numberOfParticle", this.numberOfParticle);
        tag.func_74778_a("particle", this.particle.toString());
        return tag;
    }

    public void fromTag(NBTTagCompound tag) {
        if (tag != null) {
            this.type = tag.func_74779_i("type");
            this.size = new Vec3d(tag.func_74769_h("sizeX"), tag.func_74769_h("sizeY"), tag.func_74769_h("sizeZ"));
            this.numberOfParticle = tag.func_74762_e("numberOfParticle");
            String s = tag.func_74779_i("particle");
            if (!s.equals("null")) {
                this.particle = ParticleHandler.getBaseParticleFromType(this.type, s);
            }
        }
    }
}

