/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.network;

import de.comeight.crystallogy.network.BaseNetworkPacket;
import de.comeight.crystallogy.network.NetworkParticle;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class NetworkPacketParticle
extends BaseNetworkPacket {
    protected NetworkParticle nP;
    public static final Byte ID_SERVER = 44;
    public static final Byte ID_CLIENT = 45;

    public NetworkPacketParticle() {
        this.messageValid = false;
    }

    public NetworkPacketParticle(NetworkParticle nP) {
        if (nP == null) {
            this.messageValid = false;
        } else {
            this.nP = nP;
            this.messageValid = true;
        }
    }

    public NetworkParticle getNetworkParticle() {
        return this.nP;
    }

    @Override
    public String toString() {
        return "NetworkPacketParticleToServer[NetworkParticle=" + this.nP.toString() + "]";
    }

    @Override
    public void toBytes(ByteBuf buf) {
        if (!this.messageValid && this.nP != null) {
            return;
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nP.toTag());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        try {
            this.nP = new NetworkParticle();
            this.nP.fromTag(ByteBufUtils.readTag((ByteBuf)buf));
            this.messageValid = true;
        }
        catch (Exception e) {
            System.err.println("Exception while reading NetworkPacketParticleToServer: " + e);
            this.messageValid = false;
            return;
        }
    }
}

