/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.items.tools;

import de.comeight.crystallogy.CommonProxy;
import de.comeight.crystallogy.handler.ParticleHandler;
import de.comeight.crystallogy.items.BaseItem;
import de.comeight.crystallogy.network.NetworkPacketParticle;
import de.comeight.crystallogy.network.NetworkParticle;
import de.comeight.crystallogy.particles.BaseParticle;
import de.comeight.crystallogy.util.RGBColor;
import de.comeight.crystallogy.util.ToolTipBuilder;
import de.comeight.crystallogy.util.Utilities;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Vaporizer
extends BaseItem {
    public static final String ID = "vaporizer";
    private final String particleType;
    private final RGBColor color;
    private final int maxTime;
    private final int numberOfParticle;
    private final Vec3d size;
    private boolean activated;

    public Vaporizer() {
        super(ID);
        this.func_77625_d(1);
        this.particleType = "a";
        this.color = new RGBColor(0.0f, 0.0f, 0.0f);
        this.maxTime = 60;
        this.numberOfParticle = 10;
        this.size = new Vec3d(1.0, 2.0, 1.0);
        this.activated = false;
    }

    public Vaporizer(String ID) {
        super(ID);
        this.func_77625_d(1);
        this.particleType = "a";
        this.color = new RGBColor(0.0f, 0.0f, 0.0f);
        this.maxTime = 60;
        this.numberOfParticle = 10;
        this.size = new Vec3d(1.0, 2.0, 1.0);
        this.activated = false;
    }

    public int getNumberOfParticle() {
        return this.numberOfParticle;
    }

    public Vec3d getSize() {
        return this.size;
    }

    public String getParticleType() {
        return this.particleType;
    }

    public RGBColor getColor() {
        return this.color;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        NBTTagCompound c = stack.func_77978_p();
        if (c == null) {
            return false;
        }
        return c.func_74767_n("activated");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (stack.func_77978_p() == null) {
            return;
        }
        if (stack.func_77978_p().func_74767_n("activated") && Utilities.getRandInt(0, 3) == 0) {
            Vec3d coords = entityIn.func_174824_e(1.0f).func_178786_a(0.0, (double)entityIn.func_70047_e(), 0.0);
            this.spawnParticles(coords, stack, worldIn, (EntityPlayer)entityIn);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        if (playerIn.func_70093_af()) {
            NBTTagCompound c = itemStackIn.func_77978_p();
            if (c == null) {
                itemStackIn = this.saveNBT(itemStackIn);
            }
            c.func_74757_a("activated", !c.func_74767_n("activated"));
        } else {
            Vec3d coords = playerIn.func_174824_e(1.0f).func_178786_a(0.0, (double)playerIn.func_70047_e(), 0.0);
            this.spawnParticles(coords, itemStackIn, worldIn, playerIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public void spawnParticles(Vec3d coords, ItemStack stack, World worldIn, EntityPlayer playerIn) {
        NBTTagCompound c = stack.func_77978_p();
        if (c == null) {
            stack = this.saveNBT(stack);
        }
        String type = c.func_74779_i("particleType");
        BaseParticle p = ParticleHandler.getBaseParticleFromType(type);
        p.func_187109_b(coords.field_72450_a, coords.field_72448_b, coords.field_72449_c);
        p.setParticleMaxAge(c.func_74762_e("maxTime"));
        NetworkParticle nP = new NetworkParticle(p, type);
        nP.getParticle().func_70538_b(c.func_74760_g("r"), c.func_74760_g("g"), c.func_74760_g("b"));
        nP.setSize(new Vec3d(c.func_74769_h("sizeX"), c.func_74769_h("sizeY"), c.func_74769_h("sizeZ")));
        nP.setNumberOfParticle(c.func_74762_e("numberOfParticle"));
        NetworkPacketParticle message = new NetworkPacketParticle(nP);
        CommonProxy.NETWORKWRAPPER.sendToServer((IMessage)message);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound == null) {
            stack = this.saveNBT(stack);
            tooltip.add(TextFormatting.DARK_RED + "THIS IS A BUG!!" + TextFormatting.RESET);
            tooltip.add("Delete the item!");
            tooltip.add("Type: -");
            tooltip.add("Color: R= -, G= -, B= -");
            tooltip.add("Max particle age: -");
            tooltip.add("Size: X= -, Y= -, Z= -");
            tooltip.add("Number of particles: -");
            tooltip.add("Activated: -");
        } else {
            if (nbtTagCompound.func_74767_n("activated")) {
                tooltip.add("Activated: " + TextFormatting.DARK_GREEN + "true" + TextFormatting.RESET);
            } else {
                tooltip.add("Activated: " + TextFormatting.DARK_RED + "false" + TextFormatting.RESET);
            }
            if (GuiScreen.func_146272_n()) {
                tooltip.add("");
                tooltip.add("Type: " + nbtTagCompound.func_74779_i("particleType"));
                tooltip.add("Color: " + TextFormatting.DARK_RED + "R" + TextFormatting.GRAY + "=" + 255.0f * nbtTagCompound.func_74760_g("r") + ", " + TextFormatting.DARK_GREEN + "G" + TextFormatting.GRAY + "=" + 255.0f * nbtTagCompound.func_74760_g("g") + ", " + TextFormatting.DARK_BLUE + "B" + TextFormatting.RESET + "=" + 255.0f * nbtTagCompound.func_74760_g("b"));
                tooltip.add("Max particle age: " + nbtTagCompound.func_74762_e("maxTime"));
                tooltip.add("Size: X= +-" + nbtTagCompound.func_74769_h("sizeX") + ", Y= +" + nbtTagCompound.func_74769_h("sizeY") + ", Z= +-" + nbtTagCompound.func_74769_h("sizeZ"));
                tooltip.add("Number of particles: " + nbtTagCompound.func_74762_e("numberOfParticle"));
            } else {
                ToolTipBuilder.addShiftForMoreDetails(tooltip);
            }
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public ItemStack saveNBT(ItemStack stack) {
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        nbtTagCompound.func_74778_a("particleType", this.particleType);
        nbtTagCompound.func_74776_a("r", this.color.r);
        nbtTagCompound.func_74776_a("g", this.color.g);
        nbtTagCompound.func_74776_a("b", this.color.b);
        nbtTagCompound.func_74768_a("maxTime", this.maxTime);
        nbtTagCompound.func_74768_a("numberOfParticle", this.numberOfParticle);
        nbtTagCompound.func_74780_a("sizeX", this.size.field_72450_a);
        nbtTagCompound.func_74780_a("sizeY", this.size.field_72448_b);
        nbtTagCompound.func_74780_a("sizeZ", this.size.field_72449_c);
        nbtTagCompound.func_74757_a("activated", this.activated);
        stack.func_77982_d(nbtTagCompound);
        return stack;
    }

    public ItemStack getItemStack() {
        return this.saveNBT(new ItemStack((Item)this));
    }
}

