/*
 * Decompiled with CFR 0.152.
 */
package de.comeight.crystallogy.items.tools;

import com.mojang.authlib.GameProfile;
import de.comeight.crystallogy.entity.PlayerClientDummy;
import de.comeight.crystallogy.items.tools.BaseCrystalKnife;
import de.comeight.crystallogy.tileEntitys.TileEntityPlayerJar;
import de.comeight.crystallogy.util.ToolTipBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerCrystalKnife
extends BaseCrystalKnife {
    public static final String ID = "playerCrystalKnife";
    private float attackDamage;

    public PlayerCrystalKnife() {
        super(ID);
    }

    private GameProfile getGameProfile(ItemStack stack) {
        NBTTagCompound c = stack.func_77978_p();
        String name = c.func_74779_i("name");
        String uuid = c.func_74779_i("uuid");
        GameProfile p = new GameProfile(UUID.fromString(uuid), name);
        return p;
    }

    @Override
    public ItemStack saveNBT(ItemStack stack, EntityLivingBase entity) {
        stack = this.saveEmptyNBT(stack);
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            nbtTagCompound.func_74778_a("name", player.func_146103_bH().getName());
            nbtTagCompound.func_74778_a("uuid", player.func_146103_bH().getId().toString());
            stack.func_77982_d(nbtTagCompound);
        }
        return stack;
    }

    @Override
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityPlayerJar tE;
        if (this.hasEntity(stack) && worldIn.func_175625_s(pos) instanceof TileEntityPlayerJar && !(tE = (TileEntityPlayerJar)worldIn.func_175625_s(pos)).hasEntity()) {
            tE.setEntity((EntityLivingBase)new PlayerClientDummy(worldIn, this.getGameProfile(stack)));
            stack = this.removeEntity(stack, worldIn, playerIn.func_174791_d(), false);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound == null) {
            stack = this.saveEmptyNBT(stack);
            tooltip.add(TextFormatting.GOLD + "Name:" + TextFormatting.RESET + " -");
            tooltip.add(TextFormatting.GOLD + "UUID:" + TextFormatting.RESET + " -");
        } else {
            if (this.hasEntity(stack)) {
                tooltip.add("Has Player: " + TextFormatting.DARK_GREEN + "Yes");
            } else {
                tooltip.add("Has Player: " + TextFormatting.DARK_RED + "No");
            }
            if (GuiScreen.func_146272_n()) {
                tooltip.add("");
                tooltip.add(TextFormatting.GOLD + "Name: " + TextFormatting.RESET + nbtTagCompound.func_74779_i("name"));
                tooltip.add(TextFormatting.GOLD + "UUID: " + TextFormatting.RESET + nbtTagCompound.func_74779_i("uuid"));
            } else {
                ToolTipBuilder.addShiftForMoreDetails(tooltip);
            }
        }
    }

    @Override
    protected ItemStack saveEmptyNBT(ItemStack stack) {
        stack = super.saveEmptyNBT(stack);
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        nbtTagCompound.func_74778_a("uuid", "-");
        stack.func_77982_d(nbtTagCompound);
        return stack;
    }

    public ItemStack saveNBT(ItemStack stack, EntityPlayer player) {
        stack = this.saveEmptyNBT(stack);
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        nbtTagCompound.func_74778_a("name", player.func_146103_bH().getName());
        nbtTagCompound.func_74778_a("uuid", player.func_146103_bH().getId().toString());
        stack.func_77982_d(nbtTagCompound);
        return stack;
    }
}

